capture log close
clear all
set more off, perm
set matsize 400
version 14.1

/******************************************************************************* 
* 
* Replication files for:
*	Tougher et al.  "Effect of a multifaceted social franchising model on quality 
*		and coverage of maternal, newborn, and reproductive health-care services 
*		in Uttar Pradesh, India: a quasi-experimental study." The Lancet Global 
*		Health. (2018)
*
*	http://www.thelancet.com/journals/langlo/article/PIIS2214-109X(17)30454-0/fulltext			
* 
* MASTER DO FILE - DATA CLEANING
*
* Last updated 11/06/2018 by ST
*
*******************************************************************************/


/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. NOTES
* 	1.1	Description
* 	1.2 Steps to run the file
* 2. SET PATH
* 3. RUN DO FILES FOR PREPARING DATA
*	3.1 First round of data collection
*	3.2 Second round of data collection
*
*******************************************************************************/

* SECTION 1 - NOTES 

** 1.1 Description
* 	This code cleans the survey data from the two rounds of data collection.

** 1.2 Steps to run the file
/*
1) 	Ensure that you have the following user-written commands installed:
		-excelcol
		-fdsrmxt [fdsrmxt.ado must be obtained from the study author] 
		-coefplot

2) 	Save the Matrika_Rep folder to the directory of your choosing. This folder 
	contains all subfolders required to run the analysis.

3) 	Set the directory in Section 2 of this do file. The path specified should 
	include the folder structure up to Matrika_Rep */
	
	
* SECTION 2 - SET PATH  
/*	Set your directory here. The path specified should include your folder 
	structure up to Matrika_Rep */
	
global master "C:\Sync\My Files\Sync\Projects\MET\Matrika\Matrika_Rep\"

* SECTION 3 - RUN DO FILES FOR PREPARING DATA
/* The do files called in below complete various data management to clean the 
   individual data sets from each survey round. Data management here includes:
	-merging pertinent project administration data to the household survey data
	-creating variables for study outcomes and covariates
	-creating variables indicating whether the eligible woman's most recent birth 
	occured before or after the start of social franchising 
	-saving cleaned versions of the data set

	(Note: 	additional data management, such as appending data sets from each survey 
			round is also conducted in the file 02_data_management in the analysis\code
			subfolder.)
*/

** 3.1 First round of data cleaning 
cd "$master\build\temp"
log using 01_master_data, replace

cd "$master\build\code"
do 01_master_data.do

log close

** 3.2 Second round of data collection
cd "$master\build\temp"
log using 02_master_data_end, replace

cd "$master\build\code"
do 02_master_data_end.do

log close

