/*******************************************************************************
*
* Replication of Tougher et al (2018)
* 	
* 	TABLE 2: Estimated effect of the Matrika programme on antenatal care outcomes
*
*	TABLE 3: Estimated effect of the Matrika programme on delivery care outcomes
*
*	TABLE 4: Estimated effect of the Matrika programme on post-partum and newborn 
*			 outcomes
*
*   Last updated 01/06/2018 by ST
*
*******************************************************************************/

	/*Note: All contents of Tables 2-4 are produced in this file, with the exception 
			of the FWER-adjusted pvalues, which are added to the table in 05_fwer_adjust.do  */

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. LOADING DATA SET 
* 2. SETTING UP THE OUTPUT FILE
* 3. FORMATTING 
* 4. TABLE TITLE
* 5. COLUMN TITLES 
* 6. ROW TITLES
* 7. INPUTTING DATA
*	7.1 Group means
*	7.2 Treatment effects
*******************************************************************************/

* 1. LOADING DATA SET
cd "$master"
use "build\output\master_data_complete.dta", clear

cd "$master\analysis\output"

* 2. SETTING UP THE OUTPUT FILE
putexcel set Tables2_4.xlsx, replace
	*Note: The contents of Tables 2-4 are outputted to a single file.  

* 3. FORMATTING	
putexcel (B2:C2) (E2:F2) (H2:K2), merge border(bottom) hcenter
putexcel (A2:K2), border(top)
putexcel (A3:K3), border(bottom)

* 4. TABLE TITLE
putexcel A1 = "Tables 2-4. Estimated effect of the Matrika social franchising programme", font($fontTitle)

* 5. COLUMN TITLES
putexcel A2 = "Outcome" B2 = "Before introduction" E2 = "After introduction", font($font)
putexcel B3 = "Intervention" C3 = "Control" E3 = "Intervention" F3 = "Control" ///
	H3 = "Treatment effect" I3 = "Per comparison p value" ///
	J3 = "FWER adjusted p value" K3 = "N", font($font) hcenter

* 6. ROW TITLES
local r =3 //row counter
foreach fam of global hypoth{
	local r = `r'+1
	local varLab : variable label `fam'
	putexcel A`r' =  "`varLab'", font($font)
	putexcel (A`r':K`r'), border(top)
		foreach var of global `fam'{
		local r = `r'+1
		local varLab : variable label `var'
		putexcel A`r' =  "`varLab'", font($font) txtindent(3)
		}
}

* 7. INPUTTING DATA
** 7.1 Group means
local c = 1 //column counter
local i = 0 // level of interv_period counter
local colNames B C E F
foreach col of local colNames {
	local r = 3 //row counter
	local i = `i'+1
	use "$master\build\output\master_data_complete.dta", clear	
	 	foreach cat of global hypothPt1 {
			local r = `r'+1
				foreach var of global `cat'{
				local r = `r'+1
				mean `var' if interv_period==`i' 
				matrix b = e(b)
				local mean=b[1,1]
				putexcel `col'`r' = `mean'*100, font($font) nformat(0) hcenter
				}
		}
	use "$master\build\output\master_data_complete_all_births.dta", clear
	local r = `r' + 1
		foreach var of global pp3{
			local r = `r'+1
			mean `var' if interv_period==`i' 
			matrix b = e(b)
			local mean=b[1,1]
			putexcel `col'`r' = `mean', font($font) nformat(0) hcenter
		}
	use "$master\build\output\master_data_complete.dta", clear
		foreach cat of global hypothPt2 {
			local r = `r'+1
				foreach var of global `cat'{
				local r = `r'+1
				mean `var' if interv_period==`i' 
				matrix b = e(b)
				local mean=b[1,1]
				putexcel `col'`r' = `mean'*100, font($font) nformat(0) hcenter
		}
	}
}

**7.2 Treatment effects
local col = 6
foreach mod of global modelsimple {
	local r = 3
	local col = `col'+2	
	excelcol `col'
	local colb= r(column)
	local col =`col'+1
	excelcol `col'	
	local colp= r(column)
		foreach cat of global hypothPt1 {
			local r = `r'+1
			display `r'
				foreach var of global `cat'{
				`mod'
				local b = el(r(table), 1,1)
				local p = el(r(table), 4,1)
				local n = e(N)
				local r = `r'+1
				putexcel `colb'`r' =`b'*100, font($font) nformat(0) hcenter
				putexcel `colp'`r'= `p', font($font) nformat(0.000) hcenter
				putexcel K`r' = `n', font($font) hcenter
				} 
		}
	use "$master\build\output\master_data_complete_all_births.dta", clear
	local r = `r' + 1
		foreach var of global pp3{
			`mod'
			local b = el(r(table), 1,1)
			local p = el(r(table), 4,1)
			local n = e(N)
			local r = `r'+1
			putexcel `colb'`r' =`b'*100, font($font) nformat(0) hcenter
			putexcel `colp'`r'= `p', font($font) nformat(0.000) hcenter
			putexcel K`r' = `n', font($font) hcenter
		}
	use "$master\build\output\master_data_complete.dta", clear
		foreach cat of global hypothPt2 {
			local r = `r'+1
			display `r'
				foreach var of global `cat'{
				`mod'
				local b = el(r(table), 1,1)
				local p = el(r(table), 4,1)
				local n = e(N)
				local r = `r'+1
				putexcel `colb'`r' =`b'*100, font($font) nformat(0) hcenter
				putexcel `colp'`r'= `p', font($font) nformat(0.000) hcenter
				putexcel K`r' = `n', font($font) hcenter
			} 
		}
}

