/*******************************************************************************
*
* Replication of Tougher et al (2018)
* 	
* 	TABLE 1: Baseline characteristics of women who gave birth before the start 
*			 of the intervention  
*
* 	TABLE S1: Outcomes at baseline
*
*   Last updated 06/06/2018 by ST
*
*******************************************************************************/

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. LOADING DATA SET 
* 2. DECLARING SURVEY SETTINGS
* 3. SETTING UP THE OUTPUT FILE FOR TABLE 1
* 5. TABLE TITLE (TABLE 1)
* 5. COLUMN TITLES (TABLE 1)
*	5.1 Calculating and storing Ns for column titles
*	5.2 Adding column titles	
* 6. ROW TITLES (TABLE 1)
* 7. INPUTTING DATA (TABLE 1)
*	7.1 Intervention column
*	7.2 Control column
*	7.3 P-val column
* 8. FINAL FORMATTING (TABLE 1)
* 9. SETTING UP THE OUTPUT FILE (TABLE S1)
* 10. TABLE TITLE (TABLE S1)
* 11. COLUMN TITLES (TABLE S1)
*	11.1 Calculating and storing Ns for column titles
*	11.2 Adding column titles	
* 12. ROW TITLES (TABLE S1)
* 13. INPUTTING DATA (TABLE S1)
*	13.1 Intervention column
*	13.2 Control column
*	13.3 P-val column
* 14. FINAL FORMATTING (TABLE S1)
*
*******************************************************************************/

* 1. LOADING DATA SET
cd "$master"
use "build\output\master_data_complete.dta", clear

cd "$master\analysis\output"

* 2. DECLARING SURVEY SETTINGS
svyset id_cluster_sbdhi
svydescribe

* 3. SETTING UP THE OUTPUT FILE
putexcel set Table1.xlsx, replace

* 4. TABLE TITLE
putexcel A1 = "Table 1. Baseline characteristics of women who gave birth before the start of the intervention", ///
	font($fontTitle)

* 5. COLUMN TITLES
** 5.1 Calculating and storing Ns for column titles
summarize interv_period if interv_period==2
local N_base_control = r(N)
summarize interv_period if interv_period==1
local N_base_interv = r(N)

** 5.2 Adding column titles 
putexcel A2 = "Variable and category", font($font)
putexcel B2 = "Intervention (N=`N_base_interv')" ///
	C2 = "Control (N=`N_base_control')" D2 = "P value", font($font) hcenter

* 6. ROW TITLES 
local r =2 //row counter
foreach cat of global controlsDesc_bin{
	local r = `r'+1
	local varLab : variable label `cat'
	putexcel A`r' =  "`varLab'", font($font)
		foreach var of global `cat'{
		local r = `r'+1
		local varLab : variable label `var'
		putexcel A`r' =  "`varLab'", font($font) txtindent(3)
		}
}
local r = `r'+1
local varLab: variable label qrt_since_birth
	putexcel A`r' = "`varLab'", font($font)
	
* 7. INPUTTING DATA 
	/* Note: The characteristics are binary with the exception of time since birth, 
		so the code below first loops through for each of the binary variables. 
		The computations are then conducted for the continuous variable (quarters 
		since birth). 
		*/
	
** 7.1 Intervention column
*** 7.1.1 Binary variables
local r =2 //row counter
foreach cat of global controlsDesc_bin{
	local r = `r'+1  
		foreach var of global `cat'{
		local r = `r'+1
		mean `var' if interv_period==1 
		matrix b = e(b)
		local mean=b[1,1]
				putexcel B`r' = `mean'*100, font($font) nformat(0) hcenter
		}
}
*** 7.1.2 Continuous variables
local r = `r'+1
summarize qrt_since_birth if interv_period==1
local mean = round(r(mean), .01)
local sd = round(r(sd), .01)
putexcel B`r' ="`mean' (`sd')", font($font) hcenter
 
** 7.2 Control column
*** 7.2.1 Binary variables
local r =2 //row counter
foreach cat of global controlsDesc_bin{
	local r = `r'+1
		foreach var of global `cat'{
		local r = `r'+1
		mean `var' if interv_period==2 
		matrix b = e(b)
		local mean=b[1,1]
				putexcel C`r' = `mean'*100, font($font) nformat(0) hcenter
		}
}

*** 7.2.2 Continuous variables
local r = `r'+1
summarize qrt_since_birth if interv_period==2
local mean = round(r(mean), .01)
local sd = round(r(sd), .01)
putexcel C`r' ="`mean' (`sd')", font($font) hcenter

** 7.3 P-vals for difference
*** 7.3.1 Binary variables
local r = 4 //row counter
foreach cat of global controlsDesc_bin{
	local num : word count $`cat'
		foreach var of global `cat'{
		svy, subpop(if after_ITT==0): tab `var' intervention
		local p = e(p_Pear)
		putexcel D`r' = `p', font($font) nformat(0.000) hcenter
		}
	local r = `r'+`num'+1
}

*** 7.3.2 Binary variables
local r = `r'-1
reg qrt_since_birth intervention if after_ITT==0, cluster(id_cluster_sbdhi)
putexcel D`r' = (2 * ttail(e(df_r), abs(_b[intervention]/_se[intervention]))), font($font) nformat(0.000) hcenter

* SECTION 8: FINAL FORMATTING (underlines)
putexcel (A2:D2), border(top)
putexcel (A2:D2), border(bottom)
putexcel (A`r':D`r'), border(bottom)

* SECTION 9: SETTING THE OUTPUT FILE (TABLE S1)
putexcel set TableS1.xlsx, replace

* SECTION 10: TABLE TITLE
putexcel A1 = "Table S1. Outcomes at baseline", font($fontTitle)

* SECTION 11 COLUMN TITLES
** 11.1 Calculating and storing Ns for column titlessummarize interv_period if interv_period==2
local N_base_control = r(N)
summarize interv_period if interv_period==1
local N_base_interv = r(N)

** 11.2 Adding column titles 
putexcel A2 = "Variable and category", font($font)
putexcel B2 = "Intervention (N=`N_base_interv')" ///
	C2 = "Control (N=`N_base_control')" D2 = "P value", font($font) hcenter
	
* SECTION 12: ROW TITLES
local r =3 //row counter
foreach fam of global hypoth{
	local r = `r'+1
	local varLab : variable label `fam'
	putexcel A`r' =  "`varLab'", font($font)
	putexcel (A`r':N`r'), border(top)
		foreach var of global `fam'{
		local r = `r'+1
		local varLab : variable label `var'
		putexcel A`r' =  "`varLab'", font($font) txtindent(3)
		}
}
	
* 13. INPUTTING DATA 
** 13.1 Intervention column
use "$master\build\output\master_data_complete.dta", clear	

local r =3 //row counter
foreach cat of global hypothPt1 {
	local r = `r'+1
		foreach var of global `cat'{
		local r = `r'+1
		mean `var' if interv_period==1 
		matrix b = e(b)
		local mean=b[1,1]
		putexcel B`r' = `mean'*100, font($font) nformat(0) hcenter
		}
}
use "$master\build\output\master_data_complete_all_births.dta", clear
local r = `r' + 1
foreach var of global pp3{
	local r = `r'+1
	mean `var' if interv_period==1 
	matrix b = e(b)
	local mean=b[1,1]
	putexcel B`r' = `mean', font($font) nformat(0) hcenter
	}
use "$master\build\output\master_data_complete.dta", clear	
foreach cat of global hypothPt2 {
	local r = `r'+1
		foreach var of global `cat'{
		local r = `r'+1
		mean `var' if interv_period==1 
		matrix b = e(b)
		local mean=b[1,1]
		putexcel B`r' = `mean'*100, font($font) nformat(0) hcenter
		}
}

** 13.2 Control column
local r =3 //row counter
foreach cat of global hypothPt1 {
	local r = `r'+1
		foreach var of global `cat'{
		local r = `r'+1
		mean `var' if interv_period==2 
		matrix b = e(b)
		local mean=b[1,1]
		putexcel C`r' = `mean'*100, font($font) nformat(0) hcenter
		}
}
use "$master\build\output\master_data_complete_all_births.dta", clear

local r = `r' + 1
foreach var of global pp3{
	local r = `r'+1
	mean `var' if interv_period==2 
	matrix b = e(b)
	local mean=b[1,1]
	putexcel C`r' = `mean', font($font) nformat(0) hcenter
	}
use "$master\build\output\master_data_complete.dta", clear
svyset id_cluster_sbdhi
svydescribe	
foreach cat of global hypothPt2 {
	local r = `r'+1
		foreach var of global `cat'{
		local r = `r'+1
		mean `var' if interv_period==2 
		matrix b = e(b)
		local mean=b[1,1]
		putexcel C`r' = `mean'*100, font($font) nformat(0) hcenter
		}
}
** 13.3 P-vals for difference
local r = 3 //row counter
foreach cat of global hypothPt1 {
	local r = `r'+1
		foreach var of global `cat'{
		local r = `r'+1
		svy, subpop(if after_ITT==0): tab `var' intervention
		local p = e(p_Pear)
		putexcel D`r' = `p', font($font) nformat(0.000) hcenter
		}
}
use "$master\build\output\master_data_complete_all_births.dta", clear
svyset id_cluster_sbdhi
svydescribe
foreach cat of global pp3 {
	local r = `r'+2
		foreach var of global `cat'{
		local r = `r'+1
		svy, subpop(if after_ITT==0): tab `var' intervention
		local p = e(p_Pear)
		putexcel D`r' = `p', font($font) nformat(0.000) hcenter
		}
}
use "$master\build\output\master_data_complete.dta", clear
svyset id_cluster_sbdhi
svydescribe	

foreach cat of global hypothPt2 {
	local r = `r'+1
		foreach var of global `cat'{
		local r = `r'+1
		svy, subpop(if after_ITT==0): tab `var' intervention
		local p = e(p_Pear)
		putexcel D`r' = `p', font($font) nformat(0.000) hcenter
		}
}

* SECTION 14: ADDING FINAL FORMATTING 
putexcel (A2:D2), border(top)
putexcel (A2:D2), border(bottom)
putexcel (A`r':D`r'), border(bottom)
