
/*******************************************************************************
*
* Replication of Tougher et al (2018)
* 	
* 	FIGURE S3: Common trends (leads and lags) for facility births
*
*   Last updated 10/06/2018 by ST
*
*******************************************************************************/

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. LOADING DATA SET 
* 2. LABELLING VARIABLES FOR X-AXIS
* 3. PRODUCING COMMON TRENDS FIGURE
* 4. SAVING FIGURE
*
*******************************************************************************/

* SECTION 1 - LOADING DATA SET 
use "$master\build\output\master_data_complete.dta", clear

* SECTION 2 - LABELLING VARIABLES FOR X-AXIS
la var aftXint "t=0"
la var F_1 "t-1"
la var F_2 "t-2"
la var F_3 "t-3"
la var F_4 "t-4"

la var L_1 "t+1"
la var L_2 "t+2"
la var L_3 "t+3"
la var L_4 "t+4"
la var L_5 "t+5"
la var L_6 "t+6"
la var L_7 "t+7"
la var L_8 "t+8"

* SECTION 3 - PRODUCING COMMON TRENDS FIGURE
foreach var in del1_fac { 
	xtreg `var' aftXint i.birth_qrt $controls F_3 F_2 F_1 L_1 L_2 L_3, fe i(id_cluster_sbdhi) vce(robust)
	local varLab : variable label `var'
	coefplot, keep(F_1 F_2 F_3 aftXint L_1 L_2 L_3) ///
		order(F_3 F_2 F_1 aftXint L_1 L_2 L_3) ciopts(recast(rcap) lcolor(dknavy)) ///
		mcolor(dknavy) yscale(r(-0.3 0.3)) ylabel(-0.3(0.1)0.3) yline(0) vertical ///
		xtitle(Quarters since introduction) ytitle(Coefficients from leads and lags)
}
* SECTION 4 - SAVING FIGURE
cd "$master\analysis\output"
graph save Figure3, replace


