/*******************************************************************************
*
* Replication of Tougher et al (2018)
* 	
*	FWER-ADJUSTED P-VALUES FOR:
*
* 	TABLE S3: Robustness checks of the effect of Matrika on ANC outcomes
*
*	TABLE S4: Robustness checks of the effect of Matrika on delivery care outcomes
*
*	TABLE S5: Robustness checks of the effect of Matrika on postpartum and newborn 
*			 outcomes
*
*   Last updated 10/06/2018 by ST
*
*******************************************************************************/
	
	/*Note: This file produces the FWER-adjusted pvalues for Tables S3-S5 only. */

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. LOADING DATA SET 
* 2. SETTING UP THE OUTPUT FILE
* 3. INPUTTING DATA
*	3.1 Setting seed
*	3.2 Computing FWER-adjusted pvalues - base analysis
* 	3.3 Computing FWER-adjusted pvalues - robustness checks
*
*******************************************************************************/

* SECTION 1 - LOADING DATA SET
use "$master\build\output\master_data_complete.dta", clear
cd "$master\analysis\output"

* SECTION 2 - SETTING UP THE OUTPUT FILE
cd "$master\analysis\output"
putexcel set TablesS3_S5.xlsx, modify
	*Note: The contents of Tables 2-4 are outputted to a single file.  

* SECTION 3 -  INPUTTING DATA

** 3.1 Setting Seed
set seed $seed

** 3.2 Computing FWER-adjusted pvalues - base analysis
* Domain 1: anc1	
fsdrmxt (anc1_3visits $model3ext) (anc1_tri $model3ext) (anc1_numvis $model3ext) ///
	(anc1_ashavis $model3ext), testvar(aftXint) reps($reps)  cluster(id_cluster_sbdhi)
local num: word count $anc1
forvalues i= 1(1)`num' {
	local row = 4+`i'
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 2: anc2
fsdrmxt (anc2_tet $model3ext) (anc2_irongiv $model3ext) (anc2_irontake $model3ext) ///
	(anc2_syphres $model3ext) (anc2_abdexam $model3ext) (anc2_intwrm  $model3ext) ///
	(anc2_mal $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $anc2
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 3: anc3
fsdrmxt (anc3_knowpregcomp $model3ext) (anc3_knowdelcomp $model3ext) ///
	(anc3_birthprep $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $anc3
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 4: del1
fsdrmxt (del1_fac $model3ext) (del1_sba $model3ext) (del1_csec $model3ext), ///
	testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del1
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 5: del2
fsdrmxt (del2_glov $model3ext) (del2_soap $model3ext) (del2_bp $model3ext) ///
	(del2_mob $model3ext) (del2_oralfluids $model3ext) (del2_hrbaby $model3ext) ///
	(del2_nasg $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del2
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 6: del3
fsdrmxt (del3_shave $model3ext) (del3_enema $model3ext) (del3_birthpos $model3ext) ///
	(del3_ivlab $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del3
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 7: del4
fsdrmxt (del4_urincath $model3ext) (del4_epidural $model3ext) (del4_oxyaug $model3ext) ///
	(del4_episiotomy $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del4
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 8: del5
fsdrmxt (del5_labsup_alt $model3ext) (del5_noconsent $model3ext) (del5_shout $model3ext) ///
	(del5_slap $model3ext) (del5_priv $model3ext) (del5_refcare $model3ext) ///
	(del5_held $model3ext) (del5_disrespect $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del5
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 9: del6
fsdrmxt (del6_delspend $model3ext) (del6_borrow  $model3ext) (del6_hhdebt $model3ext) ///
	(del6_jsy_alt $model3ext) , testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del6
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 10: pp1
fsdrmxt (pp1_woman48hrcheck $model3ext) (pp1_baby48hrcheck $model3ext), ///
	testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp1
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 11: pp2
fsdrmxt (pp2_cleancordcare $model3ext) (pp2_thermcare $model3ext) (pp2_babyweighed $model3ext) ///
	(pp2_birthregistered $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp2
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
use "$master\build\output\master_data_complete_all_births.dta", clear

* Domain 12: pp3
fsdrmxt (pp3_nmr $model3ext2) (pp3_onedaymort $model3ext2) (pp3_birthweight $model3ext2), ///
	testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp3
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
use "$master\build\output\master_data_complete.dta", clear
	
* Domain 13: pp4
fsdrmxt (pp4_breastfeed $model3ext) (pp4_colostrum $model3ext) (pp4_breastfeed3days $model3ext), ///
	testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp4
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel D`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 14: pp5
** Domain 14 only includes 1 outcome, so p-values within this domain are not adjusted
local row = `row' +1
putexcel D`row'= "-", font($font) hcenter


** 3.3  Computing FWER-adjusted pvalues - robustness checks
local r = 0
local col = 4
local robust 4 3 1 5 
set seed $seed
foreach chk of local robust { 
local r = `chk'+1
local col = `col'+5	
excelcol `col'
local colp = r(column)


* Domain 1: anc1
fsdrmxt (anc1_3visits ${model3ext_rob`chk'}) (anc1_tri ${model3ext_rob`chk'}) (anc1_numvis ${model3ext_rob`chk'}) ///
	(anc1_ashavis ${model3ext_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)

local num: word count $anc1
forvalues i= 1(1)`num' {
	local row = 4+`i'
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}

local row = `row' +1

* Domain 2: anc2
fsdrmxt (anc2_tet ${model3ext_rob`chk'}) (anc2_irongiv ${model3ext_rob`chk'}) (anc2_irontake ${model3ext_rob`chk'}) ///
	(anc2_syphres ${model3ext_rob`chk'}) (anc2_abdexam ${model3ext_rob`chk'}) (anc2_intwrm  ${model3ext_rob`chk'}) ///
	(anc2_mal ${model3ext_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)

local num: word count $anc2
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
 local row = `row' +1	
* Domain 3: anc3
fsdrmxt (anc3_knowpregcomp ${model3ext_rob`chk'}) (anc3_knowdelcomp ${model3ext_rob`chk'}) ///
	(anc3_birthprep ${model3ext_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $anc3
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1

* Domain 4: del1
fsdrmxt (del1_fac ${model3ext_rob`chk'}) (del1_sba ${model3ext_rob`chk'}) ///
	(del1_csec ${model3ext_rob`chk'}) ${if_rob`chk'},testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del1
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 5: del2
fsdrmxt (del2_glov ${model3ext_rob`chk'}) (del2_soap ${model3ext_rob`chk'}) (del2_bp ${model3ext_rob`chk'}) ///
	(del2_mob ${model3ext_rob`chk'}) (del2_oralfluids ${model3ext_rob`chk'}) (del2_hrbaby ${model3ext_rob`chk'}) ///
	(del2_nasg ${model3ext_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del2
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 6: del3
fsdrmxt (del3_shave ${model3ext_rob`chk'}) (del3_enema ${model3ext_rob`chk'}) (del3_birthpos ${model3ext_rob`chk'}) ///
	(del3_ivlab ${model3ext_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del3
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1

* Domain 7: del4
fsdrmxt (del4_urincath ${model3ext_rob`chk'}) (del4_epidural ${model3ext_rob`chk'}) (del4_oxyaug ${model3ext_rob`chk'}) ///
	(del4_episiotomy ${model3ext_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del4
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1	

* Domain 8: del5
fsdrmxt (del5_labsup_alt ${model3ext_rob`chk'}) (del5_noconsent ${model3ext_rob`chk'}) ///
	(del5_shout ${model3ext_rob`chk'}) (del5_slap ${model3ext_rob`chk'}) (del5_priv ${model3ext_rob`chk'}) ///
	(del5_refcare ${model3ext_rob`chk'}) (del5_held ${model3ext_rob`chk'}) ///
	(del5_disrespect ${model3ext_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del5
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1	

* Domain 9: del6
fsdrmxt (del6_delspend ${model3ext_rob`chk'}) (del6_borrow  ${model3ext_rob`chk'}) (del6_hhdebt ${model3ext_rob`chk'}) ///
	(del6_jsy_alt ${model3ext_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del6
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 10: pp1
fsdrmxt (pp1_woman48hrcheck ${model3ext_rob`chk'}) (pp1_baby48hrcheck ${model3ext_rob`chk'}) ${if_rob`chk'}, ///
	testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp1
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 11: pp2
fsdrmxt (pp2_cleancordcare ${model3ext_rob`chk'}) (pp2_thermcare ${model3ext_rob`chk'}) ///
	(pp2_babyweighed ${model3ext_rob`chk'}) (pp2_birthregistered ${model3ext_rob`chk'}) ///
	${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp2
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
use "$master\build\output\master_data_complete_all_births.dta", clear
* Domain 12: pp3
fsdrmxt (pp3_nmr ${model3ext2_rob`chk'}) (pp3_onedaymort ${model3ext2_rob`chk'}) ///
	(pp3_birthweight ${model3ext2_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') ///
	reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp3
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	} 
local row = `row' +1
	
use "$master\build\output\master_data_complete.dta", clear
* Domain 13: pp4
fsdrmxt (pp4_breastfeed ${model3ext_rob`chk'}) (pp4_colostrum ${model3ext_rob`chk'}) ///
	(pp4_breastfeed3days ${model3ext_rob`chk'}) ${if_rob`chk'}, testvar(aftXintRob`chk') reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp4
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel `colp'`row'=`padjust', nformat(0.000) font($font) hcenter
	}
* Domain 14: pp5
** Domain 14 only includes 1 outcome, so p-values within this domain are not adjusted
}
