/*******************************************************************************
*
* Replication of Tougher et al (2018)
* 	
* 	TABLE S3: Robustness checks of the effect of Matrika on ANC outcomes
*
*	TABLE S4: Robustness checks of the effect of Matrika on delivery care outcomes
*
*	TABLE S5: Robustness checks of the effect of Matrika on postpartum and newborn 
*			 outcomes
*
*   Last updated 10/06/2018 by ST
*
*******************************************************************************/

	/*Note: All contents of Tables S2-S4 are produced in this file, with the exception 
			of the FWER-adjusted pvalues, which are added to the table in 08_fwer_adjust.do  */

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. LOADING DATA SET 
* 2. SETTING UP THE OUTPUT FILE
* 3. TABLE TITLE
* 4. COLUMN TITLES 
* 5. ROW TITLES
* 6. TABLE FORMATTING
* 7. INPUTTING DATA
*
*******************************************************************************/

* SECTION 1 - LOADING DATA SET
cd "$master"
use "build\output\master_data_complete.dta", clear

* SECTION 2 - SETTING UP THE OUTPUT FILE
cd "$master\analysis\output"
putexcel set TablesS3_S5.xlsx, replace
	*Note: The contents of Tables 2-4 are outputted to a single file.  

* SECTION 3 - TABLE TITLE
putexcel A1 = "Tables S3-S5 Robustness checks of the effect of Matrika", font($fontTitle)

* SECTION 4 - COLUMNG TITLES
putexcel A2 = "Outcome" B2 = "Base Analysis" G2 = "(a) External control only" ///
	L2 = "(b) Internal control only"  Q2 = "(c) Sky placement (survey data)" ///
	V2 = "(d) Alternative start date", font($font)
putexcel B3 = "Treatment effect" C3 = "Per comparison p value" D3 = "FWER adjusted p value" ///
	E3 = "N" G3 = "Treatment effect"  H3 = "Per comparison p value" I3 = "FWER adjusted p value" ///
	J3 = "N" L3 = "Treatment effect"  M3 = "Per comparison p value" N3 = "FWER adjusted p value" ///
	O3 = "N" Q3 = "Treatment effect"  R3 = "Per comparison p value" S3 = "FWER adjusted p value" ///
	T3 = "N" V3 = "Treatment effect"  W3 = "Per comparison p value" X3 = "FWER adjusted p value" ///
	Y3 = "N", font($font) hcenter

* SECTION 5 - ROW TITLES
local r =3 //row counter
foreach fam of global hypoth{
	local r = `r'+1
	local varLab : variable label `fam'
	putexcel A`r' =  "`varLab'", font($font)
	putexcel (A`r':Y`r'), border(top)
		foreach var of global `fam'{
		local r = `r'+1
		local varLab : variable label `var'
		putexcel A`r' =  "`varLab'", font($font) txtindent(3)
		}
}
* SECTION 6 - TABLE FORMATTING
putexcel (B2:E2) (G2:J2) (L2:O2) (Q2:T2) (V2:Y2), merge border(bottom) hcenter
putexcel (A2:Y2), border(top)
putexcel (A3:Y3), border(bottom)

* SECTON 7 - INPUTTING DATA
local col = 0
foreach mod of global robTab{
	local r = 3
	local col = `col'+2	
	excelcol `col'
	local colb = r(column)
	local col = `col'+1
	excelcol `col'
	local colp = r(column)
	local col = `col'+2
	excelcol `col'
	local coln = r(column)
	foreach cat of global hypothPt1 {
		local r = `r'+1
		display `r'
			foreach var of global `cat'{
				`mod'
				local b = el(r(table), 1,1)
				local p = el(r(table), 4,1)
				local n = e(N)
				local r = `r'+1
				putexcel `colb'`r' =`b'*100, font($font) nformat(0) hcenter
				putexcel `colp'`r'= `p', font($font) nformat(0.000) hcenter
				putexcel `coln'`r' = `n', font($font) hcenter
			} 
	}
use "$master\build\output\master_data_complete_all_births.dta", clear

local r = `r' + 1
	foreach var of global pp3{
		`mod'
		local b = el(r(table), 1,1)
		local p = el(r(table), 4,1)
		local n = e(N)
		local r = `r'+1
		putexcel `colb'`r' =`b'*100, font($font) nformat(0) hcenter
		putexcel `colp'`r'= `p', font($font) nformat(0.000) hcenter
		putexcel `coln'`r' = `n', font($font) hcenter
	}
use "$master\build\output\master_data_complete.dta", clear
	foreach cat of global hypothPt2 {
		local r = `r'+1
		display `r'
		foreach var of global `cat'{
			`mod'		
			local b = el(r(table), 1,1)
			local p = el(r(table), 4,1)
			local n = e(N)
			local r = `r'+1
			putexcel `colb'`r' =`b'*100, font($font) nformat(0) hcenter
			putexcel `colp'`r'= `p', font($font) nformat(0.000) hcenter
			putexcel `coln'`r' = `n', font($font) hcenter
		}
	}
}


