/*******************************************************************************
*
* Replication of Tougher et al (2018)
* 	
* 	FIGURE 3: Effect of the Matrika programme on summary measures of outcomes 
*
*   Last updated 7/06/2018 by ST
*
*******************************************************************************/

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. LOADING DATA SET 
* 2. ESTIMATING THE EFFECT OF SOCIAL FRANCHISING  SUMMARY INDEXES
* 3. PRODUCING FIGURE
* 4. SAVING FIGURE
*
*******************************************************************************/

* SECTION 1 - LOADING DATA SET
use "$master\build\output\master_data_complete.dta", clear

* SECTION 2 - ESTIMATING THE EFFECT OF SOCIAL FRANCHISING ON EACH SUMMARY MEASURE  
foreach mod of global modelsimple{
	foreach var of global indices_finalPt1{
		`mod'
		estimates store `var'
	} 
 }

use "$master\build\output\master_data_complete_all_births.dta", clear
foreach mod of global modelsimple{
	foreach var in ind_pp3_z_final{
		`mod'
		estimates store `var'
	}
 }

 
use "$master\build\output\master_data_complete.dta", clear
foreach mod of global modelsimple{
	foreach var of global indices_finalPt2 {
		`mod'
		estimates store `var'
		} 
 } 
* SECTION 3 - PRODUCING FIGURE
 coefplot $indices_final, keep(aftXint) aseq swapnames legend(off) nooffsets ///
	xline(0) ciopts(recast(rcap) lcolor(dknavy))  mcolor(dknavy) xscale(r(-0.3 0.3)) ///
	xlabel(-0.6(0.2)0.6) 

* SECTION 4 - SAVING GRAPH
cd "$master\analysis\output"
graph save Figure3, replace
