/*******************************************************************************
*
* Replication of Tougher et al (2018)
* 	
*	FWER-ADJUSTED P-VALUES FOR:
*
* 	TABLE 2: Estimated effect of the Matrika programme on antenatal care outcomes
*
*	TABLE 3: Estimated effect of the Matrika programme on delivery care outcomes
*
*	TABLE 4: Estimated effect of the Matrika programme on post-partum and newborn 
*			 outcomes
*
*   Last updated 07/06/2018 by ST
*
*******************************************************************************/
	
	/*Note: This file produces the FWER-adjusted pvalues for Tables 2-4 only. */

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. LOADING DATA SET 
* 2. SETTING UP THE OUTPUT FILE
* 3. INPUTTING DATA
*	3.1 Setting seed
*	3.2 Computing FWER-adjusted pvalues 
*******************************************************************************/

* 1. LOADING DATA SET
use "$master\build\output\master_data_complete.dta", clear

* 2. SETTING UP THE OUTPUT FILE
	 *Note: The contents of Tables 2-4 are outputted to a single file. The   
cd "$master\analysis\output"
putexcel set Tables2_4.xlsx, modify

*3. INPUTTING DATA
* 3.1 Setting seed, so that results can be reproduced
set seed $seed

*3.2 Computing FWER-adjusted pvalues

* Domain 1: anc1	
fsdrmxt (anc1_3visits $model3ext) (anc1_tri $model3ext) (anc1_numvis $model3ext) ///
	(anc1_ashavis $model3ext), testvar(aftXint) reps($reps)  cluster(id_cluster_sbdhi)
local num: word count $anc1
forvalues i= 1(1)`num' {
	local row = 4+`i'
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 2: anc2
fsdrmxt (anc2_tet $model3ext) (anc2_irongiv $model3ext) (anc2_irontake $model3ext) ///
	(anc2_syphres $model3ext) (anc2_abdexam $model3ext) (anc2_intwrm  $model3ext) ///
	(anc2_mal $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $anc2
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 3: anc3
fsdrmxt (anc3_knowpregcomp $model3ext) (anc3_knowdelcomp $model3ext) ///
	(anc3_birthprep $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $anc3
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 4: del1
fsdrmxt (del1_fac $model3ext) (del1_sba $model3ext) (del1_csec $model3ext), ///
	testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del1
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 5: del2
fsdrmxt (del2_glov $model3ext) (del2_soap $model3ext) (del2_bp $model3ext) ///
	(del2_mob $model3ext) (del2_oralfluids $model3ext) (del2_hrbaby $model3ext) ///
	(del2_nasg $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del2
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 6: del3
fsdrmxt (del3_shave $model3ext) (del3_enema $model3ext) (del3_birthpos $model3ext) ///
	(del3_ivlab $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del3
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 7: del4
fsdrmxt (del4_urincath $model3ext) (del4_epidural $model3ext) (del4_oxyaug $model3ext) ///
	(del4_episiotomy $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del4
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 8: del5
fsdrmxt (del5_labsup_alt $model3ext) (del5_noconsent $model3ext) (del5_shout $model3ext) ///
	(del5_slap $model3ext) (del5_priv $model3ext) (del5_refcare $model3ext) ///
	(del5_held $model3ext) (del5_disrespect $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del5
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 9: del6
fsdrmxt (del6_delspend $model3ext) (del6_borrow  $model3ext) (del6_hhdebt $model3ext) ///
	(del6_jsy_alt $model3ext) , testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $del6
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
	
* Domain 10: pp1
fsdrmxt (pp1_woman48hrcheck $model3ext) (pp1_baby48hrcheck $model3ext), ///
	testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp1
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 11: pp2
fsdrmxt (pp2_cleancordcare $model3ext) (pp2_thermcare $model3ext) (pp2_babyweighed $model3ext) ///
	(pp2_birthregistered $model3ext), testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp2
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
use "$master\build\output\master_data_complete_all_births.dta", clear

* Domain 12: pp3
fsdrmxt (pp3_nmr $model3ext2) (pp3_onedaymort $model3ext2) (pp3_birthweight $model3ext2), ///
	testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp3
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
use "$master\build\output\master_data_complete.dta", clear
	
* Domain 13: pp4
fsdrmxt (pp4_breastfeed $model3ext) (pp4_colostrum $model3ext) (pp4_breastfeed3days $model3ext), ///
	testvar(aftXint) reps($reps) cluster(id_cluster_sbdhi)
local num: word count $pp4
forvalues i= 1(1)`num' {
	local row = `row'+1
	local padjust = el(r(results), `i',5)
	putexcel J`row'=`padjust', nformat(0.000) font($font) hcenter
	}
local row = `row' +1
		
* Domain 14: pp5
** Domain 14 only includes 1 outcome, so p-values within this domain are not adjusted
local row = `row' +1
putexcel J`row'= "-", font($font) hcenter
