/*******************************************************************************
*
* Replication of Tougher et al (2018)
* 	
* 	DEFINES GLOBALS FOR ANALYSIS
*
*   Last updated 01/04/2018 by ST
*
*******************************************************************************/

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. DEFINE DOMAINS	
*	1.1 Grouping individual outcomes into domains(families)
*	1.2 Grouping z-scores of individual outcomes into domains(families)
*	1.3 List of domains
* 2. CONTROL SETS
* 3. REGRESSION MODELS	
* 4. SETTINGS FOR FWER-ADJUSTED PVALUES
* 5. ROBUSTNESS CHECKS	
*	5.1 Excluding intervention clusters and matched controls where no sky provider 
*		was located by the survey teams
*	5.2 Intervention vs. internal control areas only
*	5.3 Intervention vs. external control areas only 
*	5.4 Alternative Intervention start date 
* 6. FONT SETTINGS FOR OUTPUT TABLES
*
*******************************************************************************/

* SECTION 1. DEFINE DOMAINS

/* 	The evaluation of the Matrika social franchising model involved 57 outcomes,
	which were grouped into 14 domains (i.e. families). The evaluation adjusted 
	for multiple hypothesis testing in two ways. The first approach involved adjusting 
	p values within each domain (family) of outcomes for the family-wise error 
	rate (FWER). The second approach involved collapsing each family of outcomes 
	into an index, and estimating mean standardized treatment effects for each 
	index.
	
	The globals defined in this section list the individual outcomes within each 
	domain.*/


** 1.1 Grouping individual outcomes into domains

/* 	Two globals are defined in 1.1 for some domains (i.e. DEL3, DEL4, DEL5, DEL6, PP3). 
	For the purpose of creating the summary indices, individual outcomes were 
	transformed when necessary, so that a positive change indicates a beneficial 
	impact from a public health perspective. When an individual outcome needed to 
	be transformed in this way the variable name ends with the suffix '_alt'. 
	When a domain has at least one outcome that needed to be transformed, there 
	are two globals defined for that domain. The first includes the outcome with 
	its original interpretation, and the second which includes transformed version 
	of the outcome. The second global ends with the suffix '_other'. */

*** ANC 1: ANC use
global anc1 anc1_3visits anc1_tri anc1_numvis anc1_ashavis

*** ANC 2: ANC content of cate
global anc2 anc2_tet anc2_irongiv anc2_irontake anc2_syphres anc2_abdexam ///
	anc2_intwrm anc2_mal
	  
	 /* NOTE that the anc2 domain excludes 2 outcomes that were initially prespecified
		in the published study protocol (multiple birth detected during antenatal 
		care and ANC content of care score). The outcome for multiple births 
		detected at pregnancy was excluded because very few women in the sample 
		had multiple births. The ANC content of care score outcome was excluded, 
		because that outcome was made up of outcomes that are already in that 
		family of outcomes. */

*** ANC 3: ANC knowledge and preparedness	
global anc3 anc3_knowpregcomp anc3_knowdelcomp anc3_birthprep

*** DEL 1: Delivery care use
global del1 del1_fac del1_sba del1_csec

*** DEL 2: Recommended delivery care practices 
global del2 del2_glov del2_soap del2_bp del2_mob del2_oralfluids del2_hrbaby del2_nasg

*** DEL 3: Harmful or ineffective delivery care practices
global del3 del3_shave del3_enema del3_birthpos del3_ivlab

global del3_other del3_shave_alt del3_enema_alt del3_birthpos_alt del3_ivlab_alt

*** Del 4: Delivery care practices frequently overused
global del4 del4_urincath del4_epidural del4_oxyaug del4_episiotomy

global del4_other del4_urincath_alt del4_epidural_alt del4_oxyaug_alt del4_episiotomy_alt

*** Del 5: Respectful care
global del5 del5_labsup_alt del5_noconsent del5_shout del5_slap del5_priv_alt ///
	del5_refcare del5_held del5_disrespect
	
global del5_other del5_labsup del5_noconsent_alt del5_shout_alt del5_slap_alt del5_priv ///
	del5_refcare_alt del5_held_alt del5_disrespect_alt	

*** Del 6: Financial consequences
global del6 del6_delspend del6_borrow del6_hhdebt del6_jsy_alt

global del6_other del6_delspend_alt del6_borrow_alt del6_hhdebt_alt del6_jsy

*** PP1: Post-partum care
global pp1 pp1_woman48hrcheck pp1_baby48hrcheck

*** PP2: Newborn content of care
global pp2 pp2_cleancordcare pp2_thermcare pp2_babyweighed pp2_birthregistered

*** PP3: Neonatal health 
global pp3 pp3_nmr pp3_onedaymort pp3_birthweight

global pp3_other pp3_nmr_alt pp3_onedaymort_alt pp3_birthweight

*** PP4: Breastfeeding
global pp4 pp4_breastfeed pp4_colostrum pp4_breastfeed3days

*** PP5: Family planning
global pp5 pp5_modfp


** 1.2 Grouping z-scores of individual outcomes into domains(families) 

/* To produce the summary indices, individual outcomes were standardized into 
	z-scores. This section groups the standardized versions of the individual 
	outcomes into their respective domains. */

*** ANC1: ANC use 
global anc1_z anc1_3visits_z anc1_tri_z anc1_numvis_z anc1_ashavis_z

*** ANC 2: ANC content of cate
global anc2_z anc2_tet_z anc2_irongiv_z anc2_irontake_z anc2_syphres_z anc2_abdexam_z ///
	anc2_intwrm_z anc2_mal_z

*** ANC 3: ANC knowledge and preparedness	
global anc3_z anc3_knowpregcomp_z anc3_knowdelcomp_z anc3_birthprep_z

*** DEL 1: Delivery care use
global del1_z del1_fac_z del1_sba_z del1_csec_z

*** DEL 2: Recommended delivery care practices 
global del2_z del2_glov_z del2_soap_z del2_bp_z del2_mob_z del2_oralfluids_z ///
	del2_hrbaby_z del2_nasg_z

*** DEL 3: Harmful or ineffective delivery care practices	
global del3_z del3_shave_alt_z del3_enema_alt_z del3_birthpos_alt_z del3_ivlab_alt_z

*** Del 4: Delivery care practices frequently overused
global del4_z del4_urincath_alt_z del4_epidural_alt_z del4_oxyaug_alt_z del4_episiotomy_alt_z

*** Del 5: Respectful care
global del5_z del5_labsup_z del5_noconsent_alt_z del5_shout_alt_z del5_slap_alt_z ///
	del5_priv_z del5_refcare_alt_z del5_held_alt_z del5_disrespect_alt_z

*** Del 6: Financial consequences
global del6_z del6_delspend_alt_z del6_borrow_alt_z del6_hhdebt_alt_z del6_jsy_z

*** PP1: Post-partum care
global pp1_z pp1_woman48hrcheck_z pp1_baby48hrcheck_z

*** PP2: Newborn content of care
global pp2_z pp2_cleancordcare_z pp2_thermcare_z pp2_babyweighed_z pp2_birthregistered_z

*** PP3: Neonatal health 
global pp3_z pp3_nmr_alt_z pp3_onedaymort_alt_z pp3_birthweight_z

*** PP4: Breastfeeding
global pp4_z pp4_breastfeed_z pp4_colostrum_z pp4_breastfeed3days_z

*** PP5: Family planning
global pp5_z pp5_modfp_z


* 1.3 List of domains

/* The globals here list the domains, so that all outcomes or domains can be looped
through for various parts of the analysis. Where globals are divided into 2 parts, 
this is because one of the domains (pp3) requires a different data set than 
the others. Therefore, to produce most of the analysis output, three loops are used. 
The first loop will go through all of the ANC and delivery care outcomes/domains 
and first two post-partum domains. The second will be for PP3, and the third will 
be for the remaining post-partum care outcomes/domains.*/

global outcomes $anc1 $anc2 $anc3 $del1 $del2 $del3 $del4 $del5 $del6 $pp1 $pp2 ///
	$pp3 $pp4 $pp5

global outcomes_other $anc1 $anc2 $anc3 $del1 $del2 $del3_other $del4_other ///
	$del5_other $del6_other $pp1 $pp2 $pp3_other $pp4 $pp5 
	/* 	The del3_other del4_other del5_other del6_other pp3_other macros have the 
		'alt' versions of the outcomes so that all are positive for indicies*/

global outcomesPt1 $anc1 $anc2 $anc3 $del1 $del2 $del3 $del4 $del5 $del6 $pp1 $pp2  

global outcomesPt2 $pp4 $pp5

global hypoth anc1 anc2 anc3 del1 del2 del3 del4 del5 del6 pp1 pp2 pp3 pp4 pp5

global hypothPt1 anc1 anc2 anc3 del1 del2 del3 del4 del5 del6 pp1 pp2 

global hypothPt2 pp4 pp5

global hypoth_z anc1_z anc2_z anc3_z del1_z del2_z del3_z del4_z del5_z del6_z ///
	pp1_z pp2_z pp3_z pp4_z pp5_z

global indices ind_anc1_z ind_anc2_z ind_anc3_z ind_del1_z ind_del2_z ind_del3_z ///
	ind_del4_z ind_del5_z ind_del6_z ind_pp1_z ind_pp2_z ind_pp3_z ind_pp4_z ind_pp5_z

global indices_final ind_anc1_z_final ind_anc2_z_final ind_anc3_z_final ///
	ind_del1_z_final ind_del2_z_final ind_del3_z_final ind_del4_z_final ///
	ind_del5_z_final ind_del6_z_final ind_pp1_z_final ind_pp2_z_final ///
	ind_pp3_z_final ind_pp4_z_final ind_pp5_z_final

global indices_finalPt1 ind_anc1_z_final ind_anc2_z_final ind_anc3_z_final ///
	ind_del1_z_final ind_del2_z_final ind_del3_z_final ind_del4_z_final ///
	ind_del5_z_final ind_del6_z_final ind_pp1_z_final ind_pp2_z_final ///
	
global indices_finalPt2 ind_pp4_z_final ind_pp5_z_final
	
* SECTION 2 - CONTROLS

global controls hh_bpl religion_other hh_sc hh_st hh_obc mat_ed_primary ///
	mat_ed_secondary mat_ed_above parity2 parity3 parity4 parity5 hh_mulbirth qrt_since_birth ///
	hh_ses2 hh_ses3 hh_ses4 hh_ses5
	
global bpl_card hh_apl hh_bpl	
global residence hh_urban hh_rural
global religion religion_hindu religion_other 
global caste hh_gc hh_sc hh_st hh_obc
global mat_educ mat_ed_none mat_ed_primary mat_ed_secondary mat_ed_above
global ses hh_ses1 hh_ses2 hh_ses3 hh_ses4 hh_ses5
global parity parity1 parity2 parity3 parity4 parity5
global multi hh_singbirth hh_mulbirth
	
global controlsDesc_bin bpl_card residence religion caste mat_educ ses parity multi 

/*The birth quarter macros below are required because the fdsrmxt program required 
	to compute the FWER-adjusted pvalues does not accept factor variables. The global 
	birth_qrt2 is for the PP3 family of outcomes.*/
	
global birth_qrt birth_qrt_2 birth_qrt_3 birth_qrt_4 birth_qrt_5 birth_qrt_6 ///
		birth_qrt_7 birth_qrt_8 birth_qrt_9 birth_qrt_10 birth_qrt_11 birth_qrt_12 ///
		birth_qrt_13 birth_qrt_14
		
global birth_qrt2 birth_qrt_2 birth_qrt_3 birth_qrt_4 birth_qrt_5 birth_qrt_6 ///
		birth_qrt_7 birth_qrt_8 birth_qrt_9 birth_qrt_10 birth_qrt_11 birth_qrt_12 ///
		birth_qrt_13 birth_qrt_14 birth_qrt_15 birth_qrt_16 birth_qrt_17 birth_qrt_18 ///
		birth_qrt_19 birth_qrt_20 birth_qrt_21 birth_qrt_22 birth_qrt_23 birth_qrt_24 ///
		birth_qrt_25 birth_qrt_26


* SECTION 3 - REGRESSION MODELS
global model1 "reg \`var' aftXint after_ITT intervention, cluster(id_cluster_sbdhi)"
global model2 "xtreg \`var' aftXint i.birth_qrt, fe i(id_cluster_sbdhi) vce(robust)"
global model3 "xtreg \`var' aftXint i.birth_qrt $controls, fe i(id_cluster_sbdhi) vce(robust)"

global modelsimple \$model3


* SECTION 4 - SETTINGS FOR FWER-ADJUSTED PVALUES
global reps 10

global seed 40808720

global model3ext $birth_qrt $controls
global model3ext2 $birth_qrt2 $controls
	

* SECTION 5 -  Robustness checks
global robust rob4 rob3 rob1 rob5
global robTab \$model3 \$model3_rob4 \$model3_rob3 \$model3_rob1 \$model3_rob5 

*** Check 1 ('intervention only in places where survey team located the sky provider')
global anc1_z_rob1 anc1_3visits_z_rob1 anc1_tri_z_rob1 anc1_numvis_z_rob1 ///
	anc1_ashavis_z_rob1

global anc2_z_rob1 anc2_tet_z_rob1 anc2_irongiv_z_rob1 anc2_irontake_z_rob1 ///
	anc2_syphres_z_rob1 anc2_abdexam_z_rob1 anc2_intwrm_z_rob1 anc2_mal_z_rob1
	
global anc3_z_rob1 anc3_knowpregcomp_z_rob1 anc3_knowdelcomp_z_rob1 anc3_birthprep_z_rob1

global del1_z_rob1 del1_fac_z_rob1 del1_sba_z_rob1 del1_csec_z_rob1

global del2_z_rob1 del2_glov_z_rob1 del2_soap_z_rob1 del2_bp_z_rob1 del2_mob_z_rob1 ///
	del2_oralfluids_z_rob1 del2_hrbaby_z_rob1 del2_nasg_z_rob1

global del3_z_rob1 del3_shave_alt_z_rob1 del3_enema_alt_z_rob1 del3_birthpos_alt_z_rob1 ///
	del3_ivlab_alt_z_rob1

global del4_z_rob1 del4_urincath_alt_z_rob1 del4_epidural_alt_z_rob1 del4_oxyaug_alt_z_rob1 ///
	del4_episiotomy_alt_z_rob1

global del5_z_rob1 del5_labsup_z_rob1 del5_noconsent_alt_z_rob1 del5_shout_alt_z_rob1 ///
	del5_slap_alt_z_rob1 del5_priv_z_rob1 del5_refcare_alt_z_rob1 del5_held_alt_z_rob1 ///
	del5_disrespect_alt_z_rob1
	
global del6_z_rob1 del6_delspend_alt_z_rob1 del6_borrow_alt_z_rob1 del6_hhdebt_alt_z_rob1 del6_jsy_z_rob1

global pp1_z_rob1 pp1_woman48hrcheck_z_rob1 pp1_baby48hrcheck_z_rob1

global pp2_z_rob1 pp2_cleancordcare_z_rob1 pp2_thermcare_z_rob1 pp2_babyweighed_z_rob1 ///
	pp2_birthregistered_z_rob1

global pp3_z_rob1 pp3_nmr_alt_z_rob1 pp3_onedaymort_alt_z_rob1 pp3_birthweight_z_rob1

global pp4_z_rob1 pp4_breastfeed_z_rob1 pp4_colostrum_z_rob1 pp4_breastfeed3days_z_rob1

global pp5_z_rob1 pp5_modfp_z_rob1

global hypoth_z_rob1 anc1_z_rob1 anc2_z_rob1 anc3_z_rob1 del1_z_rob1 del2_z_rob1 ///
	del3_z_rob1 del4_z_rob1 del5_z_rob1 del6_z_rob1 pp1_z_rob1 pp2_z_rob1 ///
	pp3_z_rob1 pp4_z_rob1 pp5_z_rob1
	
global indices_rob1 ind_anc1_z_rob1 ind_anc2_z_rob1 ind_anc3_z_rob1 ind_del1_z_rob1 ///
	ind_del2_z_rob1 ind_del3_z_rob1	ind_del4_z_rob1 ind_del5_z_rob1 ind_del6_z_rob1 ///
	ind_pp1_z_rob1 ind_pp2_z_rob1 ind_pp3_z_rob1 ind_pp4_z_rob1 ind_pp5_z_rob1

global indices_final_rob1 ind_anc1_z_rob1_final ind_anc2_z_rob1_final ///
	ind_anc3_z_rob1_final ind_del1_z_rob1_final ind_del2_z_rob1_final ///
	ind_del3_z_rob1_final ind_del4_z_rob1_final ind_del5_z_rob1_final ///
	ind_del6_z_rob1_final ind_pp1_z_rob1_final ind_pp2_z_rob1_final ///
	ind_pp3_z_rob1_final ind_pp4_z_rob1_final ind_pp5_z_rob1_final

global indices_finalPt1_rob1 ind_anc1_z_rob1_final ind_anc2_z_rob1_final ///
	ind_anc3_z_rob1_final ind_del1_z_rob1_final ind_del2_z_rob1_final ///
	ind_del3_z_rob1_final ind_del4_z_rob1_final ind_del5_z_rob1_final ///
	ind_del6_z_rob1_final ind_pp1_z_rob1_final ind_pp2_z_rob1_final ///
	
global indices_finalPt2_rob1 ind_pp4_z_rob1_final ind_pp5_z_rob1_final

global model1_rob1 "reg \`var' aftXintRob1 after_ITT trueintervention if triplet!=20 & triplet!=25 & triplet!=27 & triplet!=28 & triplet!=32 & triplet!=34 & triplet!=35 & triplet!=44 & triplet!=46 & triplet!=47 & triplet!=49, cluster(id_cluster_sbdhi)"
global model2_rob1 "xtreg \`var' aftXintRob1 i.birth_qrt if triplet!=20 & triplet!=25 & triplet!=27 & triplet!=28 & triplet!=32 & triplet!=34 & triplet!=35 & triplet!=44 & triplet!=46 & triplet!=47 & triplet!=49, fe i(id_cluster_sbdhi) vce(robust)"
global model3_rob1 "xtreg \`var' aftXintRob1 i.birth_qrt $controls if triplet!=20 & triplet!=25 & triplet!=27 & triplet!=28 & triplet!=32 & triplet!=34 & triplet!=35 & triplet!=44 & triplet!=46 & triplet!=47 & triplet!=49, fe i(id_cluster_sbdhi) vce(robust)"

global modelsimple_rob1 \$model3_rob1

global model3ext_rob1 $birth_qrt $controls
global model3ext2_rob1 $birth_qrt2 $controls

global if_rob1 "if triplet!=20 & triplet!=25 & triplet!=27 & triplet!=28 & triplet!=32 & triplet!=34 & triplet!=35 & triplet!=44 & triplet!=46 & triplet!=47 & triplet!=49" //local for 'if' condition for FWER-adjusted p-values for robustness checks. Local is 'null' (i.e. "") when there is no 'if' req'd for check
 
*** Check 3 -> internal control only 
global anc1_z_rob3 anc1_3visits_z_rob3 anc1_tri_z_rob3 anc1_numvis_z_rob3 ///
	anc1_ashavis_z_rob3

global anc2_z_rob3 anc2_tet_z_rob3 anc2_irongiv_z_rob3 anc2_irontake_z_rob3 ///
	anc2_syphres_z_rob3 anc2_abdexam_z_rob3 anc2_intwrm_z_rob3 anc2_mal_z_rob3
	
global anc3_z_rob3 anc3_knowpregcomp_z_rob3 anc3_knowdelcomp_z_rob3 anc3_birthprep_z_rob3

global del1_z_rob3 del1_fac_z_rob3 del1_sba_z_rob3 del1_csec_z_rob3

global del2_z_rob3 del2_glov_z_rob3 del2_soap_z_rob3 del2_bp_z_rob3 del2_mob_z_rob3 ///
	del2_oralfluids_z_rob3 del2_hrbaby_z_rob3 del2_nasg_z_rob3

global del3_z_rob3 del3_shave_alt_z_rob3 del3_enema_alt_z_rob3 del3_birthpos_alt_z_rob3 ///
	del3_ivlab_alt_z_rob3

global del4_z_rob3 del4_urincath_alt_z_rob3 del4_epidural_alt_z_rob3 del4_oxyaug_alt_z_rob3 ///
	del4_episiotomy_alt_z_rob3

global del5_z_rob3 del5_labsup_z_rob3 del5_noconsent_alt_z_rob3 del5_shout_alt_z_rob3 ///
	del5_slap_alt_z_rob3 del5_priv_z_rob3 del5_refcare_alt_z_rob3 del5_held_alt_z_rob3 ///
	del5_disrespect_alt_z_rob3
	
global del6_z_rob3 del6_delspend_alt_z_rob3 del6_borrow_alt_z_rob3 del6_hhdebt_alt_z_rob3 del6_jsy_z_rob3

global pp1_z_rob3 pp1_woman48hrcheck_z_rob3 pp1_baby48hrcheck_z_rob3

global pp2_z_rob3 pp2_cleancordcare_z_rob3 pp2_thermcare_z_rob3 pp2_babyweighed_z_rob3 ///
	pp2_birthregistered_z_rob3

global pp3_z_rob3 pp3_nmr_alt_z_rob3 pp3_onedaymort_alt_z_rob3 pp3_birthweight_z_rob3

global pp4_z_rob3 pp4_breastfeed_z_rob3 pp4_colostrum_z_rob3 pp4_breastfeed3days_z_rob3

global pp5_z_rob3 pp5_modfp_z_rob3

global hypoth_z_rob3 anc1_z_rob3 anc2_z_rob3 anc3_z_rob3 del1_z_rob3 del2_z_rob3 ///
	del3_z_rob3 del4_z_rob3 del5_z_rob3 del6_z_rob3 pp1_z_rob3 pp2_z_rob3 ///
	pp3_z_rob3 pp4_z_rob3 pp5_z_rob3
	
global indices_rob3 ind_anc1_z_rob3 ind_anc2_z_rob3 ind_anc3_z_rob3 ind_del1_z_rob3 ///
	ind_del2_z_rob3 ind_del3_z_rob3	ind_del4_z_rob3 ind_del5_z_rob3 ind_del6_z_rob3 ///
	ind_pp1_z_rob3 ind_pp2_z_rob3 ind_pp3_z_rob3 ind_pp4_z_rob3 ind_pp5_z_rob3

global indices_final_rob3 ind_anc1_z_rob3_final ind_anc2_z_rob3_final ///
	ind_anc3_z_rob3_final ind_del1_z_rob3_final ind_del2_z_rob3_final ///
	ind_del3_z_rob3_final ind_del4_z_rob3_final ind_del5_z_rob3_final ///
	ind_del6_z_rob3_final ind_pp1_z_rob3_final ind_pp2_z_rob3_final ///
	ind_pp3_z_rob3_final ind_pp4_z_rob3_final ind_pp5_z_rob3_final

global indices_finalPt1_rob3 ind_anc1_z_rob3_final ind_anc2_z_rob3_final ///
	ind_anc3_z_rob3_final ind_del1_z_rob3_final ind_del2_z_rob3_final ///
	ind_del3_z_rob3_final ind_del4_z_rob3_final ind_del5_z_rob3_final ///
	ind_del6_z_rob3_final ind_pp1_z_rob3_final ind_pp2_z_rob3_final ///
	
global indices_finalPt2_rob3 ind_pp4_z_rob3_final ind_pp5_z_rob3_final

global model1_rob3 "reg \`var' aftXint after_ITT intervention if study_arm!=1, cluster(id_cluster_sbdhi)"
global model2_rob3 "xtreg \`var' aftXint i.birth_qrt if study_arm!=1, fe i(id_cluster_sbdhi) vce(robust)"
global model3_rob3 "xtreg \`var' aftXint i.birth_qrt $controls if study_arm!=1, fe i(id_cluster_sbdhi) vce(robust)"

global modelsimple_rob3 \$model3_rob3

global model3ext_rob3 $birth_qrt $controls
global model3ext2_rob3 $birth_qrt2 $controls

global if_rob3 "if study_arm!=1"

*** Check 4 -> External control only 
global anc1_z_rob4 anc1_3visits_z_rob4 anc1_tri_z_rob4 anc1_numvis_z_rob4 ///
	anc1_ashavis_z_rob4

global anc2_z_rob4 anc2_tet_z_rob4 anc2_irongiv_z_rob4 anc2_irontake_z_rob4 ///
	anc2_syphres_z_rob4 anc2_abdexam_z_rob4 anc2_intwrm_z_rob4 anc2_mal_z_rob4
	
global anc3_z_rob4 anc3_knowpregcomp_z_rob4 anc3_knowdelcomp_z_rob4 anc3_birthprep_z_rob4

global del1_z_rob4 del1_fac_z_rob4 del1_sba_z_rob4 del1_csec_z_rob4

global del2_z_rob4 del2_glov_z_rob4 del2_soap_z_rob4 del2_bp_z_rob4 del2_mob_z_rob4 ///
	del2_oralfluids_z_rob4 del2_hrbaby_z_rob4 del2_nasg_z_rob4

global del3_z_rob4 del3_shave_alt_z_rob4 del3_enema_alt_z_rob4 del3_birthpos_alt_z_rob4 ///
	del3_ivlab_alt_z_rob4

global del4_z_rob4 del4_urincath_alt_z_rob4 del4_epidural_alt_z_rob4 del4_oxyaug_alt_z_rob4 ///
	del4_episiotomy_alt_z_rob4

global del5_z_rob4 del5_labsup_z_rob4 del5_noconsent_alt_z_rob4 del5_shout_alt_z_rob4 ///
	del5_slap_alt_z_rob4 del5_priv_z_rob4 del5_refcare_alt_z_rob4 del5_held_alt_z_rob4 ///
	del5_disrespect_alt_z_rob4
	
global del6_z_rob4 del6_delspend_alt_z_rob4 del6_borrow_alt_z_rob4 del6_hhdebt_alt_z_rob4 del6_jsy_z_rob4

global pp1_z_rob4 pp1_woman48hrcheck_z_rob4 pp1_baby48hrcheck_z_rob4

global pp2_z_rob4 pp2_cleancordcare_z_rob4 pp2_thermcare_z_rob4 pp2_babyweighed_z_rob4 ///
	pp2_birthregistered_z_rob4

global pp3_z_rob4 pp3_nmr_alt_z_rob4 pp3_onedaymort_alt_z_rob4 pp3_birthweight_z_rob4

global pp4_z_rob4 pp4_breastfeed_z_rob4 pp4_colostrum_z_rob4 pp4_breastfeed3days_z_rob4

global pp5_z_rob4 pp5_modfp_z_rob4

global hypoth_z_rob4 anc1_z_rob4 anc2_z_rob4 anc3_z_rob4 del1_z_rob4 del2_z_rob4 ///
	del3_z_rob4 del4_z_rob4 del5_z_rob4 del6_z_rob4 pp1_z_rob4 pp2_z_rob4 ///
	pp3_z_rob4 pp4_z_rob4 pp5_z_rob4
	
global indices_rob4 ind_anc1_z_rob4 ind_anc2_z_rob4 ind_anc3_z_rob4 ind_del1_z_rob4 ///
	ind_del2_z_rob4 ind_del3_z_rob4	ind_del4_z_rob4 ind_del5_z_rob4 ind_del6_z_rob4 ///
	ind_pp1_z_rob4 ind_pp2_z_rob4 ind_pp3_z_rob4 ind_pp4_z_rob4 ind_pp5_z_rob4

global indices_final_rob4 ind_anc1_z_rob4_final ind_anc2_z_rob4_final ///
	ind_anc3_z_rob4_final ind_del1_z_rob4_final ind_del2_z_rob4_final ///
	ind_del3_z_rob4_final ind_del4_z_rob4_final ind_del5_z_rob4_final ///
	ind_del6_z_rob4_final ind_pp1_z_rob4_final ind_pp2_z_rob4_final ///
	ind_pp3_z_rob4_final ind_pp4_z_rob4_final ind_pp5_z_rob4_final

global indices_finalPt1_rob4 ind_anc1_z_rob4_final ind_anc2_z_rob4_final ///
	ind_anc3_z_rob4_final ind_del1_z_rob4_final ind_del2_z_rob4_final ///
	ind_del3_z_rob4_final ind_del4_z_rob4_final ind_del5_z_rob4_final ///
	ind_del6_z_rob4_final ind_pp1_z_rob4_final ind_pp2_z_rob4_final ///
	
global indices_finalPt2_rob4 ind_pp4_z_rob4_final ind_pp5_z_rob4_final

global model1_rob4 "reg \`var' aftXint after_ITT intervention if study_arm!=2, cluster(id_cluster_sbdhi)"
global model2_rob4 "xtreg \`var' aftXint i.birth_qrt if study_arm!=2, fe i(id_cluster_sbdhi) vce(robust)"
global model3_rob4 "xtreg \`var' aftXint i.birth_qrt $controls if study_arm!=2, fe i(id_cluster_sbdhi) vce(robust)"

global modelsimple_rob4 \$model3_rob4

global model3ext_rob4 $birth_qrt $controls
global model3ext2_rob4 $birth_qrt2 $controls

global if_rob4 "if study_arm!=2"

*** Check 5 -> self-reported branding start date
global anc1_z_rob5 anc1_3visits_z_rob5 anc1_tri_z_rob5 anc1_numvis_z_rob5 ///
	anc1_ashavis_z_rob5

global anc2_z_rob5 anc2_tet_z_rob5 anc2_irongiv_z_rob5 anc2_irontake_z_rob5 ///
	anc2_syphres_z_rob5 anc2_abdexam_z_rob5 anc2_intwrm_z_rob5 anc2_mal_z_rob5
	
global anc3_z_rob5 anc3_knowpregcomp_z_rob5 anc3_knowdelcomp_z_rob5 anc3_birthprep_z_rob5

global del1_z_rob5 del1_fac_z_rob5 del1_sba_z_rob5 del1_csec_z_rob5

global del2_z_rob5 del2_glov_z_rob5 del2_soap_z_rob5 del2_bp_z_rob5 del2_mob_z_rob5 ///
	del2_oralfluids_z_rob5 del2_hrbaby_z_rob5 del2_nasg_z_rob5

global del3_z_rob5 del3_shave_alt_z_rob5 del3_enema_alt_z_rob5 del3_birthpos_alt_z_rob5 ///
	del3_ivlab_alt_z_rob5

global del4_z_rob5 del4_urincath_alt_z_rob5 del4_epidural_alt_z_rob5 del4_oxyaug_alt_z_rob5 ///
	del4_episiotomy_alt_z_rob5

global del5_z_rob5 del5_labsup_z_rob5 del5_noconsent_alt_z_rob5 del5_shout_alt_z_rob5 ///
	del5_slap_alt_z_rob5 del5_priv_z_rob5 del5_refcare_alt_z_rob5 del5_held_alt_z_rob5 ///
	del5_disrespect_alt_z_rob5
	
global del6_z_rob5 del6_delspend_alt_z_rob5 del6_borrow_alt_z_rob5 del6_hhdebt_alt_z_rob5 del6_jsy_z_rob5

global pp1_z_rob5 pp1_woman48hrcheck_z_rob5 pp1_baby48hrcheck_z_rob5

global pp2_z_rob5 pp2_cleancordcare_z_rob5 pp2_thermcare_z_rob5 pp2_babyweighed_z_rob5 ///
	pp2_birthregistered_z_rob5

global pp3_z_rob5 pp3_nmr_alt_z_rob5 pp3_onedaymort_alt_z_rob5 pp3_birthweight_z_rob5

global pp4_z_rob5 pp4_breastfeed_z_rob5 pp4_colostrum_z_rob5 pp4_breastfeed3days_z_rob5

global pp5_z_rob5 pp5_modfp_z_rob5

global hypoth_z_rob5 anc1_z_rob5 anc2_z_rob5 anc3_z_rob5 del1_z_rob5 del2_z_rob5 ///
	del3_z_rob5 del4_z_rob5 del5_z_rob5 del6_z_rob5 pp1_z_rob5 pp2_z_rob5 ///
	pp3_z_rob5 pp4_z_rob5 pp5_z_rob5
	
global indices_rob5 ind_anc1_z_rob5 ind_anc2_z_rob5 ind_anc3_z_rob5 ind_del1_z_rob5 ///
	ind_del2_z_rob5 ind_del3_z_rob5	ind_del4_z_rob5 ind_del5_z_rob5 ind_del6_z_rob5 ///
	ind_pp1_z_rob5 ind_pp2_z_rob5 ind_pp3_z_rob5 ind_pp4_z_rob5 ind_pp5_z_rob5

global indices_final_rob5 ind_anc1_z_rob5_final ind_anc2_z_rob5_final ///
	ind_anc3_z_rob5_final ind_del1_z_rob5_final ind_del2_z_rob5_final ///
	ind_del3_z_rob5_final ind_del4_z_rob5_final ind_del5_z_rob5_final ///
	ind_del6_z_rob5_final ind_pp1_z_rob5_final ind_pp2_z_rob5_final ///
	ind_pp3_z_rob5_final ind_pp4_z_rob5_final ind_pp5_z_rob5_final

global indices_finalPt1_rob5 ind_anc1_z_rob5_final ind_anc2_z_rob5_final ///
	ind_anc3_z_rob5_final ind_del1_z_rob5_final ind_del2_z_rob5_final ///
	ind_del3_z_rob5_final ind_del4_z_rob5_final ind_del5_z_rob5_final ///
	ind_del6_z_rob5_final ind_pp1_z_rob5_final ind_pp2_z_rob5_final ///
	
global indices_finalPt2_rob5 ind_pp4_z_rob5_final ind_pp5_z_rob5_final

global model1_rob5 "reg \`var' aftXintRob5 after_selfbrand trueintervention if triplet!=20 & triplet!=25 & triplet!=27 & triplet!=28 & triplet!=32 & triplet!=34 & triplet!=35 & triplet!=44 & triplet!=46 & triplet!=47 & triplet!=49, cluster(id_cluster_sbdhi)"
global model2_rob5 "xtreg \`var' aftXintRob5 i.birth_qrt if triplet!=20 & triplet!=25 & triplet!=27 & triplet!=28 & triplet!=32 & triplet!=34 & triplet!=35 & triplet!=44 & triplet!=46 & triplet!=47 & triplet!=49, fe i(id_cluster_sbdhi) vce(robust)"
global model3_rob5 "xtreg \`var' aftXintRob5 i.birth_qrt $controls if triplet!=20 & triplet!=25 & triplet!=27 & triplet!=28 & triplet!=32 & triplet!=34 & triplet!=35 & triplet!=44 & triplet!=46 & triplet!=47 & triplet!=49, fe i(id_cluster_sbdhi) vce(robust)"

global modelsimple_rob5 \$model3_rob5

global model3ext_rob5 $birth_qrt $controls
global model3ext2_rob5 $birth_qrt2 $controls

global if_rob5 "if triplet!=20 & triplet!=25 & triplet!=27 & triplet!=28 & triplet!=32 & triplet!=34 & triplet!=35 & triplet!=44 & triplet!=46 & triplet!=47 & triplet!=49"


* SECTION 6 FONT SETTINGS FOR OUTPUT TABLES 
global font "arial,6"
global fontTitle "arial,11"
global fontNote "arial,8"
 
