/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.CircularList;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.SkeletonRidge;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class SkeletonMinutia {
    final IntPoint position;
    final List<SkeletonRidge> ridges = new ArrayList<SkeletonRidge>();

    SkeletonMinutia(IntPoint position) {
        this.position = position;
    }

    void attachStart(SkeletonRidge ridge) {
        if (!this.ridges.contains(ridge)) {
            this.ridges.add(ridge);
            ridge.start(this);
        }
    }

    void detachStart(SkeletonRidge ridge) {
        if (this.ridges.contains(ridge)) {
            this.ridges.remove(ridge);
            if (ridge.start() == this) {
                ridge.start(null);
            }
        }
    }

    void write(ByteBuffer buffer) {
        for (SkeletonRidge ridge : this.ridges) {
            if (!(ridge.points instanceof CircularList)) continue;
            ridge.write(buffer);
        }
    }

    int serializedSize() {
        return this.ridges.stream().filter(r -> r.points instanceof CircularList).mapToInt(r -> r.serializedSize()).sum();
    }

    public String toString() {
        return String.format("%s*%d", this.position.toString(), this.ridges.size());
    }
}

