/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.EdgeShape;
import com.machinezoo.sourceafis.FingerprintTransparency;
import com.machinezoo.sourceafis.ImmutableMatcher;
import com.machinezoo.sourceafis.ImmutableTemplate;
import com.machinezoo.sourceafis.IndexedEdge;
import com.machinezoo.sourceafis.MinutiaPair;
import com.machinezoo.sourceafis.NeighborEdge;
import com.machinezoo.sourceafis.Parameters;
import com.machinezoo.sourceafis.Score;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

class MatchBuffer {
    private static final ThreadLocal<MatchBuffer> local = new ThreadLocal<MatchBuffer>(){

        @Override
        protected MatchBuffer initialValue() {
            return new MatchBuffer();
        }
    };
    private FingerprintTransparency transparency;
    ImmutableTemplate probe;
    private TIntObjectHashMap<List<IndexedEdge>> edgeHash;
    ImmutableTemplate candidate;
    private MinutiaPair[] pool = new MinutiaPair[1];
    private int pooled;
    private PriorityQueue<MinutiaPair> queue = new PriorityQueue<MinutiaPair>(Comparator.comparing(p -> p.distance));
    int count;
    MinutiaPair[] tree;
    private MinutiaPair[] byProbe;
    private MinutiaPair[] byCandidate;
    private MinutiaPair[] roots;
    private final TIntHashSet duplicates = new TIntHashSet();
    private Score score = new Score();

    MatchBuffer() {
    }

    static MatchBuffer current() {
        return local.get();
    }

    void selectMatcher(ImmutableMatcher matcher) {
        this.probe = matcher.template;
        if (this.tree == null || this.probe.minutiae.length > this.tree.length) {
            this.tree = new MinutiaPair[this.probe.minutiae.length];
            this.byProbe = new MinutiaPair[this.probe.minutiae.length];
        }
        this.edgeHash = matcher.edgeHash;
    }

    void selectCandidate(ImmutableTemplate template) {
        this.candidate = template;
        if (this.byCandidate == null || this.byCandidate.length < this.candidate.minutiae.length) {
            this.byCandidate = new MinutiaPair[this.candidate.minutiae.length];
        }
    }

    double match() {
        try {
            this.transparency = FingerprintTransparency.current();
            int totalRoots = this.enumerateRoots();
            this.transparency.logRootPairs(totalRoots, this.roots);
            double high = 0.0;
            int best = -1;
            for (int i = 0; i < totalRoots; ++i) {
                double partial = this.tryRoot(this.roots[i]);
                if (partial > high) {
                    high = partial;
                    best = i;
                }
                this.clearPairing();
            }
            this.transparency.logBestMatch(best);
            double d = high;
            return d;
        }
        catch (Throwable e) {
            local.remove();
            throw e;
        }
        finally {
            this.transparency = null;
        }
    }

    private int enumerateRoots() {
        if (this.roots == null || this.roots.length < 70) {
            this.roots = new MinutiaPair[70];
        }
        int totalLookups = 0;
        int totalRoots = 0;
        int triedRoots = 0;
        this.duplicates.clear();
        for (boolean shortEdges : new boolean[]{false, true}) {
            for (int period = 1; period < this.candidate.minutiae.length; ++period) {
                for (int phase = 0; phase <= period; ++phase) {
                    for (int candidateReference = phase; candidateReference < this.candidate.minutiae.length; candidateReference += period + 1) {
                        int candidateNeighbor = (candidateReference + period) % this.candidate.minutiae.length;
                        EdgeShape candidateEdge = new EdgeShape(this.candidate.minutiae[candidateReference], this.candidate.minutiae[candidateNeighbor]);
                        if (!(candidateEdge.length >= 58 ^ shortEdges)) continue;
                        List matches = (List)this.edgeHash.get(this.hashShape(candidateEdge));
                        if (matches != null) {
                            for (IndexedEdge match : matches) {
                                if (!this.matchingShapes(match, candidateEdge)) continue;
                                int duplicateKey = match.reference << 16 | candidateReference;
                                if (!this.duplicates.contains(duplicateKey)) {
                                    this.duplicates.add(duplicateKey);
                                    MinutiaPair pair = this.allocate();
                                    pair.probe = match.reference;
                                    pair.candidate = candidateReference;
                                    this.roots[totalRoots] = pair;
                                    ++totalRoots;
                                }
                                if (++triedRoots < 70) continue;
                                return totalRoots;
                            }
                        }
                        if (++totalLookups < 1633) continue;
                        return totalRoots;
                    }
                }
            }
        }
        return totalRoots;
    }

    private int hashShape(EdgeShape edge) {
        int lengthBin = edge.length / 13;
        int referenceAngleBin = (int)(edge.referenceAngle / Parameters.maxAngleError);
        int neighborAngleBin = (int)(edge.neighborAngle / Parameters.maxAngleError);
        return (referenceAngleBin << 24) + (neighborAngleBin << 16) + lengthBin;
    }

    private boolean matchingShapes(EdgeShape probe, EdgeShape candidate) {
        int lengthDelta = probe.length - candidate.length;
        if (lengthDelta >= -13 && lengthDelta <= 13) {
            double neighborDelta;
            double complementaryAngleError = DoubleAngle.complementary(Parameters.maxAngleError);
            double referenceDelta = DoubleAngle.difference(probe.referenceAngle, candidate.referenceAngle);
            if ((referenceDelta <= Parameters.maxAngleError || referenceDelta >= complementaryAngleError) && ((neighborDelta = DoubleAngle.difference(probe.neighborAngle, candidate.neighborAngle)) <= Parameters.maxAngleError || neighborDelta >= complementaryAngleError)) {
                return true;
            }
        }
        return false;
    }

    private double tryRoot(MinutiaPair root) {
        this.queue.add(root);
        do {
            this.addPair((MinutiaPair)this.queue.remove());
            this.collectEdges();
            this.skipPaired();
        } while (!this.queue.isEmpty());
        this.transparency.logPairing(this.count, this.tree);
        this.score.compute(this);
        this.transparency.logScore(this.score);
        return this.score.shapedScore;
    }

    private void clearPairing() {
        for (int i = 0; i < this.count; ++i) {
            this.byProbe[this.tree[i].probe] = null;
            this.byCandidate[this.tree[i].candidate] = null;
            this.release(this.tree[i]);
            this.tree[i] = null;
        }
        this.count = 0;
    }

    private void collectEdges() {
        MinutiaPair reference = this.tree[this.count - 1];
        NeighborEdge[] probeNeighbors = this.probe.edges[reference.probe];
        NeighborEdge[] candidateNeigbors = this.candidate.edges[reference.candidate];
        for (MinutiaPair pair : this.matchPairs(probeNeighbors, candidateNeigbors)) {
            pair.probeRef = reference.probe;
            pair.candidateRef = reference.candidate;
            if (this.byCandidate[pair.candidate] == null && this.byProbe[pair.probe] == null) {
                this.queue.add(pair);
                continue;
            }
            if (this.byProbe[pair.probe] != null && this.byProbe[pair.probe].candidate == pair.candidate) {
                this.addSupportingEdge(pair);
            }
            this.release(pair);
        }
    }

    private List<MinutiaPair> matchPairs(NeighborEdge[] probeStar, NeighborEdge[] candidateStar) {
        double complementaryAngleError = DoubleAngle.complementary(Parameters.maxAngleError);
        ArrayList<MinutiaPair> results = new ArrayList<MinutiaPair>();
        int start = 0;
        int end = 0;
        for (int candidateIndex = 0; candidateIndex < candidateStar.length; ++candidateIndex) {
            NeighborEdge candidateEdge = candidateStar[candidateIndex];
            while (start < probeStar.length && probeStar[start].length < candidateEdge.length - 13) {
                ++start;
            }
            if (end < start) {
                end = start;
            }
            while (end < probeStar.length && probeStar[end].length <= candidateEdge.length + 13) {
                ++end;
            }
            for (int probeIndex = start; probeIndex < end; ++probeIndex) {
                double neighborDiff;
                NeighborEdge probeEdge = probeStar[probeIndex];
                double referenceDiff = DoubleAngle.difference(probeEdge.referenceAngle, candidateEdge.referenceAngle);
                if (!(referenceDiff <= Parameters.maxAngleError) && !(referenceDiff >= complementaryAngleError) || !((neighborDiff = DoubleAngle.difference(probeEdge.neighborAngle, candidateEdge.neighborAngle)) <= Parameters.maxAngleError) && !(neighborDiff >= complementaryAngleError)) continue;
                MinutiaPair pair = this.allocate();
                pair.probe = probeEdge.neighbor;
                pair.candidate = candidateEdge.neighbor;
                pair.distance = candidateEdge.length;
                results.add(pair);
            }
        }
        return results;
    }

    private void skipPaired() {
        while (!(this.queue.isEmpty() || this.byProbe[this.queue.peek().probe] == null && this.byCandidate[this.queue.peek().candidate] == null)) {
            MinutiaPair pair = (MinutiaPair)this.queue.remove();
            if (this.byProbe[pair.probe] != null && this.byProbe[pair.probe].candidate == pair.candidate) {
                this.addSupportingEdge(pair);
            }
            this.release(pair);
        }
    }

    private void addPair(MinutiaPair pair) {
        this.tree[this.count] = pair;
        this.byProbe[pair.probe] = pair;
        this.byCandidate[pair.candidate] = pair;
        ++this.count;
    }

    private void addSupportingEdge(MinutiaPair pair) {
        ++this.byProbe[pair.probe].supportingEdges;
        ++this.byProbe[pair.probeRef].supportingEdges;
        this.transparency.logSupportingEdge(pair);
    }

    private MinutiaPair allocate() {
        if (this.pooled > 0) {
            --this.pooled;
            MinutiaPair pair = this.pool[this.pooled];
            this.pool[this.pooled] = null;
            return pair;
        }
        return new MinutiaPair();
    }

    private void release(MinutiaPair pair) {
        if (this.pooled >= this.pool.length) {
            this.pool = Arrays.copyOf(this.pool, 2 * this.pool.length);
        }
        pair.probe = 0;
        pair.candidate = 0;
        pair.probeRef = 0;
        pair.candidateRef = 0;
        pair.distance = 0;
        pair.supportingEdges = 0;
        this.pool[this.pooled] = pair;
    }
}

