/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.noexception.Exceptions;
import com.machinezoo.sourceafis.EdgeShape;
import com.machinezoo.sourceafis.ImmutableMinutia;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.List;

class IndexedEdge
extends EdgeShape {
    final int reference;
    final int neighbor;

    IndexedEdge(ImmutableMinutia[] minutiae, int reference, int neighbor) {
        super(minutiae[reference], minutiae[neighbor]);
        this.reference = reference;
        this.neighbor = neighbor;
    }

    void write(DataOutputStream stream) {
        Exceptions.sneak().run(() -> {
            stream.writeInt(this.reference);
            stream.writeInt(this.neighbor);
            stream.writeInt(this.length);
            stream.writeDouble(this.referenceAngle);
            stream.writeDouble(this.neighborAngle);
        });
    }

    static byte[] serialize(TIntObjectHashMap<List<IndexedEdge>> hash) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream formatter = new DataOutputStream(buffer);
        int[] keys = hash.keys();
        Arrays.sort(keys);
        Exceptions.sneak().run(() -> {
            formatter.writeInt(keys.length);
            for (int key : keys) {
                formatter.writeInt(key);
                List edges = (List)hash.get(key);
                formatter.writeInt(edges.size());
                for (IndexedEdge edge : edges) {
                    edge.write(formatter);
                }
            }
            formatter.close();
        });
        return buffer.toByteArray();
    }
}

