/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.ForeignFormat;
import com.machinezoo.sourceafis.MinutiaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum ForeignMinutiaType {
    ENDING,
    BIFURCATION,
    EITHER,
    OTHER;

    private static final Logger logger;

    static ForeignMinutiaType decode(int code, ForeignFormat format) {
        switch (code) {
            case 0: {
                if (format == ForeignFormat.ANSI_378_2004 || format == ForeignFormat.ISO_19794_2_2005) {
                    return OTHER;
                }
                return EITHER;
            }
            case 1: {
                return ENDING;
            }
            case 2: {
                return BIFURCATION;
            }
        }
        logger.warn("Bad template: minutia type code must be one of 01, 10, or 00");
        return ENDING;
    }

    int encode(ForeignFormat format) {
        switch (this) {
            case ENDING: {
                return 1;
            }
            case BIFURCATION: {
                return 2;
            }
            case EITHER: {
                if (format == ForeignFormat.ANSI_378_2004) {
                    throw new IllegalArgumentException("Cannot create template: cannot encode 'either' minutia in format supporting only 'other' type");
                }
                return 0;
            }
            case OTHER: {
                if (format != ForeignFormat.ANSI_378_2004) {
                    throw new IllegalArgumentException("Cannot create template: cannot encode 'other' minutia in format supporting only 'either' type");
                }
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    static ForeignMinutiaType convert(MinutiaType type) {
        switch (type) {
            case ENDING: {
                return ENDING;
            }
            case BIFURCATION: {
                return BIFURCATION;
            }
        }
        throw new IllegalStateException();
    }

    MinutiaType convert() {
        switch (this) {
            case ENDING: {
                return MinutiaType.ENDING;
            }
            case BIFURCATION: {
                return MinutiaType.BIFURCATION;
            }
            case EITHER: 
            case OTHER: {
                logger.debug("Imperfect template import: changing 'either' or 'other' minutia type to 'ending'");
                return MinutiaType.ENDING;
            }
        }
        throw new IllegalStateException();
    }

    static {
        logger = LoggerFactory.getLogger(ForeignMinutiaType.class);
    }
}

