/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.ForeignDimensions;
import com.machinezoo.sourceafis.ForeignFormat;
import com.machinezoo.sourceafis.ForeignMinutiaType;
import com.machinezoo.sourceafis.ImmutableMinutia;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForeignMinutia {
    private static final Logger logger = LoggerFactory.getLogger(ForeignMinutia.class);
    ForeignMinutiaType type;
    int x;
    int y;
    double angle;

    ForeignMinutia(ImmutableMinutia minutia) {
        this.type = ForeignMinutiaType.convert(minutia.type);
        this.x = minutia.position.x;
        this.y = minutia.position.y;
        this.angle = minutia.direction;
    }

    ForeignMinutia(DataInputStream in, ForeignFormat format, ForeignDimensions dimensions) throws IOException {
        this.readTypeAndX(in, format, dimensions);
        this.readY(in, dimensions);
        this.readAngle(in, format);
        this.readQuality(in, format);
    }

    void write(DataOutputStream out, ForeignFormat format, ForeignDimensions dimensions) throws IOException {
        this.writeTypeAndX(out, format, dimensions);
        this.writeY(out, dimensions);
        this.writeAngle(out, format);
        this.writeQuality(out, format);
    }

    private void readTypeAndX(DataInputStream in, ForeignFormat format, ForeignDimensions dimensions) throws IOException {
        int combined = in.readUnsignedShort();
        this.type = ForeignMinutiaType.decode(combined >> 14, format);
        this.x = combined & 0x3FFF;
        if (this.x >= dimensions.width) {
            logger.warn("Bad template: minutia X position must be within image dimensions");
        }
    }

    private void writeTypeAndX(DataOutputStream out, ForeignFormat format, ForeignDimensions dimensions) throws IOException {
        if (this.x < 0 || this.x >= dimensions.width) {
            throw new IllegalArgumentException("Cannot create template: minutia X position outside image dimensions");
        }
        if (this.x >= 16384) {
            throw new IllegalArgumentException("Cannot create template: minutia X position must be an unsigned 14-bit number");
        }
        out.writeShort(this.type.encode(format) << 14 | this.x);
    }

    private void readY(DataInputStream in, ForeignDimensions dimensions) throws IOException {
        int combined = in.readUnsignedShort();
        if (combined >= 16384) {
            logger.warn("Bad template: top two bits in minutia Y position must be zero");
        }
        this.y = combined & 0x3FFF;
        if (this.y >= dimensions.height) {
            logger.warn("Bad template: minutia Y position must be within image dimensions");
        }
    }

    private void writeY(DataOutputStream out, ForeignDimensions dimensions) throws IOException {
        if (this.y < 0 || this.y >= dimensions.height) {
            throw new IllegalArgumentException("Cannot create template: minutia Y position outside image dimensions");
        }
        if (this.y >= 16384) {
            throw new IllegalArgumentException("Cannot create template: minutia Y position must be an unsigned 14-bit number");
        }
        out.writeShort(this.y);
    }

    private void readAngle(DataInputStream in, ForeignFormat format) throws IOException {
        int quantized = in.readUnsignedByte();
        if (format == ForeignFormat.ISO_19794_2_2005) {
            this.angle = DoubleAngle.complementary(((double)quantized + 0.5) / 256.0 * (Math.PI * 2));
        } else {
            if (quantized >= 180) {
                logger.warn("Bad template: minutia angle must be in range 0-179");
            }
            this.angle = DoubleAngle.complementary((double)((2 * quantized - 1 + 360) % 360) / 360.0 * (Math.PI * 2));
        }
    }

    private void writeAngle(DataOutputStream out, ForeignFormat format) throws IOException {
        double normalized = DoubleAngle.complementary(this.angle < 0.0 ? this.angle + Math.PI * 2 : (this.angle >= Math.PI * 2 ? this.angle - Math.PI * 2 : this.angle));
        if (normalized < 0.0 || normalized >= Math.PI * 2) {
            throw new IllegalArgumentException("Cannot create template: angle must be in range [0, 2pi)");
        }
        int quantized = (int)Math.ceil(normalized / (Math.PI * 2) * 360.0 / 2.0);
        if (quantized >= 180) {
            quantized -= 180;
        }
        if (quantized < 0 || quantized >= 180) {
            throw new IllegalArgumentException("Cannot create template: angle must be in range 0-179");
        }
        out.writeByte(quantized);
    }

    private void readQuality(DataInputStream in, ForeignFormat format) throws IOException {
        int quality = in.readUnsignedByte();
        if (format == ForeignFormat.ANSI_378_2004) {
            if (quality > 100) {
                logger.warn("Bad template: minutia quality must be in range 1-100 or zero");
            }
        } else if (format != ForeignFormat.ISO_19794_2_2005 && quality > 100 && quality < 254) {
            logger.warn("Bad template: minutia quality must be in range 0-100 or a special value 254 or 255");
        }
    }

    private void writeQuality(DataOutputStream out, ForeignFormat format) throws IOException {
        if (format == ForeignFormat.ANSI_378_2004) {
            out.writeByte(0);
        } else {
            out.writeByte(254);
        }
    }
}

