/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.FingerprintTemplate;
import com.machinezoo.sourceafis.ForeignDimensions;
import com.machinezoo.sourceafis.ForeignFormat;
import com.machinezoo.sourceafis.ForeignMinutia;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForeignFingerprint {
    private static final Logger logger = LoggerFactory.getLogger(ForeignFingerprint.class);
    ForeignDimensions dimensions;
    List<ForeignMinutia> minutiae = new ArrayList<ForeignMinutia>();

    ForeignFingerprint(FingerprintTemplate template) {
        this.dimensions = new ForeignDimensions(template);
        this.minutiae = Arrays.stream(template.immutable.minutiae).map(ForeignMinutia::new).collect(Collectors.toList());
    }

    ForeignFingerprint(DataInputStream in, ForeignFormat format, ForeignDimensions sharedDimensions) throws IOException {
        this.readPosition(in, format);
        if (format == ForeignFormat.ISO_19794_2_2005) {
            in.skipBytes(1);
        } else {
            this.readOffsetAndImpression(in, format);
        }
        this.readQuality(in, format);
        this.dimensions = format == ForeignFormat.ANSI_378_2004 || format == ForeignFormat.ISO_19794_2_2005 ? sharedDimensions : new ForeignDimensions(in);
        int count = this.readMinutiaCount(in);
        for (int i = 0; i < count; ++i) {
            this.minutiae.add(new ForeignMinutia(in, format, this.dimensions));
        }
        this.readExtensions(in);
    }

    void write(DataOutputStream out, ForeignFormat format, int offset) throws IOException {
        this.writePosition(out);
        this.writeOffsetAndImpression(out, format, offset);
        this.writeQuality(out, format);
        if (format != ForeignFormat.ANSI_378_2004) {
            this.dimensions.write(out);
        }
        this.writeMinutiaCount(out);
        for (ForeignMinutia minutia : this.minutiae) {
            minutia.write(out, format, this.dimensions);
        }
        this.writeExtensions(out);
    }

    int measure(ForeignFormat format) {
        int fixed;
        switch (format) {
            case ANSI_378_2004: {
                fixed = 6;
                break;
            }
            case ANSI_378_2009: 
            case ANSI_378_2009_AM1: {
                fixed = 19;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return fixed + 6 * this.minutiae.size();
    }

    private void readPosition(DataInputStream in, ForeignFormat format) throws IOException {
        int position = in.readUnsignedByte();
        if (format != ForeignFormat.ANSI_378_2009_AM1 && position > 10) {
            logger.warn("Bad template: finger position must be in range 0-10");
        }
        if (!(format != ForeignFormat.ANSI_378_2009_AM1 || position <= 10 || position >= 13 && position <= 15 || position >= 40 && position <= 50)) {
            logger.warn("Bad template: finger position must be in range 0-10, 13-15, or 40-50");
        }
    }

    private void writePosition(DataOutputStream out) throws IOException {
        out.writeByte(0);
    }

    private void readOffsetAndImpression(DataInputStream in, ForeignFormat format) throws IOException {
        if (format == ForeignFormat.ANSI_378_2004) {
            int combined = in.readUnsignedByte();
            int type = combined & 0xF;
            if (type > 3 && type != 8 && type != 9) {
                logger.warn("Bad template: sensor category / impression type must be in range 0-3 or 8-9");
            }
        } else {
            int type;
            int offset = in.readUnsignedByte();
            if (offset > 15) {
                logger.warn("Bad template: view offset must be in range 0-15");
            }
            if ((type = in.readUnsignedByte()) > 3 && type != 8 && type != 10 && type != 11 && (type < 20 || type > 29)) {
                logger.warn("Bad template: sensor category / impression type must be in range 0-3, 8, 10-11, or 20-29");
            }
        }
    }

    private void writeOffsetAndImpression(DataOutputStream out, ForeignFormat format, int offset) throws IOException {
        if (offset > 15) {
            throw new IllegalArgumentException("Cannot create template: at most 16 views are allowed per finger position");
        }
        if (format == ForeignFormat.ANSI_378_2004) {
            out.writeByte(offset << 4);
        } else {
            out.writeByte(offset);
            out.writeByte(29);
        }
    }

    private void readQuality(DataInputStream in, ForeignFormat format) throws IOException {
        if (format == ForeignFormat.ISO_19794_2_2005) {
            in.skipBytes(1);
        } else if (format == ForeignFormat.ANSI_378_2004) {
            int quality = in.readUnsignedByte();
            if (quality > 100) {
                logger.warn("Bad template: fingerprint quality must be in range 0-100");
            }
        } else {
            int qowner;
            int quality = in.readUnsignedByte();
            if (quality > 100 && quality != 254 && quality != 255) {
                logger.warn("Bad template: fingerprint quality must be in range 0-100 or have special value 254 or 255");
            }
            if ((qowner = in.readUnsignedShort()) == 0) {
                logger.debug("Not strictly compliant template: zero quality algorithm owner");
            }
            in.readUnsignedShort();
        }
    }

    private void writeQuality(DataOutputStream out, ForeignFormat format) throws IOException {
        if (format == ForeignFormat.ANSI_378_2004) {
            out.writeByte(100);
        } else {
            out.writeByte(254);
            out.writeInt(0x1030001);
        }
    }

    private int readMinutiaCount(DataInputStream in) throws IOException {
        return in.readUnsignedByte();
    }

    private void writeMinutiaCount(DataOutputStream out) throws IOException {
        if (this.minutiae.size() > 255) {
            throw new IllegalArgumentException("Cannot create template: maximum number of minutiae is 255");
        }
        out.writeByte(this.minutiae.size());
    }

    private void readExtensions(DataInputStream in) throws IOException {
        int length = in.readUnsignedShort();
        in.skipBytes(length);
    }

    private void writeExtensions(DataOutputStream out) throws IOException {
        out.writeShort(0);
    }
}

