/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.google.gson.GsonBuilder;
import com.machinezoo.noexception.Exceptions;
import com.machinezoo.sourceafis.BlockMap;
import com.machinezoo.sourceafis.BooleanMatrix;
import com.machinezoo.sourceafis.CircularList;
import com.machinezoo.sourceafis.DoubleMatrix;
import com.machinezoo.sourceafis.DoublePointMatrix;
import com.machinezoo.sourceafis.FingerprintCompatibility;
import com.machinezoo.sourceafis.HistogramCube;
import com.machinezoo.sourceafis.IndexedEdge;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.JsonTemplate;
import com.machinezoo.sourceafis.MinutiaPair;
import com.machinezoo.sourceafis.NeighborEdge;
import com.machinezoo.sourceafis.Score;
import com.machinezoo.sourceafis.Skeleton;
import com.machinezoo.sourceafis.SkeletonMinutia;
import com.machinezoo.sourceafis.SkeletonType;
import com.machinezoo.sourceafis.TemplateBuilder;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class FingerprintTransparency
implements AutoCloseable {
    private static final ThreadLocal<FingerprintTransparency> current = new ThreadLocal();
    private FingerprintTransparency outer;
    private static final FingerprintTransparency none = new NoFingerprintTransparency();
    private List<JsonEdge> supportingEdges = new ArrayList<JsonEdge>();
    private AtomicInteger loggedVersion = new AtomicInteger();

    protected FingerprintTransparency() {
        this.outer = current.get();
        current.set(this);
    }

    protected void capture(String keyword, Map<String, Supplier<byte[]>> data) {
        HashMap<String, Supplier<ByteBuffer>> translated = new HashMap<String, Supplier<ByteBuffer>>();
        for (Map.Entry<String, Supplier<byte[]>> entry : data.entrySet()) {
            translated.put(entry.getKey(), () -> ByteBuffer.wrap((byte[])((Supplier)entry.getValue()).get()));
        }
        this.log(keyword, translated);
    }

    @Deprecated
    protected void log(String keyword, Map<String, Supplier<ByteBuffer>> data) {
    }

    @Override
    public void close() {
        current.set(this.outer);
        this.outer = null;
    }

    public static FingerprintTransparency zip(OutputStream stream) {
        return new TransparencyZip(stream);
    }

    static FingerprintTransparency current() {
        return Optional.ofNullable(current.get()).orElse(none);
    }

    boolean logging() {
        return this != none;
    }

    void logDecodedImage(DoubleMatrix image) {
        this.logDoubleMap("decoded-image", image);
    }

    void logScaledImage(DoubleMatrix image) {
        this.logDoubleMap("scaled-image", image);
    }

    void logBlockMap(BlockMap blocks) {
        this.log("block-map", ".json", this.json(() -> blocks));
    }

    void logHistogram(HistogramCube histogram) {
        this.logHistogram("histogram", histogram);
    }

    void logSmoothedHistogram(HistogramCube histogram) {
        this.logHistogram("smoothed-histogram", histogram);
    }

    void logClippedContrast(DoubleMatrix contrast) {
        this.logDoubleMap("clipped-contrast", contrast);
    }

    void logAbsoluteContrastMask(BooleanMatrix mask) {
        this.logBooleanMap("absolute-contrast-mask", mask);
    }

    void logRelativeContrastMask(BooleanMatrix mask) {
        this.logBooleanMap("relative-contrast-mask", mask);
    }

    void logCombinedMask(BooleanMatrix mask) {
        this.logBooleanMap("combined-mask", mask);
    }

    void logFilteredMask(BooleanMatrix mask) {
        this.logBooleanMap("filtered-mask", mask);
    }

    void logEqualizedImage(DoubleMatrix image) {
        this.logDoubleMap("equalized-image", image);
    }

    void logPixelwiseOrientation(DoublePointMatrix orientations) {
        this.logPointMap("pixelwise-orientation", orientations);
    }

    void logBlockOrientation(DoublePointMatrix orientations) {
        this.logPointMap("block-orientation", orientations);
    }

    void logSmoothedOrientation(DoublePointMatrix orientations) {
        this.logPointMap("smoothed-orientation", orientations);
    }

    void logParallelSmoothing(DoubleMatrix smoothed) {
        this.logDoubleMap("parallel-smoothing", smoothed);
    }

    void logOrthogonalSmoothing(DoubleMatrix smoothed) {
        this.logDoubleMap("orthogonal-smoothing", smoothed);
    }

    void logBinarizedImage(BooleanMatrix image) {
        this.logBooleanMap("binarized-image", image);
    }

    void logFilteredBinarydImage(BooleanMatrix image) {
        this.logBooleanMap("filtered-binary-image", image);
    }

    void logPixelMask(BooleanMatrix image) {
        this.logBooleanMap("pixel-mask", image);
    }

    void logInnerMask(BooleanMatrix image) {
        this.logBooleanMap("inner-mask", image);
    }

    void logBinarizedSkeleton(SkeletonType type, BooleanMatrix image) {
        this.logBooleanMap(type.prefix + "binarized-skeleton", image);
    }

    void logThinnedSkeleton(SkeletonType type, BooleanMatrix image) {
        this.logBooleanMap(type.prefix + "thinned-skeleton", image);
    }

    void logTracedSkeleton(Skeleton skeleton) {
        this.logSkeleton("traced-skeleton", skeleton);
    }

    void logRemovedDots(Skeleton skeleton) {
        this.logSkeleton("removed-dots", skeleton);
    }

    void logRemovedPores(Skeleton skeleton) {
        this.logSkeleton("removed-pores", skeleton);
    }

    void logRemovedGaps(Skeleton skeleton) {
        this.logSkeleton("removed-gaps", skeleton);
    }

    void logRemovedTails(Skeleton skeleton) {
        this.logSkeleton("removed-tails", skeleton);
    }

    void logRemovedFragments(Skeleton skeleton) {
        this.logSkeleton("removed-fragments", skeleton);
    }

    void logSkeletonMinutiae(TemplateBuilder template) {
        this.logMinutiae("skeleton-minutiae", template);
    }

    void logInnerMinutiae(TemplateBuilder template) {
        this.logMinutiae("inner-minutiae", template);
    }

    void logRemovedMinutiaClouds(TemplateBuilder template) {
        this.logMinutiae("removed-minutia-clouds", template);
    }

    void logTopMinutiae(TemplateBuilder template) {
        this.logMinutiae("top-minutiae", template);
    }

    void logShuffledMinutiae(TemplateBuilder template) {
        this.logMinutiae("shuffled-minutiae", template);
    }

    void logEdgeTable(NeighborEdge[][] table) {
        this.log("edge-table", ".json", this.json(() -> table));
    }

    void logEdgeHash(TIntObjectHashMap<List<IndexedEdge>> edgeHash) {
        this.log("edge-hash", ".dat", () -> IndexedEdge.serialize(edgeHash));
    }

    void logRootPairs(int count, MinutiaPair[] roots) {
        if (this.logging()) {
            this.log("root-pairs", ".json", this.json(() -> JsonPair.roots(count, roots)));
        }
    }

    void logSupportingEdge(MinutiaPair pair) {
        if (this.logging()) {
            this.supportingEdges.add(new JsonEdge(pair));
        }
    }

    void logPairing(int count, MinutiaPair[] pairs) {
        if (this.logging()) {
            this.log("pairing", ".json", this.json(() -> new JsonPairing(count, pairs, this.supportingEdges)));
            this.supportingEdges.clear();
        }
    }

    void logScore(Score score) {
        if (this.logging()) {
            this.log("score", ".json", this.json(() -> score));
        }
    }

    void logBestMatch(int nth) {
        if (this.logging()) {
            this.log("best-match", ".json", this.json(() -> new JsonBestMatch(nth)));
        }
    }

    private void logSkeleton(String name, Skeleton skeleton) {
        this.log(skeleton.type.prefix + name, ".json", this.json(() -> new JsonSkeleton(skeleton)), ".dat", skeleton::serialize);
    }

    private void logMinutiae(String name, TemplateBuilder template) {
        if (this.logging()) {
            this.log(name, ".json", this.json(() -> new JsonTemplate(template.size, template.minutiae)));
        }
    }

    private void logHistogram(String name, HistogramCube histogram) {
        this.log(name, ".dat", histogram::serialize, ".json", this.json(histogram::json));
    }

    private void logPointMap(String name, DoublePointMatrix matrix) {
        this.log(name, ".dat", matrix::serialize, ".json", this.json(matrix::json));
    }

    private void logDoubleMap(String name, DoubleMatrix matrix) {
        this.log(name, ".dat", matrix::serialize, ".json", this.json(matrix::json));
    }

    private void logBooleanMap(String name, BooleanMatrix matrix) {
        this.log(name, ".dat", matrix::serialize, ".json", this.json(matrix::json));
    }

    private Supplier<byte[]> json(Supplier<Object> supplier) {
        return () -> new GsonBuilder().setPrettyPrinting().create().toJson(supplier.get()).getBytes(StandardCharsets.UTF_8);
    }

    private void logVersion() {
        if (this.logging() && this.loggedVersion.getAndSet(1) == 0) {
            HashMap<String, Supplier<byte[]>> map = new HashMap<String, Supplier<byte[]>>();
            map.put(".json", this.json(() -> new JsonVersion(FingerprintCompatibility.version())));
            this.capture("version", map);
        }
    }

    private void log(String name, String suffix, Supplier<byte[]> supplier) {
        HashMap<String, Supplier<byte[]>> map = new HashMap<String, Supplier<byte[]>>();
        map.put(suffix, supplier);
        this.logVersion();
        this.capture(name, map);
    }

    private void log(String name, String suffix1, Supplier<byte[]> supplier1, String suffix2, Supplier<byte[]> supplier2) {
        HashMap<String, Supplier<byte[]>> map = new HashMap<String, Supplier<byte[]>>();
        map.put(suffix1, supplier1);
        map.put(suffix2, supplier2);
        this.logVersion();
        this.capture(name, map);
    }

    static {
        none.close();
    }

    private static class JsonVersion {
        String version;

        JsonVersion(String version) {
            this.version = version;
        }
    }

    private static class JsonSkeletonRidge {
        int start;
        int end;
        int length;

        private JsonSkeletonRidge() {
        }
    }

    private static class JsonSkeleton {
        int width;
        int height;
        List<IntPoint> minutiae;
        List<JsonSkeletonRidge> ridges;

        JsonSkeleton(Skeleton skeleton) {
            this.width = skeleton.size.x;
            this.height = skeleton.size.y;
            HashMap<SkeletonMinutia, Integer> offsets = new HashMap<SkeletonMinutia, Integer>();
            for (int i = 0; i < skeleton.minutiae.size(); ++i) {
                offsets.put(skeleton.minutiae.get(i), i);
            }
            this.minutiae = skeleton.minutiae.stream().map(m -> m.position).collect(Collectors.toList());
            this.ridges = skeleton.minutiae.stream().flatMap(m -> m.ridges.stream().filter(r -> r.points instanceof CircularList).map(r -> {
                JsonSkeletonRidge jr = new JsonSkeletonRidge();
                jr.start = (Integer)offsets.get(r.start());
                jr.end = (Integer)offsets.get(r.end());
                jr.length = r.points.size();
                return jr;
            })).collect(Collectors.toList());
        }
    }

    private static class JsonBestMatch {
        int offset;

        JsonBestMatch(int offset) {
            this.offset = offset;
        }
    }

    private static class JsonEdge {
        int probeFrom;
        int probeTo;
        int candidateFrom;
        int candidateTo;

        JsonEdge(MinutiaPair pair) {
            this.probeFrom = pair.probeRef;
            this.probeTo = pair.probe;
            this.candidateFrom = pair.candidateRef;
            this.candidateTo = pair.candidate;
        }
    }

    private static class JsonPair {
        int probe;
        int candidate;

        JsonPair(int probe, int candidate) {
            this.probe = probe;
            this.candidate = candidate;
        }

        static List<JsonPair> roots(int count, MinutiaPair[] roots) {
            return Arrays.stream(roots).limit(count).map(p -> new JsonPair(p.probe, p.candidate)).collect(Collectors.toList());
        }
    }

    private static class JsonPairing {
        JsonPair root;
        List<JsonEdge> tree;
        List<JsonEdge> support;

        JsonPairing(int count, MinutiaPair[] pairs, List<JsonEdge> supporting) {
            this.root = new JsonPair(pairs[0].probe, pairs[0].candidate);
            this.tree = Arrays.stream(pairs).limit(count).skip(1L).map(JsonEdge::new).collect(Collectors.toList());
            this.support = supporting;
        }
    }

    private static class NoFingerprintTransparency
    extends FingerprintTransparency {
        private NoFingerprintTransparency() {
        }

        @Override
        protected void capture(String keyword, Map<String, Supplier<byte[]>> data) {
        }
    }

    private static class TransparencyZip
    extends FingerprintTransparency {
        private final ZipOutputStream zip;
        private int offset;

        TransparencyZip(OutputStream stream) {
            this.zip = new ZipOutputStream(stream);
        }

        @Override
        protected void capture(String keyword, Map<String, Supplier<byte[]>> data) {
            Exceptions.wrap().run(() -> {
                List suffixes = data.keySet().stream().sorted(Comparator.comparing(ext -> {
                    if (ext.equals(".json")) {
                        return 1;
                    }
                    if (ext.equals(".dat")) {
                        return 2;
                    }
                    return 3;
                })).collect(Collectors.toList());
                for (String suffix : suffixes) {
                    ++this.offset;
                    this.zip.putNextEntry(new ZipEntry(String.format("%03d", this.offset) + "-" + keyword + suffix));
                    this.zip.write((byte[])((Supplier)data.get(suffix)).get());
                    this.zip.closeEntry();
                }
            });
        }

        @Override
        public void close() {
            super.close();
            Exceptions.sneak().run(this.zip::close);
        }
    }
}

