/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.JsonArrayInfo;
import java.nio.ByteBuffer;

class DoubleMatrix {
    final int width;
    final int height;
    private final double[] array;

    DoubleMatrix(int width, int height) {
        this.width = width;
        this.height = height;
        this.array = new double[width * height];
    }

    DoubleMatrix(IntPoint size) {
        this(size.x, size.y);
    }

    IntPoint size() {
        return new IntPoint(this.width, this.height);
    }

    double get(int x, int y) {
        return this.array[this.offset(x, y)];
    }

    double get(IntPoint at) {
        return this.get(at.x, at.y);
    }

    void set(int x, int y, double value) {
        this.array[this.offset((int)x, (int)y)] = value;
    }

    void set(IntPoint at, double value) {
        this.set(at.x, at.y, value);
    }

    void add(int x, int y, double value) {
        int n = this.offset(x, y);
        this.array[n] = this.array[n] + value;
    }

    void add(IntPoint at, double value) {
        this.add(at.x, at.y, value);
    }

    void multiply(int x, int y, double value) {
        int n = this.offset(x, y);
        this.array[n] = this.array[n] * value;
    }

    void multiply(IntPoint at, double value) {
        this.multiply(at.x, at.y, value);
    }

    byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(8 * this.array.length);
        buffer.asDoubleBuffer().put(this.array);
        return buffer.array();
    }

    JsonArrayInfo json() {
        JsonArrayInfo info = new JsonArrayInfo();
        info.axes = new String[]{"y", "x"};
        info.dimensions = new int[]{this.height, this.width};
        info.scalar = "double";
        info.bitness = 64;
        info.endianness = "big";
        info.format = "IEEE754";
        return info;
    }

    private int offset(int x, int y) {
        return y * this.width + x;
    }
}

