/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.FingerprintTemplate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForeignDimensions {
    private static final Logger logger = LoggerFactory.getLogger(ForeignDimensions.class);
    int width;
    int height;
    double dpiX;
    double dpiY;

    ForeignDimensions(FingerprintTemplate template) {
        this.width = template.immutable.size.x;
        this.height = template.immutable.size.y;
        this.dpiX = 500.0;
        this.dpiY = 500.0;
    }

    ForeignDimensions(DataInputStream in) throws IOException {
        this.width = in.readUnsignedShort();
        this.height = in.readUnsignedShort();
        if (this.width == 0 || this.height == 0) {
            logger.warn("Bad template: zero image width or height");
        }
        this.dpiX = (double)in.readUnsignedShort() * 2.54;
        this.dpiY = (double)in.readUnsignedShort() * 2.54;
        if (this.dpiX < 5.0 || this.dpiY < 5.0) {
            throw new IllegalArgumentException("Bad template: zero or too low DPI");
        }
        if (this.dpiX < 200.0 || this.dpiX > 2000.0 || this.dpiY < 200.0 || this.dpiY > 2000.0) {
            logger.warn("Probably bad template: DPI lower than 200 or higher than 2,000");
        }
    }

    void write(DataOutputStream out) throws IOException {
        if (this.width < 0 || this.width >= 65536 || this.height < 0 || this.height >= 65536) {
            throw new IllegalArgumentException("Cannot create template: image dimensions are not 16-bit unsigned numbers");
        }
        if (this.width == 0 || this.height == 0) {
            throw new IllegalArgumentException("Cannot create template: zero image width or height");
        }
        out.writeShort(this.width);
        out.writeShort(this.height);
        double dpiMax = 166458.9;
        if (this.dpiX < 0.0 || this.dpiX > dpiMax || this.dpiY < 0.0 || this.dpiY > dpiMax) {
            throw new IllegalArgumentException("Cannot create template: DPI cannot be encoded as a 16-bit unsigned number in px/cm units");
        }
        if (this.dpiX < 5.0 || this.dpiY < 5.0) {
            throw new IllegalArgumentException("Cannot create template: zero or too low DPI");
        }
        if (this.dpiX < 200.0 || this.dpiX > 2000.0 || this.dpiY < 200.0 || this.dpiY > 2000.0) {
            logger.warn("Creating probably bad template: DPI lower than 200 or higher than 2,000");
        }
        out.writeShort((int)Math.round(this.dpiX / 2.54));
        out.writeShort((int)Math.round(this.dpiY / 2.54));
    }
}

