/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoublePoint;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.JsonArrayInfo;
import java.nio.ByteBuffer;

class DoublePointMatrix {
    final int width;
    final int height;
    private final double[] array;

    DoublePointMatrix(int width, int height) {
        this.width = width;
        this.height = height;
        this.array = new double[2 * width * height];
    }

    DoublePointMatrix(IntPoint size) {
        this(size.x, size.y);
    }

    IntPoint size() {
        return new IntPoint(this.width, this.height);
    }

    DoublePoint get(int x, int y) {
        int i = this.offset(x, y);
        return new DoublePoint(this.array[i], this.array[i + 1]);
    }

    DoublePoint get(IntPoint at) {
        return this.get(at.x, at.y);
    }

    void set(int x, int y, double px, double py) {
        int i = this.offset(x, y);
        this.array[i] = px;
        this.array[i + 1] = py;
    }

    void set(int x, int y, DoublePoint point) {
        this.set(x, y, point.x, point.y);
    }

    void set(IntPoint at, DoublePoint point) {
        this.set(at.x, at.y, point);
    }

    void add(int x, int y, double px, double py) {
        int i;
        int n = i = this.offset(x, y);
        this.array[n] = this.array[n] + px;
        int n2 = i + 1;
        this.array[n2] = this.array[n2] + py;
    }

    void add(int x, int y, DoublePoint point) {
        this.add(x, y, point.x, point.y);
    }

    void add(IntPoint at, DoublePoint point) {
        this.add(at.x, at.y, point);
    }

    byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(8 * this.array.length);
        buffer.asDoubleBuffer().put(this.array);
        return buffer.array();
    }

    JsonArrayInfo json() {
        JsonArrayInfo info = new JsonArrayInfo();
        info.axes = new String[]{"y", "x", "axis"};
        info.dimensions = new int[]{this.height, this.width, 2};
        info.scalar = "double";
        info.bitness = 64;
        info.endianness = "big";
        info.format = "IEEE754";
        return info;
    }

    private int offset(int x, int y) {
        return 2 * (y * this.width + x);
    }
}

