/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.CircularArray;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

class CircularList<T>
implements List<T> {
    private final CircularArray inner = new CircularArray(16);

    CircularList() {
    }

    @Override
    public boolean add(T item) {
        this.inner.insert(this.inner.size, 1);
        this.inner.set(this.inner.size - 1, item);
        return true;
    }

    @Override
    public void add(int index, T item) {
        this.inner.insert(index, 1);
        this.inner.set(index, item);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        for (T item : collection) {
            this.add(item);
        }
        return !collection.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        this.inner.insert(index, collection.size());
        for (T item : collection) {
            this.inner.set(index, item);
            ++index;
        }
        return !collection.isEmpty();
    }

    @Override
    public void clear() {
        this.inner.remove(0, this.inner.size);
    }

    @Override
    public boolean contains(Object item) {
        for (int i = 0; i < this.size(); ++i) {
            if (!Objects.equals(this.get(i), item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object item : collection) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Objects.equals(this.get(i), other.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        return (T)this.inner.get(index);
    }

    @Override
    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.size(); ++i) {
            hash = 31 * hash + Objects.hashCode(this.inner.get(i));
        }
        return hash;
    }

    @Override
    public int indexOf(Object item) {
        for (int i = 0; i < this.size(); ++i) {
            if (!Objects.equals(this.get(i), item)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    @Override
    public int lastIndexOf(Object item) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!Objects.equals(this.get(i), item)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ArrayIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.inner.validateCursorIndex(index);
        ArrayIterator iterator = new ArrayIterator();
        iterator.index = index;
        return iterator;
    }

    @Override
    public T remove(int index) {
        T result = this.get(index);
        this.inner.remove(index, 1);
        return result;
    }

    @Override
    public boolean remove(Object item) {
        int index = this.indexOf(item);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object item : collection) {
            changed |= this.remove(item);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (collection.contains(this.get(i))) continue;
            this.remove(i);
            changed = true;
        }
        return changed;
    }

    @Override
    public T set(int index, T element) {
        T previous = this.get(index);
        this.inner.set(index, element);
        return previous;
    }

    @Override
    public int size() {
        return this.inner.size;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public <U> U[] toArray(U[] array) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (int i = 0; i < this.inner.size; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(Objects.toString(this.inner.get(i)));
        }
        s.append("]");
        return s.toString();
    }

    private class ArrayIterator
    implements ListIterator<T> {
        int index = 0;

        private ArrayIterator() {
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < CircularList.this.size();
        }

        @Override
        public T next() {
            if (this.index >= CircularList.this.size()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return CircularList.this.get(this.index - 1);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public T previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            --this.index;
            return CircularList.this.get(this.index);
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }
    }
}

