/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.JsonArrayInfo;
import java.nio.ByteBuffer;

class BooleanMatrix {
    final int width;
    final int height;
    private final boolean[] array;

    BooleanMatrix(int width, int height) {
        this.width = width;
        this.height = height;
        this.array = new boolean[width * height];
    }

    BooleanMatrix(IntPoint size) {
        this(size.x, size.y);
    }

    BooleanMatrix(BooleanMatrix other) {
        this(other.size());
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = other.array[i];
        }
    }

    IntPoint size() {
        return new IntPoint(this.width, this.height);
    }

    boolean get(int x, int y) {
        return this.array[this.offset(x, y)];
    }

    boolean get(IntPoint at) {
        return this.get(at.x, at.y);
    }

    boolean get(int x, int y, boolean fallback) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return fallback;
        }
        return this.array[this.offset(x, y)];
    }

    boolean get(IntPoint at, boolean fallback) {
        return this.get(at.x, at.y, fallback);
    }

    void set(int x, int y, boolean value) {
        this.array[this.offset((int)x, (int)y)] = value;
    }

    void set(IntPoint at, boolean value) {
        this.set(at.x, at.y, value);
    }

    void invert() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = !this.array[i];
        }
    }

    void merge(BooleanMatrix other) {
        if (other.width != this.width || other.height != this.height) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.array.length; ++i) {
            int n = i;
            this.array[n] = this.array[n] | other.array[i];
        }
    }

    byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(this.size().area());
        for (IntPoint at : this.size()) {
            buffer.put((byte)(this.get(at) ? 1 : 0));
        }
        return buffer.array();
    }

    JsonArrayInfo json() {
        JsonArrayInfo info = new JsonArrayInfo();
        info.axes = new String[]{"y", "x"};
        info.dimensions = new int[]{this.height, this.width};
        info.scalar = "boolean";
        info.bitness = 8;
        info.format = "false as 0, true as 1";
        return info;
    }

    private int offset(int x, int y) {
        return y * this.width + x;
    }
}

