/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.google.gson.Gson;
import com.machinezoo.sourceafis.BlockMap;
import com.machinezoo.sourceafis.BooleanMatrix;
import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.DoubleMatrix;
import com.machinezoo.sourceafis.DoublePoint;
import com.machinezoo.sourceafis.DoublePointMatrix;
import com.machinezoo.sourceafis.Doubles;
import com.machinezoo.sourceafis.FingerprintTransparency;
import com.machinezoo.sourceafis.ForeignFingerprint;
import com.machinezoo.sourceafis.ForeignMinutia;
import com.machinezoo.sourceafis.ForeignTemplate;
import com.machinezoo.sourceafis.HistogramCube;
import com.machinezoo.sourceafis.ImmutableMinutia;
import com.machinezoo.sourceafis.IntMatrix;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.IntRange;
import com.machinezoo.sourceafis.IntRect;
import com.machinezoo.sourceafis.Integers;
import com.machinezoo.sourceafis.JsonTemplate;
import com.machinezoo.sourceafis.MinutiaType;
import com.machinezoo.sourceafis.NeighborEdge;
import com.machinezoo.sourceafis.Skeleton;
import com.machinezoo.sourceafis.SkeletonType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

class TemplateBuilder {
    IntPoint size;
    ImmutableMinutia[] minutiae;
    NeighborEdge[][] edges;

    TemplateBuilder() {
    }

    void extract(DoubleMatrix raw, double dpi) {
        FingerprintTransparency.current().logDecodedImage(raw);
        if (Math.abs(dpi - 500.0) > 5.0) {
            raw = TemplateBuilder.scaleImage(raw, dpi);
        }
        FingerprintTransparency.current().logScaledImage(raw);
        this.size = raw.size();
        BlockMap blocks = new BlockMap(raw.width, raw.height, 15);
        FingerprintTransparency.current().logBlockMap(blocks);
        HistogramCube histogram = this.histogram(blocks, raw);
        HistogramCube smoothHistogram = this.smoothHistogram(blocks, histogram);
        BooleanMatrix mask = this.mask(blocks, histogram);
        DoubleMatrix equalized = this.equalize(blocks, raw, smoothHistogram, mask);
        DoubleMatrix orientation = this.orientationMap(equalized, mask, blocks);
        IntPoint[][] smoothedLines = this.orientedLines(32, 7, 1.59);
        DoubleMatrix smoothed = TemplateBuilder.smoothRidges(equalized, orientation, mask, blocks, 0.0, smoothedLines);
        FingerprintTransparency.current().logParallelSmoothing(smoothed);
        IntPoint[][] orthogonalLines = this.orientedLines(11, 4, 1.11);
        DoubleMatrix orthogonal = TemplateBuilder.smoothRidges(smoothed, orientation, mask, blocks, Math.PI, orthogonalLines);
        FingerprintTransparency.current().logOrthogonalSmoothing(orthogonal);
        BooleanMatrix binary = this.binarize(smoothed, orthogonal, mask, blocks);
        BooleanMatrix pixelMask = TemplateBuilder.fillBlocks(mask, blocks);
        this.cleanupBinarized(binary, pixelMask);
        FingerprintTransparency.current().logPixelMask(pixelMask);
        BooleanMatrix inverted = TemplateBuilder.invert(binary, pixelMask);
        BooleanMatrix innerMask = this.innerMask(pixelMask);
        Skeleton ridges = new Skeleton(binary, SkeletonType.RIDGES);
        Skeleton valleys = new Skeleton(inverted, SkeletonType.VALLEYS);
        this.collectMinutiae(ridges, MinutiaType.ENDING);
        this.collectMinutiae(valleys, MinutiaType.BIFURCATION);
        FingerprintTransparency.current().logSkeletonMinutiae(this);
        this.maskMinutiae(innerMask);
        this.removeMinutiaClouds();
        this.limitTemplateSize();
        this.shuffleMinutiae();
        this.buildEdgeTable();
    }

    void deserialize(String json) {
        JsonTemplate data = (JsonTemplate)new Gson().fromJson(json, JsonTemplate.class);
        data.validate();
        this.size = data.size();
        this.minutiae = data.minutiae();
        this.buildEdgeTable();
    }

    void convert(ForeignTemplate template, ForeignFingerprint fingerprint) {
        int width = TemplateBuilder.normalizeDpi(fingerprint.dimensions.width, fingerprint.dimensions.dpiX);
        int height = TemplateBuilder.normalizeDpi(fingerprint.dimensions.height, fingerprint.dimensions.dpiY);
        this.size = new IntPoint(width, height);
        ArrayList<ImmutableMinutia> list = new ArrayList<ImmutableMinutia>();
        for (ForeignMinutia minutia : fingerprint.minutiae) {
            int x = TemplateBuilder.normalizeDpi(minutia.x, fingerprint.dimensions.dpiX);
            int y = TemplateBuilder.normalizeDpi(minutia.y, fingerprint.dimensions.dpiY);
            list.add(new ImmutableMinutia(new IntPoint(x, y), minutia.angle, minutia.type.convert()));
        }
        this.minutiae = (ImmutableMinutia[])list.stream().toArray(ImmutableMinutia[]::new);
        this.shuffleMinutiae();
        this.buildEdgeTable();
    }

    private static int normalizeDpi(int value, double dpi) {
        if (Math.abs(dpi - 500.0) > 5.0) {
            return (int)Math.round((double)value / dpi * 500.0);
        }
        return value;
    }

    static DoubleMatrix scaleImage(DoubleMatrix input, double dpi) {
        return TemplateBuilder.scaleImage(input, (int)Math.round(500.0 / dpi * (double)input.width), (int)Math.round(500.0 / dpi * (double)input.height));
    }

    static DoubleMatrix scaleImage(DoubleMatrix input, int newWidth, int newHeight) {
        DoubleMatrix output = new DoubleMatrix(newWidth, newHeight);
        double scaleX = (double)newWidth / (double)input.width;
        double scaleY = (double)newHeight / (double)input.height;
        double descaleX = 1.0 / scaleX;
        double descaleY = 1.0 / scaleY;
        for (int y = 0; y < newHeight; ++y) {
            double y1 = (double)y * descaleY;
            double y2 = y1 + descaleY;
            int y1i = (int)y1;
            int y2i = Math.min((int)Math.ceil(y2), input.height);
            for (int x = 0; x < newWidth; ++x) {
                double x1 = (double)x * descaleX;
                double x2 = x1 + descaleX;
                int x1i = (int)x1;
                int x2i = Math.min((int)Math.ceil(x2), input.width);
                double sum = 0.0;
                for (int oy = y1i; oy < y2i; ++oy) {
                    double ry = Math.min((double)(oy + 1), y2) - Math.max((double)oy, y1);
                    for (int ox = x1i; ox < x2i; ++ox) {
                        double rx = Math.min((double)(ox + 1), x2) - Math.max((double)ox, x1);
                        sum += rx * ry * input.get(ox, oy);
                    }
                }
                output.set(x, y, sum * (scaleX * scaleY));
            }
        }
        return output;
    }

    private HistogramCube histogram(BlockMap blocks, DoubleMatrix image) {
        HistogramCube histogram = new HistogramCube(blocks.primary.blocks, 256);
        for (IntPoint block : blocks.primary.blocks) {
            IntRect area = blocks.primary.block(block);
            for (int y = area.top(); y < area.bottom(); ++y) {
                for (int x = area.left(); x < area.right(); ++x) {
                    int depth = (int)(image.get(x, y) * (double)histogram.depth);
                    histogram.increment(block, histogram.constrain(depth));
                }
            }
        }
        FingerprintTransparency.current().logHistogram(histogram);
        return histogram;
    }

    private HistogramCube smoothHistogram(BlockMap blocks, HistogramCube input) {
        IntPoint[] blocksAround = new IntPoint[]{new IntPoint(0, 0), new IntPoint(-1, 0), new IntPoint(0, -1), new IntPoint(-1, -1)};
        HistogramCube output = new HistogramCube(blocks.secondary.blocks, input.depth);
        for (IntPoint corner : blocks.secondary.blocks) {
            for (IntPoint relative : blocksAround) {
                IntPoint block = corner.plus(relative);
                if (!blocks.primary.blocks.contains(block)) continue;
                for (int i = 0; i < input.depth; ++i) {
                    output.add(corner, i, input.get(block, i));
                }
            }
        }
        FingerprintTransparency.current().logSmoothedHistogram(output);
        return output;
    }

    private BooleanMatrix mask(BlockMap blocks, HistogramCube histogram) {
        DoubleMatrix contrast = this.clipContrast(blocks, histogram);
        BooleanMatrix mask = this.filterAbsoluteContrast(contrast);
        mask.merge(this.filterRelativeContrast(contrast, blocks));
        FingerprintTransparency.current().logCombinedMask(mask);
        mask.merge(this.vote(mask, null, 9, 0.86, 7));
        mask.merge(this.filterBlockErrors(mask));
        mask.invert();
        mask.merge(this.filterBlockErrors(mask));
        mask.merge(this.filterBlockErrors(mask));
        mask.merge(this.vote(mask, null, 7, 0.51, 4));
        FingerprintTransparency.current().logFilteredMask(mask);
        return mask;
    }

    private DoubleMatrix clipContrast(BlockMap blocks, HistogramCube histogram) {
        DoubleMatrix result = new DoubleMatrix(blocks.primary.blocks);
        for (IntPoint block : blocks.primary.blocks) {
            int volume = histogram.sum(block);
            int clipLimit = (int)Math.round((double)volume * 0.08);
            int accumulator = 0;
            int lowerBound = histogram.depth - 1;
            for (int i = 0; i < histogram.depth; ++i) {
                if ((accumulator += histogram.get(block, i)) <= clipLimit) continue;
                lowerBound = i;
                break;
            }
            accumulator = 0;
            int upperBound = 0;
            for (int i = histogram.depth - 1; i >= 0; --i) {
                if ((accumulator += histogram.get(block, i)) <= clipLimit) continue;
                upperBound = i;
                break;
            }
            result.set(block, (double)(upperBound - lowerBound) * (1.0 / (double)(histogram.depth - 1)));
        }
        FingerprintTransparency.current().logClippedContrast(result);
        return result;
    }

    private BooleanMatrix filterAbsoluteContrast(DoubleMatrix contrast) {
        BooleanMatrix result = new BooleanMatrix(contrast.size());
        for (IntPoint block : contrast.size()) {
            if (!(contrast.get(block) < 0.06666666666666667)) continue;
            result.set(block, true);
        }
        FingerprintTransparency.current().logAbsoluteContrastMask(result);
        return result;
    }

    private BooleanMatrix filterRelativeContrast(DoubleMatrix contrast, BlockMap blocks) {
        ArrayList<Double> sortedContrast = new ArrayList<Double>();
        for (IntPoint block : contrast.size()) {
            sortedContrast.add(contrast.get(block));
        }
        sortedContrast.sort(Comparator.naturalOrder().reversed());
        int pixelsPerBlock = blocks.pixels.area() / blocks.primary.blocks.area();
        int sampleCount = Math.min(sortedContrast.size(), 168568 / pixelsPerBlock);
        int consideredBlocks = Math.max((int)Math.round((double)sampleCount * 0.49), 1);
        double averageContrast = sortedContrast.stream().mapToDouble(n -> n).limit(consideredBlocks).average().getAsDouble();
        double limit = averageContrast * 0.34;
        BooleanMatrix result = new BooleanMatrix(blocks.primary.blocks);
        for (IntPoint block : blocks.primary.blocks) {
            if (!(contrast.get(block) < limit)) continue;
            result.set(block, true);
        }
        FingerprintTransparency.current().logRelativeContrastMask(result);
        return result;
    }

    private BooleanMatrix vote(BooleanMatrix input, BooleanMatrix mask, int radius, double majority, int borderDistance) {
        IntPoint size = input.size();
        IntRect rect = new IntRect(borderDistance, borderDistance, size.x - 2 * borderDistance, size.y - 2 * borderDistance);
        int[] thresholds = IntStream.range(0, Integers.sq(2 * radius + 1) + 1).map(i -> (int)Math.ceil(majority * (double)i)).toArray();
        IntMatrix counts = new IntMatrix(size);
        BooleanMatrix output = new BooleanMatrix(size);
        for (int y = rect.top(); y < rect.bottom(); ++y) {
            int superTop = y - radius - 1;
            int superBottom = y + radius;
            int yMin = Math.max(0, y - radius);
            int yMax = Math.min(size.y - 1, y + radius);
            int yRange = yMax - yMin + 1;
            for (int x = rect.left(); x < rect.right(); ++x) {
                int ones;
                if (mask != null && !mask.get(x, y)) continue;
                int left = x > 0 ? counts.get(x - 1, y) : 0;
                int top = y > 0 ? counts.get(x, y - 1) : 0;
                int diagonal = x > 0 && y > 0 ? counts.get(x - 1, y - 1) : 0;
                int xMin = Math.max(0, x - radius);
                int xMax = Math.min(size.x - 1, x + radius);
                if (left > 0 && top > 0 && diagonal > 0) {
                    ones = top + left - diagonal - 1;
                    int superLeft = x - radius - 1;
                    int superRight = x + radius;
                    if (superLeft >= 0 && superTop >= 0 && input.get(superLeft, superTop)) {
                        ++ones;
                    }
                    if (superLeft >= 0 && superBottom < size.y && input.get(superLeft, superBottom)) {
                        --ones;
                    }
                    if (superRight < size.x && superTop >= 0 && input.get(superRight, superTop)) {
                        --ones;
                    }
                    if (superRight < size.x && superBottom < size.y && input.get(superRight, superBottom)) {
                        ++ones;
                    }
                } else {
                    ones = 0;
                    for (int ny = yMin; ny <= yMax; ++ny) {
                        for (int nx = xMin; nx <= xMax; ++nx) {
                            if (!input.get(nx, ny)) continue;
                            ++ones;
                        }
                    }
                }
                counts.set(x, y, ones + 1);
                if (ones < thresholds[yRange * (xMax - xMin + 1)]) continue;
                output.set(x, y, true);
            }
        }
        return output;
    }

    private BooleanMatrix filterBlockErrors(BooleanMatrix input) {
        return this.vote(input, null, 1, 0.7, 4);
    }

    private DoubleMatrix equalize(BlockMap blocks, DoubleMatrix image, HistogramCube histogram, BooleanMatrix blockMask) {
        double rangeMin = -1.0;
        double rangeMax = 1.0;
        double rangeSize = 2.0;
        double widthMax = 0.031171875;
        double widthMin = 0.001953125;
        double[] limitedMin = new double[histogram.depth];
        double[] limitedMax = new double[histogram.depth];
        double[] dequantized = new double[histogram.depth];
        for (int i = 0; i < histogram.depth; ++i) {
            limitedMin[i] = Math.max((double)i * 0.001953125 + -1.0, 1.0 - (double)(histogram.depth - 1 - i) * 0.031171875);
            limitedMax[i] = Math.min((double)i * 0.031171875 + -1.0, 1.0 - (double)(histogram.depth - 1 - i) * 0.001953125);
            dequantized[i] = (double)i / (double)(histogram.depth - 1);
        }
        HashMap<IntPoint, double[]> mappings = new HashMap<IntPoint, double[]>();
        for (IntPoint corner : blocks.secondary.blocks) {
            double[] mapping = new double[histogram.depth];
            mappings.put(corner, mapping);
            if (!blockMask.get(corner, false) && !blockMask.get(corner.x - 1, corner.y, false) && !blockMask.get(corner.x, corner.y - 1, false) && !blockMask.get(corner.x - 1, corner.y - 1, false)) continue;
            double step = 2.0 / (double)histogram.sum(corner);
            double top = -1.0;
            for (int i = 0; i < histogram.depth; ++i) {
                double band = (double)histogram.get(corner, i) * step;
                double equalized = top + dequantized[i] * band;
                top += band;
                if (equalized < limitedMin[i]) {
                    equalized = limitedMin[i];
                }
                if (equalized > limitedMax[i]) {
                    equalized = limitedMax[i];
                }
                mapping[i] = equalized;
            }
        }
        DoubleMatrix result = new DoubleMatrix(blocks.pixels);
        for (IntPoint block : blocks.primary.blocks) {
            IntRect area = blocks.primary.block(block);
            if (blockMask.get(block)) {
                double[] topleft = (double[])mappings.get(block);
                double[] topright = (double[])mappings.get(new IntPoint(block.x + 1, block.y));
                double[] bottomleft = (double[])mappings.get(new IntPoint(block.x, block.y + 1));
                double[] bottomright = (double[])mappings.get(new IntPoint(block.x + 1, block.y + 1));
                for (int y = area.top(); y < area.bottom(); ++y) {
                    for (int x = area.left(); x < area.right(); ++x) {
                        int depth = histogram.constrain((int)(image.get(x, y) * (double)histogram.depth));
                        double rx = ((double)(x - area.x) + 0.5) / (double)area.width;
                        double ry = ((double)(y - area.y) + 0.5) / (double)area.height;
                        result.set(x, y, Doubles.interpolate(bottomleft[depth], bottomright[depth], topleft[depth], topright[depth], rx, ry));
                    }
                }
                continue;
            }
            for (int y = area.top(); y < area.bottom(); ++y) {
                for (int x = area.left(); x < area.right(); ++x) {
                    result.set(x, y, -1.0);
                }
            }
        }
        FingerprintTransparency.current().logEqualizedImage(result);
        return result;
    }

    private DoubleMatrix orientationMap(DoubleMatrix image, BooleanMatrix mask, BlockMap blocks) {
        DoublePointMatrix accumulated = this.pixelwiseOrientation(image, mask, blocks);
        DoublePointMatrix byBlock = this.blockOrientations(accumulated, blocks, mask);
        DoublePointMatrix smooth = this.smoothOrientation(byBlock, mask);
        return TemplateBuilder.orientationAngles(smooth, mask);
    }

    private ConsideredOrientation[][] planOrientations() {
        OrientationRandom random = new OrientationRandom();
        ConsideredOrientation[][] splits = new ConsideredOrientation[50][];
        for (int i = 0; i < 50; ++i) {
            splits[i] = new ConsideredOrientation[20];
            ConsideredOrientation[] orientations = splits[i];
            for (int j = 0; j < 20; ++j) {
                ConsideredOrientation sample = orientations[j] = new ConsideredOrientation();
                do {
                    double angle = random.next() * Math.PI;
                    double distance = Doubles.interpolateExponential(2.0, 6.0, random.next());
                    sample.offset = DoubleAngle.toVector(angle).multiply(distance).round();
                } while (sample.offset.equals(IntPoint.zero) || sample.offset.y < 0 || Arrays.stream(orientations).limit(j).anyMatch(o -> o.offset.equals(sample.offset)));
                sample.orientation = DoubleAngle.toVector(DoubleAngle.add(DoubleAngle.toOrientation(DoubleAngle.atan(sample.offset.toPoint())), Math.PI));
            }
        }
        return splits;
    }

    private DoublePointMatrix pixelwiseOrientation(DoubleMatrix input, BooleanMatrix mask, BlockMap blocks) {
        ConsideredOrientation[][] neighbors = this.planOrientations();
        DoublePointMatrix orientation = new DoublePointMatrix(input.size());
        for (int blockY = 0; blockY < blocks.primary.blocks.y; ++blockY) {
            IntRange maskRange = TemplateBuilder.maskRange(mask, blockY);
            if (maskRange.length() <= 0) continue;
            IntRange validXRange = new IntRange(blocks.primary.block(maskRange.start, blockY).left(), blocks.primary.block(maskRange.end - 1, blockY).right());
            for (int y = blocks.primary.block(0, blockY).top(); y < blocks.primary.block(0, blockY).bottom(); ++y) {
                for (ConsideredOrientation neighbor : neighbors[y % neighbors.length]) {
                    int radius = Math.max(Math.abs(neighbor.offset.x), Math.abs(neighbor.offset.y));
                    if (y - radius < 0 || y + radius >= input.height) continue;
                    IntRange xRange = new IntRange(Math.max(radius, validXRange.start), Math.min(input.width - radius, validXRange.end));
                    for (int x = xRange.start; x < xRange.end; ++x) {
                        double after;
                        double before = input.get(x - neighbor.offset.x, y - neighbor.offset.y);
                        double at = input.get(x, y);
                        double strength = at - Math.max(before, after = input.get(x + neighbor.offset.x, y + neighbor.offset.y));
                        if (!(strength > 0.0)) continue;
                        orientation.add(x, y, neighbor.orientation.multiply(strength));
                    }
                }
            }
        }
        FingerprintTransparency.current().logPixelwiseOrientation(orientation);
        return orientation;
    }

    private static IntRange maskRange(BooleanMatrix mask, int y) {
        int first = -1;
        int last = -1;
        for (int x = 0; x < mask.width; ++x) {
            if (!mask.get(x, y)) continue;
            last = x;
            if (first >= 0) continue;
            first = x;
        }
        if (first >= 0) {
            return new IntRange(first, last + 1);
        }
        return IntRange.zero;
    }

    private DoublePointMatrix blockOrientations(DoublePointMatrix orientation, BlockMap blocks, BooleanMatrix mask) {
        DoublePointMatrix sums = new DoublePointMatrix(blocks.primary.blocks);
        for (IntPoint block : blocks.primary.blocks) {
            if (!mask.get(block)) continue;
            IntRect area = blocks.primary.block(block);
            for (int y = area.top(); y < area.bottom(); ++y) {
                for (int x = area.left(); x < area.right(); ++x) {
                    sums.add(block, orientation.get(x, y));
                }
            }
        }
        FingerprintTransparency.current().logBlockOrientation(sums);
        return sums;
    }

    private DoublePointMatrix smoothOrientation(DoublePointMatrix orientation, BooleanMatrix mask) {
        IntPoint size = mask.size();
        DoublePointMatrix smoothed = new DoublePointMatrix(size);
        for (IntPoint block : size) {
            if (!mask.get(block)) continue;
            IntRect neighbors = IntRect.around(block, 1).intersect(new IntRect(size));
            for (int ny = neighbors.top(); ny < neighbors.bottom(); ++ny) {
                for (int nx = neighbors.left(); nx < neighbors.right(); ++nx) {
                    if (!mask.get(nx, ny)) continue;
                    smoothed.add(block, orientation.get(nx, ny));
                }
            }
        }
        FingerprintTransparency.current().logSmoothedOrientation(smoothed);
        return smoothed;
    }

    private static DoubleMatrix orientationAngles(DoublePointMatrix vectors, BooleanMatrix mask) {
        IntPoint size = mask.size();
        DoubleMatrix angles = new DoubleMatrix(size);
        for (IntPoint block : size) {
            if (!mask.get(block)) continue;
            angles.set(block, DoubleAngle.atan(vectors.get(block)));
        }
        return angles;
    }

    private IntPoint[][] orientedLines(int resolution, int radius, double step) {
        IntPoint[][] result = new IntPoint[resolution][];
        for (int orientationIndex = 0; orientationIndex < resolution; ++orientationIndex) {
            ArrayList<IntPoint> line = new ArrayList<IntPoint>();
            line.add(IntPoint.zero);
            DoublePoint direction = DoubleAngle.toVector(DoubleAngle.fromOrientation(DoubleAngle.bucketCenter(orientationIndex, resolution)));
            for (double r = (double)radius; r >= 0.5; r /= step) {
                IntPoint sample = direction.multiply(r).round();
                if (line.contains(sample)) continue;
                line.add(sample);
                line.add(sample.negate());
            }
            result[orientationIndex] = line.toArray(new IntPoint[line.size()]);
        }
        return result;
    }

    private static DoubleMatrix smoothRidges(DoubleMatrix input, DoubleMatrix orientation, BooleanMatrix mask, BlockMap blocks, double angle, IntPoint[][] lines) {
        DoubleMatrix output = new DoubleMatrix(input.size());
        for (IntPoint block : blocks.primary.blocks) {
            IntPoint[] line;
            if (!mask.get(block)) continue;
            for (IntPoint linePoint : line = lines[DoubleAngle.quantize(DoubleAngle.add(orientation.get(block), angle), lines.length)]) {
                IntRect target = blocks.primary.block(block);
                IntRect source = target.move(linePoint).intersect(new IntRect(blocks.pixels));
                target = source.move(linePoint.negate());
                for (int y = target.top(); y < target.bottom(); ++y) {
                    for (int x = target.left(); x < target.right(); ++x) {
                        output.add(x, y, input.get(x + linePoint.x, y + linePoint.y));
                    }
                }
            }
            IntRect blockArea = blocks.primary.block(block);
            for (int y = blockArea.top(); y < blockArea.bottom(); ++y) {
                for (int x = blockArea.left(); x < blockArea.right(); ++x) {
                    output.multiply(x, y, 1.0 / (double)line.length);
                }
            }
        }
        return output;
    }

    private BooleanMatrix binarize(DoubleMatrix input, DoubleMatrix baseline, BooleanMatrix mask, BlockMap blocks) {
        IntPoint size = input.size();
        BooleanMatrix binarized = new BooleanMatrix(size);
        for (IntPoint block : blocks.primary.blocks) {
            if (!mask.get(block)) continue;
            IntRect rect = blocks.primary.block(block);
            for (int y = rect.top(); y < rect.bottom(); ++y) {
                for (int x = rect.left(); x < rect.right(); ++x) {
                    if (!(input.get(x, y) - baseline.get(x, y) > 0.0)) continue;
                    binarized.set(x, y, true);
                }
            }
        }
        FingerprintTransparency.current().logBinarizedImage(binarized);
        return binarized;
    }

    private void cleanupBinarized(BooleanMatrix binary, BooleanMatrix mask) {
        IntPoint size = binary.size();
        BooleanMatrix inverted = new BooleanMatrix(binary);
        inverted.invert();
        BooleanMatrix islands = this.vote(inverted, mask, 2, 0.61, 17);
        BooleanMatrix holes = this.vote(binary, mask, 2, 0.61, 17);
        for (int y = 0; y < size.y; ++y) {
            for (int x = 0; x < size.x; ++x) {
                binary.set(x, y, binary.get(x, y) && !islands.get(x, y) || holes.get(x, y));
            }
        }
        TemplateBuilder.removeCrosses(binary);
        FingerprintTransparency.current().logFilteredBinarydImage(binary);
    }

    private static void removeCrosses(BooleanMatrix input) {
        IntPoint size = input.size();
        boolean any = true;
        while (any) {
            any = false;
            for (int y = 0; y < size.y - 1; ++y) {
                for (int x = 0; x < size.x - 1; ++x) {
                    if ((!input.get(x, y) || !input.get(x + 1, y + 1) || input.get(x, y + 1) || input.get(x + 1, y)) && (!input.get(x, y + 1) || !input.get(x + 1, y) || input.get(x, y) || input.get(x + 1, y + 1))) continue;
                    input.set(x, y, false);
                    input.set(x, y + 1, false);
                    input.set(x + 1, y, false);
                    input.set(x + 1, y + 1, false);
                    any = true;
                }
            }
        }
    }

    private static BooleanMatrix fillBlocks(BooleanMatrix mask, BlockMap blocks) {
        BooleanMatrix pixelized = new BooleanMatrix(blocks.pixels);
        for (IntPoint block : blocks.primary.blocks) {
            if (!mask.get(block)) continue;
            for (IntPoint pixel : blocks.primary.block(block)) {
                pixelized.set(pixel, true);
            }
        }
        return pixelized;
    }

    private static BooleanMatrix invert(BooleanMatrix binary, BooleanMatrix mask) {
        IntPoint size = binary.size();
        BooleanMatrix inverted = new BooleanMatrix(size);
        for (int y = 0; y < size.y; ++y) {
            for (int x = 0; x < size.x; ++x) {
                inverted.set(x, y, !binary.get(x, y) && mask.get(x, y));
            }
        }
        return inverted;
    }

    private BooleanMatrix innerMask(BooleanMatrix outer) {
        IntPoint size = outer.size();
        BooleanMatrix inner = new BooleanMatrix(size);
        for (int y = 1; y < size.y - 1; ++y) {
            for (int x = 1; x < size.x - 1; ++x) {
                inner.set(x, y, outer.get(x, y));
            }
        }
        inner = TemplateBuilder.shrinkMask(inner, 1);
        int total = 1;
        int step = 1;
        while (total + step <= 14) {
            inner = TemplateBuilder.shrinkMask(inner, step);
            total += step;
            step *= 2;
        }
        if (total < 14) {
            inner = TemplateBuilder.shrinkMask(inner, 14 - total);
        }
        FingerprintTransparency.current().logInnerMask(inner);
        return inner;
    }

    private static BooleanMatrix shrinkMask(BooleanMatrix mask, int amount) {
        IntPoint size = mask.size();
        BooleanMatrix shrunk = new BooleanMatrix(size);
        for (int y = amount; y < size.y - amount; ++y) {
            for (int x = amount; x < size.x - amount; ++x) {
                shrunk.set(x, y, mask.get(x, y - amount) && mask.get(x, y + amount) && mask.get(x - amount, y) && mask.get(x + amount, y));
            }
        }
        return shrunk;
    }

    private void collectMinutiae(Skeleton skeleton, MinutiaType type) {
        this.minutiae = (ImmutableMinutia[])Stream.concat(Arrays.stream((Object[])Optional.ofNullable(this.minutiae).orElse(new ImmutableMinutia[0])), skeleton.minutiae.stream().filter(m -> m.ridges.size() == 1).map(m -> new ImmutableMinutia(m.position, m.ridges.get(0).direction(), type))).toArray(ImmutableMinutia[]::new);
    }

    private void maskMinutiae(BooleanMatrix mask) {
        this.minutiae = (ImmutableMinutia[])Arrays.stream(this.minutiae).filter(minutia -> {
            IntPoint arrow = DoubleAngle.toVector(minutia.direction).multiply(-10.06).round();
            return mask.get(minutia.position.plus(arrow), false);
        }).toArray(ImmutableMinutia[]::new);
        FingerprintTransparency.current().logInnerMinutiae(this);
    }

    private void removeMinutiaClouds() {
        int radiusSq = Integers.sq(20);
        Set removed = Arrays.stream(this.minutiae).filter(minutia -> 4L < Arrays.stream(this.minutiae).filter(neighbor -> neighbor.position.minus(minutia.position).lengthSq() <= radiusSq).count() - 1L).collect(Collectors.toSet());
        this.minutiae = (ImmutableMinutia[])Arrays.stream(this.minutiae).filter(minutia -> !removed.contains(minutia)).toArray(ImmutableMinutia[]::new);
        FingerprintTransparency.current().logRemovedMinutiaClouds(this);
    }

    private void limitTemplateSize() {
        if (this.minutiae.length > 100) {
            this.minutiae = (ImmutableMinutia[])Arrays.stream(this.minutiae).sorted(Comparator.comparingInt(minutia -> Arrays.stream(this.minutiae).mapToInt(neighbor -> minutia.position.minus(neighbor.position).lengthSq()).sorted().skip(5L).findFirst().orElse(Integer.MAX_VALUE)).reversed()).limit(100L).toArray(ImmutableMinutia[]::new);
        }
        FingerprintTransparency.current().logTopMinutiae(this);
    }

    private void shuffleMinutiae() {
        int prime = 0x60000005;
        Arrays.sort(this.minutiae, Comparator.comparingInt(m -> (m.position.x * prime + m.position.y) * prime).thenComparing(m -> m.position.x).thenComparing(m -> m.position.y).thenComparing(m -> m.direction).thenComparing(m -> m.type));
        FingerprintTransparency.current().logShuffledMinutiae(this);
    }

    private void buildEdgeTable() {
        this.edges = new NeighborEdge[this.minutiae.length][];
        ArrayList<NeighborEdge> star = new ArrayList<NeighborEdge>();
        int[] allSqDistances = new int[this.minutiae.length];
        for (int reference = 0; reference < this.edges.length; ++reference) {
            int neighbor;
            IntPoint referencePosition = this.minutiae[reference].position;
            int sqMaxDistance = Integers.sq(490);
            if (this.minutiae.length - 1 > 9) {
                for (neighbor = 0; neighbor < this.minutiae.length; ++neighbor) {
                    allSqDistances[neighbor] = referencePosition.minus(this.minutiae[neighbor].position).lengthSq();
                }
                Arrays.sort(allSqDistances);
                sqMaxDistance = allSqDistances[9];
            }
            for (neighbor = 0; neighbor < this.minutiae.length; ++neighbor) {
                if (neighbor == reference || referencePosition.minus(this.minutiae[neighbor].position).lengthSq() > sqMaxDistance) continue;
                star.add(new NeighborEdge(this.minutiae, reference, neighbor));
            }
            star.sort(Comparator.comparingInt(e -> e.length).thenComparingInt(e -> e.neighbor));
            while (star.size() > 9) {
                star.remove(star.size() - 1);
            }
            this.edges[reference] = star.toArray(new NeighborEdge[star.size()]);
            star.clear();
        }
        FingerprintTransparency.current().logEdgeTable(this.edges);
    }

    private static class OrientationRandom {
        static final int prime = 0x60000005;
        static final int bits = 30;
        static final int mask = 0x3FFFFFFF;
        static final double scaling = 9.313225746154785E-10;
        long state = 536871037L;

        private OrientationRandom() {
        }

        double next() {
            this.state *= 0x60000005L;
            return ((double)(this.state & 0x3FFFFFFFL) + 0.5) * 9.313225746154785E-10;
        }
    }

    private static class ConsideredOrientation {
        IntPoint offset;
        DoublePoint orientation;

        private ConsideredOrientation() {
        }
    }
}

