/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.EdgeShape;
import com.machinezoo.sourceafis.MatchBuffer;
import com.machinezoo.sourceafis.MinutiaPair;
import com.machinezoo.sourceafis.Parameters;

class Score {
    int matchedMinutiae;
    double matchedMinutiaeScore;
    double matchedFractionOfProbeMinutiae;
    double matchedFractionOfCandidateMinutiae;
    double matchedFractionOfAllMinutiaeScore;
    int matchedEdges;
    double matchedEdgesScore;
    int minutiaeWithSeveralEdges;
    double minutiaeWithSeveralEdgesScore;
    int correctMinutiaTypeCount;
    double correctMinutiaTypeScore;
    double accurateEdgeLengthScore;
    double accurateMinutiaAngleScore;
    double totalScore;
    double shapedScore;

    Score() {
    }

    void compute(MatchBuffer match) {
        this.matchedMinutiae = match.count;
        this.matchedMinutiaeScore = 0.032 * (double)this.matchedMinutiae;
        this.matchedFractionOfProbeMinutiae = (double)match.count / (double)match.probe.minutiae.length;
        this.matchedFractionOfCandidateMinutiae = (double)match.count / (double)match.candidate.minutiae.length;
        this.matchedFractionOfAllMinutiaeScore = 8.98 * (this.matchedFractionOfProbeMinutiae + this.matchedFractionOfCandidateMinutiae) / 2.0;
        this.matchedEdges = match.count;
        this.minutiaeWithSeveralEdges = 0;
        this.correctMinutiaTypeCount = 0;
        for (int i = 0; i < match.count; ++i) {
            MinutiaPair pair = match.tree[i];
            this.matchedEdges += pair.supportingEdges;
            if (pair.supportingEdges >= 1) {
                ++this.minutiaeWithSeveralEdges;
            }
            if (match.probe.minutiae[pair.probe].type != match.candidate.minutiae[pair.candidate].type) continue;
            ++this.correctMinutiaTypeCount;
        }
        this.matchedEdgesScore = 0.265 * (double)this.matchedEdges;
        this.minutiaeWithSeveralEdgesScore = 0.193 * (double)this.minutiaeWithSeveralEdges;
        this.correctMinutiaTypeScore = 0.629 * (double)this.correctMinutiaTypeCount;
        int innerDistanceRadius = (int)Math.round(8.969999999999999);
        int innerAngleRadius = (int)Math.round(0.27 * Parameters.maxAngleError);
        int distanceErrorSum = 0;
        int angleErrorSum = 0;
        for (int i = 1; i < match.count; ++i) {
            MinutiaPair pair = match.tree[i];
            EdgeShape probeEdge = new EdgeShape(match.probe.minutiae[pair.probeRef], match.probe.minutiae[pair.probe]);
            EdgeShape candidateEdge = new EdgeShape(match.candidate.minutiae[pair.candidateRef], match.candidate.minutiae[pair.candidate]);
            distanceErrorSum += Math.max(innerDistanceRadius, Math.abs(probeEdge.length - candidateEdge.length));
            angleErrorSum = (int)((double)angleErrorSum + Math.max((double)innerAngleRadius, DoubleAngle.distance(probeEdge.referenceAngle, candidateEdge.referenceAngle)));
            angleErrorSum = (int)((double)angleErrorSum + Math.max((double)innerAngleRadius, DoubleAngle.distance(probeEdge.neighborAngle, candidateEdge.neighborAngle)));
        }
        this.accurateEdgeLengthScore = 0.0;
        this.accurateMinutiaAngleScore = 0.0;
        if (match.count >= 2) {
            double pairedDistanceError = 13 * (match.count - 1);
            this.accurateEdgeLengthScore = 9.9 * (pairedDistanceError - (double)distanceErrorSum) / pairedDistanceError;
            double pairedAngleError = Parameters.maxAngleError * (double)(match.count - 1) * 2.0;
            this.accurateMinutiaAngleScore = 2.79 * (pairedAngleError - (double)angleErrorSum) / pairedAngleError;
        }
        this.totalScore = this.matchedMinutiaeScore + this.matchedFractionOfAllMinutiaeScore + this.minutiaeWithSeveralEdgesScore + this.matchedEdgesScore + this.correctMinutiaTypeScore + this.accurateEdgeLengthScore + this.accurateMinutiaAngleScore;
        this.shapedScore = Score.shape(this.totalScore);
    }

    private static double shape(double raw) {
        if (raw < 8.48) {
            return 0.0;
        }
        if (raw < 11.12) {
            return Score.interpolate(raw, 8.48, 11.12, 0.0, 3.0);
        }
        if (raw < 14.15) {
            return Score.interpolate(raw, 11.12, 14.15, 3.0, 7.0);
        }
        if (raw < 18.22) {
            return Score.interpolate(raw, 14.15, 18.22, 10.0, 10.0);
        }
        if (raw < 22.39) {
            return Score.interpolate(raw, 18.22, 22.39, 20.0, 10.0);
        }
        if (raw < 27.24) {
            return Score.interpolate(raw, 22.39, 27.24, 30.0, 10.0);
        }
        if (raw < 32.01) {
            return Score.interpolate(raw, 27.24, 32.01, 40.0, 10.0);
        }
        return (raw - 32.01) / 13.79 * 30.0 + 50.0;
    }

    private static double interpolate(double raw, double min, double max, double start, double length) {
        return (raw - min) / (max - min) * length + start;
    }
}

