/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.FingerprintCompatibility;
import com.machinezoo.sourceafis.ImmutableMinutia;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.JsonMinutia;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class JsonTemplate {
    String version;
    int width;
    int height;
    List<JsonMinutia> minutiae;

    JsonTemplate() {
    }

    JsonTemplate(IntPoint size, ImmutableMinutia[] minutiae) {
        this.version = FingerprintCompatibility.version();
        this.width = size.x;
        this.height = size.y;
        this.minutiae = Arrays.stream(minutiae).map(JsonMinutia::new).collect(Collectors.toList());
    }

    IntPoint size() {
        return new IntPoint(this.width, this.height);
    }

    ImmutableMinutia[] minutiae() {
        return (ImmutableMinutia[])this.minutiae.stream().map(ImmutableMinutia::new).toArray(ImmutableMinutia[]::new);
    }

    void validate() {
        Objects.requireNonNull(this.minutiae, "Null minutia array.");
        for (JsonMinutia minutia : this.minutiae) {
            Objects.requireNonNull(minutia, "Null minutia.");
            minutia.validate();
        }
    }
}

