/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.ImmutableMinutia;
import com.machinezoo.sourceafis.MinutiaType;
import java.util.Objects;

class JsonMinutia {
    int x;
    int y;
    double direction;
    String type;

    JsonMinutia(ImmutableMinutia minutia) {
        this.x = minutia.position.x;
        this.y = minutia.position.y;
        this.direction = minutia.direction;
        this.type = minutia.type.json;
    }

    void validate() {
        if (Math.abs(this.x) > 10000 || Math.abs(this.y) > 10000) {
            throw new IllegalArgumentException("Minutia position out of range.");
        }
        if (!DoubleAngle.normalized(this.direction)) {
            throw new IllegalArgumentException("Denormalized minutia direction.");
        }
        Objects.requireNonNull(this.type, "Null minutia type.");
        if (!this.type.equals(MinutiaType.ENDING.json) && !this.type.equals(MinutiaType.BIFURCATION.json)) {
            throw new IllegalArgumentException("Unknown minutia type.");
        }
    }
}

