/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.JsonArrayInfo;
import java.nio.ByteBuffer;

class HistogramCube {
    final int width;
    final int height;
    final int depth;
    private final int[] array;

    HistogramCube(int width, int height, int depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.array = new int[width * height * depth];
    }

    HistogramCube(IntPoint size, int depth) {
        this(size.x, size.y, depth);
    }

    int constrain(int z) {
        return Math.max(0, Math.min(this.depth - 1, z));
    }

    int get(int x, int y, int z) {
        return this.array[this.offset(x, y, z)];
    }

    int get(IntPoint at, int z) {
        return this.get(at.x, at.y, z);
    }

    int sum(int x, int y) {
        int sum = 0;
        for (int i = 0; i < this.depth; ++i) {
            sum += this.get(x, y, i);
        }
        return sum;
    }

    int sum(IntPoint at) {
        return this.sum(at.x, at.y);
    }

    void set(int x, int y, int z, int value) {
        this.array[this.offset((int)x, (int)y, (int)z)] = value;
    }

    void set(IntPoint at, int z, int value) {
        this.set(at.x, at.y, z, value);
    }

    void add(int x, int y, int z, int value) {
        int n = this.offset(x, y, z);
        this.array[n] = this.array[n] + value;
    }

    void add(IntPoint at, int z, int value) {
        this.add(at.x, at.y, z, value);
    }

    void increment(int x, int y, int z) {
        this.add(x, y, z, 1);
    }

    void increment(IntPoint at, int z) {
        this.increment(at.x, at.y, z);
    }

    byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(4 * this.array.length);
        buffer.asIntBuffer().put(this.array);
        return buffer.array();
    }

    JsonArrayInfo json() {
        JsonArrayInfo info = new JsonArrayInfo();
        info.axes = new String[]{"y", "x", "bin"};
        info.dimensions = new int[]{this.height, this.width, this.depth};
        info.scalar = "int";
        info.bitness = 32;
        info.endianness = "big";
        info.format = "signed";
        return info;
    }

    private int offset(int x, int y, int z) {
        return (y * this.width + x) * this.depth + z;
    }
}

