/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.google.gson.Gson;
import com.machinezoo.noexception.Exceptions;
import com.machinezoo.sourceafis.FingerprintCompatibility;
import com.machinezoo.sourceafis.FingerprintImage;
import com.machinezoo.sourceafis.FingerprintTransparency;
import com.machinezoo.sourceafis.ImmutableTemplate;
import com.machinezoo.sourceafis.JsonTemplate;
import com.machinezoo.sourceafis.TemplateBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerprintTemplate {
    volatile ImmutableTemplate immutable = ImmutableTemplate.empty;
    private static final Logger logger = LoggerFactory.getLogger(FingerprintCompatibility.class);
    private static final FingerprintTemplate empty = new FingerprintTemplate(ImmutableTemplate.empty);
    private double dpi = 500.0;

    public FingerprintTemplate(FingerprintImage image) {
        Objects.requireNonNull(image);
        Objects.requireNonNull(image.matrix);
        TemplateBuilder builder = new TemplateBuilder();
        builder.extract(image.matrix, image.dpi);
        this.immutable = new ImmutableTemplate(builder);
    }

    public FingerprintTemplate(byte[] serialized) {
        this(serialized, true);
    }

    FingerprintTemplate(byte[] serialized, boolean foreignToo) {
        try {
            Objects.requireNonNull(serialized);
            byte[] decompressed = (byte[])Exceptions.wrap().get(() -> {
                try (GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(serialized));){
                    byte[] byArray = IOUtils.toByteArray((InputStream)gzip);
                    return byArray;
                }
            });
            String json = new String(decompressed, StandardCharsets.UTF_8);
            TemplateBuilder builder = new TemplateBuilder();
            builder.deserialize(json);
            this.immutable = new ImmutableTemplate(builder);
        }
        catch (Throwable ex) {
            try {
                FingerprintTemplate converted = FingerprintCompatibility.convert(serialized);
                this.immutable = converted.immutable;
                logger.warn("Template in foreign format was passed to FingerprintTemplate constructor. It was accepted, but FingerprintCompatibility.convert() should be used instead.");
            }
            catch (Throwable ex2) {
                throw ex;
            }
        }
    }

    @Deprecated
    public FingerprintTemplate() {
    }

    public static FingerprintTemplate empty() {
        return empty;
    }

    FingerprintTemplate(ImmutableTemplate immutable) {
        this.immutable = immutable;
    }

    @Deprecated
    public FingerprintTemplate transparency(FingerprintTransparency transparency) {
        return this;
    }

    @Deprecated
    public FingerprintTemplate dpi(double dpi) {
        this.dpi = dpi;
        return this;
    }

    @Deprecated
    public FingerprintTemplate create(byte[] image) {
        TemplateBuilder builder = new TemplateBuilder();
        builder.extract(new FingerprintImage().decode((byte[])image).matrix, this.dpi);
        this.immutable = new ImmutableTemplate(builder);
        return this;
    }

    @Deprecated
    public FingerprintTemplate deserialize(String json) {
        Objects.requireNonNull(json);
        TemplateBuilder builder = new TemplateBuilder();
        builder.deserialize(json);
        this.immutable = new ImmutableTemplate(builder);
        return this;
    }

    public byte[] toByteArray() {
        ImmutableTemplate current = this.immutable;
        String json = new Gson().toJson((Object)new JsonTemplate(current.size, current.minutiae));
        byte[] uncompressed = json.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Exceptions.sneak().run(() -> {
            try (GZIPOutputStream gzip = new GZIPOutputStream(buffer);){
                gzip.write(uncompressed);
            }
        });
        return buffer.toByteArray();
    }

    @Deprecated
    public String serialize() {
        ImmutableTemplate current = this.immutable;
        return new Gson().toJson((Object)new JsonTemplate(current.size, current.minutiae));
    }

    @Deprecated
    public FingerprintTemplate convert(byte[] template) {
        this.immutable = FingerprintCompatibility.convert((byte[])template).immutable;
        return this;
    }
}

