/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.noexception.Exceptions;
import com.machinezoo.sourceafis.FingerprintTemplate;
import com.machinezoo.sourceafis.ForeignFingerprint;
import com.machinezoo.sourceafis.ForeignFormat;
import com.machinezoo.sourceafis.ForeignTemplate;
import com.machinezoo.sourceafis.ImmutableTemplate;
import com.machinezoo.sourceafis.TemplateBuilder;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerprintCompatibility {
    private static final Logger logger = LoggerFactory.getLogger(FingerprintCompatibility.class);
    private static String version;

    public static String version() {
        return version;
    }

    private FingerprintCompatibility() {
    }

    public static FingerprintTemplate convert(byte[] template) {
        Objects.requireNonNull(template);
        return (FingerprintTemplate)FingerprintCompatibility.convertAll(template).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No fingerprints found in the template"));
    }

    public static List<FingerprintTemplate> convertAll(byte[] template) {
        Objects.requireNonNull(template);
        try {
            ForeignTemplate foreign = ForeignTemplate.read(template);
            return foreign.fingerprints.stream().map(fingerprint -> {
                TemplateBuilder builder = new TemplateBuilder();
                builder.convert(foreign, (ForeignFingerprint)fingerprint);
                return new FingerprintTemplate(new ImmutableTemplate(builder));
            }).collect(Collectors.toList());
        }
        catch (Throwable ex) {
            try {
                List<FingerprintTemplate> deserialized = Arrays.asList(new FingerprintTemplate(template, false));
                logger.warn("Native SourceAFIS template was passed to convert() or convertAll() in FingerprintCompatibility. It was accepted, but FingerprintTemplate constructor should be used instead.");
                return deserialized;
            }
            catch (Throwable ex2) {
                throw ex;
            }
        }
    }

    public static byte[] toAnsiIncits378v2004(FingerprintTemplate ... templates) {
        ForeignTemplate foreign = new ForeignTemplate(templates);
        foreign.format = ForeignFormat.ANSI_378_2004;
        return foreign.write();
    }

    public static byte[] toAnsiIncits378v2009(FingerprintTemplate ... templates) {
        ForeignTemplate foreign = new ForeignTemplate(templates);
        foreign.format = ForeignFormat.ANSI_378_2009;
        return foreign.write();
    }

    public static byte[] toAnsiIncits378v2009AM1(FingerprintTemplate ... templates) {
        ForeignTemplate foreign = new ForeignTemplate(templates);
        foreign.format = ForeignFormat.ANSI_378_2009_AM1;
        return foreign.write();
    }

    static {
        Exceptions.sneak().run(() -> {
            try (InputStream stream = FingerprintCompatibility.class.getResourceAsStream("version.txt");){
                version = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8).trim();
            }
        });
    }
}

