

/*******************************************************************************
20_163R EXCESS MORTALITY DURING COVID-19 PANDEMIC 
*******************************************************************************/
do "J:\EHR-Working\HelenS\Excess_mortality\dofiles\globals.do"



/***** DATA MANAGEMENT FILES ***************************************************/ 
********************************************************************************

/** PATIENT LEVEL DENOMINATOR FILES FOR AGGREGATED DATA ANALYSIS **/
do "$dodir\cr_studypopulation_foraggregate.do" "gold" "primary"
do "$dodir\cr_studypopulation_foraggregate.do" "aurum" "primary"

do "$dodir\cr_studypopulation_foraggregate.do" "aurum" "linked"
do "$dodir\cr_studypopulation_foraggregate.do" "gold" "linked"


/*** CREATE PATIENT LEVEL STATUS FOR EACH CONDITION ***/

/*chronic conditions defined by medical codes only*/
foreach strata in chronic_cardiac cerebrovascular vte chronicresp liver diab_perm ra lupus psoriasis learning neuro dementia {
	do "$dodir\cr_strata_denoms.do" "`strata'"  "gold" "primary" 
	do "$dodir\cr_strata_denoms.do" "`strata'"  "aurum" "primary"
	do "$dodir\cr_strata_denoms.do" "`strata'"  "gold" "linked"
	do "$dodir\cr_strata_denoms.do" "`strata'"  "aurum" "linked"
	}
		
/*time-updating conditions*/
foreach condition in asthma bmi cancer ckd ethnicity ht immuno multimorbidity smoking {
		do "$dodir\cr_strata_denoms_`condition'.do" "gold" "primary"
		do "$dodir\cr_strata_denoms_`condition'.do" "aurum" "primary"

		do "$dodir\cr_strata_denoms_`condition'.do" "gold" "linked"
		do "$dodir\cr_strata_denoms_`condition'.do" "aurum" "linked"
}


/*EXAMPLE FOR BINARY CONDITION: cr_strata_denoms_chronic_cardiac.dta"
							
variable	name	type	format	label			variable label
									
patid		str13	%13s							Unique patient identifier
evdate		float	%dD/N/CY						Date of first record of comorbidity
yob			int		%8.0g							Year of birth
gender		float	%9.0g			genderlab		Sex
startfup		float	%9.0g						Latest of start of follow-up in practice + 1 year,	40th	birthday,	evdate
endfup		float	%9.0g							Earliest of end of follow-up in practice, death
died		float	%9.0g							Date of death
*/





/***** ANALYSIS FILES **********************************************************/ 
********************************************************************************

*WEEKLY COUNTS FOR SMR AND TIME SERIES APPROACH
************************************************
*The following do files run inc_cr_weeklycounts for each set of do files

* Binary conditions
do "$dodir\cr_weeklycounts_binary.do" "gold" "primary"
do "$dodir\cr_weeklycounts_binary.do" "aurum" "primary"

do "$dodir\cr_weeklycounts_binary.do" "gold" "linked" 
do "$dodir\cr_weeklycounts_binary.do" "aurum" "linked"

* Cancer, BMI, smoking 	
do "$dodir\cr_weeklycounts_cancer.do" "gold" "primary"
do "$dodir\cr_weeklycounts_cancer.do" "aurum" "primary"

do "$dodir\cr_weeklycounts_bmi.do" "gold" "primary" 
do "$dodir\cr_weeklycounts_bmi.do" "aurum" "primary" 

do "$dodir\cr_weeklycounts_smoking.do" "gold" "primary"
do "$dodir\cr_weeklycounts_smoking.do" "aurum" "primary"

* Sociodemographic
foreach socio in eth dep urb region eth_london {
	do "$dodir\cr_weeklycounts_demographics_`socio'" "gold" "primary" 
	do "$dodir\cr_weeklycounts_demographics_`socio'" "aurum" "primary"
}




*ANALYSIS
********************************************************************************

do "$dodir\an_adhoc_analyses.do" /*ad hoc analyses to support decision making
including region base category, mixed urban rural, and change in practice size /
age groups over time*/


*TIME SERIES APPROACH
**********************
/*include files needed:
- inc_an_glm_prepare
- inc_an_glm_estimates
- inc_an_timeseries_estimates
- inc_strata_names
*/

*** EXCESS MORTALITY
foreach linkage in primary linked {
	do "$dodir\an_timeseries_estimates_binary.do" "combined" "`linkage'"
	do "$dodir\an_timeseries_estimates_demographics.do" "combined" "`linkage'"
	do "$dodir\an_timeseries_estimates_lifestyle.do" "combined" "`linkage'"
	do "$dodir\an_timeseries_estimates_cancer.do" "combined" "`linkage'"
	do "$dodir\an_timeseries_processout.do" "combined" "`linkage'"
	}

foreach database in gold aurum {
	do "$dodir\an_timeseries_estimates_binary.do" "`database'" "primary"
	do "$dodir\an_timeseries_estimates_demographics.do" "`database'" "primary"
	do "$dodir\an_timeseries_estimates_lifestyle.do" "`database'" "primary"
	do "$dodir\an_timeseries_estimates_cancer.do" "`database'" "primary"
	do "$dodir\an_timeseries_processout.do" "`database'" "primary"
	}


*** IRRs
foreach linkage in primary linked {
	do "$dodir\an_glm_estimates_binary.do" "combined" "`linkage'"
	do "$dodir\an_glm_estimates_demographics.do" "combined" "`linkage'"
	do "$dodir\an_glm_estimates_cancer.do" "combined" "`linkage'"
	do "$dodir\an_glm_estimates_lifestyle.do" "combined" "`linkage'"
	do "$dodir\an_glm_processout.do" "combined" "`linkage'"
}

foreach database in gold aurum {
	do "$dodir\an_glm_estimates_binary.do" "`database'" "primary"
	do "$dodir\an_glm_estimates_demographics.do" "`database'" "primary"
	do "$dodir\an_glm_estimates_cancer.do" "`database'" "primary"
	do "$dodir\an_glm_estimates_lifestyle.do" "`database'" "primary"
	do "$dodir\an_glm_processout.do" "`database'" "primary"
}



*FIGURES AND TABLES 
************************
do "$dodir\an_studypopulation_flowchart.do"

do "$dodir\an_denominatorsovertime.do" "combined" "primary"

do "$dodir\an_table1.do" "combined" "primary" /*from time series analyses*/
do "$dodir\an_table1.do" "combined" "linked"

do "$dodir\an_timeseries_graphs.do" "combined" "primary"
do "$dodir\an_timeseries_graphs_supplementary.do" "combined" "primary"
do "$dodir\an_timeseries_modelfit.do" /*deviance between observed and predicted deaths pre-pandemic*/

do "$dodir\an_glm_graphs" "combined" "primary" "all" /*all = age group, alternatives = young and old*/
do "$dodir\an_glm_graphs_agegroup" /*5 year age groups for supplementary appendix*/

do "$dodir\an_glm_table_supplementary_databases" /*table of glm results for sensitivity analyses*/
do "$dodir\an_glm_table_supplementary_agegps"
do "$dodir\an_glm_table_supplementary_sex"
do "$dodir\an_glm_table_supplementary_linkages" 
do "$dodir\an_glm_table_supplementary_ethnicity" /*ethnicity - london vs elsewhere*/ 
do "$dodir\an_glm_table_supplementary_missing"  
