
** BINARY VARIABLES
*Cardiovascular disease*
if "`strata'" == "chronic_cardiac" 	local strataname = "Chronic heart disease"
if "`strata'" == "cerebrovascular" 	local strataname = "Cerebrovascular disease"
if "`strata'" == "vte" 				local strataname = "Venous thromboembolism"
if "`strata'" == "ht" 	local strataname = "Hypertension"

if "`strata'" == "chronic_cardiac" | "`strata'" == "cerebrovascular" | "`strata'" == "vte"  | "`strata'" == "ht" {
	local groupname = "Cardiovascular disease"
	}

*Respiratory disease*
if "`strata'" == "asthma" 			local strataname = "Asthma"
if "`strata'" == "chronicresp" 		local strataname = "Other"

if "`strata'" == "asthma" | "`strata'" == "chronicresp" {
	local groupname = "Chronic respiratory disease"
	}

*Autoimmune*
if "`strata'" == "ra" 				local strataname = "Rheumatoid arthritis"
if "`strata'" == "lupus" 			local strataname = "Lupus erythematosus"
if "`strata'" == "psoriasis" 		local strataname = "Psoriasis"

if "`strata'" == "ra" | "`strata'" == "lupus" | "`strata'" == "psoriasis" {
	local groupname = "Autoimmune condition"
	}

*Neurological
if "`strata'" == "learning" 		local strataname = "Learning disabilities"
if "`strata'" == "neuro" 			local strataname = "Other associated+"
if "`strata'" == "dementia" 		local strataname = "Dementia"

if "`strata'" == "learning" | "`strata'" == "neuro" | "`strata'" == "dementia" {
	local groupname = "Neurological conditions"
	}


*Other*
if "`strata'" == "liver" 			local strataname = "Chronic liver disease"
if "`strata'" == "ckd" 				local strataname = "Chronic kidney disease"
if "`strata'" == "diab_perm" 		local strataname = "Diabetes"
if "`strata'" == "cancer1yr" 		local strataname = "Cancer (diagnosed in last year)"
if "`strata'" == "immuno"	 		local strataname = "Immunosuppression+" /*HIV and transplant*/
if "`strata'" == "multimorbidity"	local strataname = "Multimorbidity"

if "`strata'" == "liver" | "`strata'" == "ckd" | "`strata'" == "diab_perm" | "`strata'" == "cancer1yr" | "`strata'" == "immuno" | "`strata'" == "multimorbidity" {
	local groupname = "Other comorbidity"
	}

*Cancer

if strmatch("`strata'", "*ever*") == 1 local strataname = "More than 5 years ago"
if strmatch("`strata'", "*1yr*")  == 1 & "`strata'" != "cancer1yr" local strataname = "In last year"
if strmatch("`strata'", "*5yr*") == 1 local strataname = "in the last 1 to 5 years"

if strmatch("`strata'", "haem*") == 1 local groupname = "Haematological cancer"
if strmatch("`strata'", "nonhaem*") == 1 local groupname = "Non-haematological cancer"

if "`strata'" == "cancer3mo" {
	local strataname "In the last 3 months"
	local groupname "Cancer"
	}

if "`strata'" == "cancer3mo1yr" {
	local strataname "3 months to 1 year"
	local groupname "Cancer"
	}

/*DEMOGRAPHICS*/
if "`strata'" == "studypop"		local strataname = "Overall"

*region
if "`strata'" == "region" {
	if `substrata' == 1 	local substrataname = "North East" 
	if `substrata' == 2 	local substrataname = "North West"
	if `substrata' == 3 	local substrataname = "Yorkshire And The Humber"
	if `substrata' == 4 	local substrataname = "East Midlands & East of England"
	if `substrata' == 5 	local substrataname = "West Midlands"
	*if `substrata' == 6 	local substrataname = "East of England"
	if `substrata' == 7 	local substrataname = "South West"
	if `substrata' == 8 	local substrataname = "South Central"
	if `substrata' == 9 	local substrataname = "London"
	if `substrata' == 10	local substrataname = "South East Coast"
	if `substrata' == 11	local substrataname = "Northern Ireland"
	if `substrata' == 12	local substrataname = "Scotland"
	if `substrata' == 13	local substrataname = "Wales"
	local strataname = "Region"
	local groupname = "Demographics"
	}
	
if "`strata'" == "london" {
	if `substrata' == 0 	local substrataname = "Other"
	if `substrata' == 1 	local substrataname = "London"
	local strataname = "Region"
	local groupname = "Demographics"	
	}

*age
if "`strata'" == "agestratum" {
	if `substrata' == 1		local substrataname = "18 to 24"
	if `substrata' == 2 	local substrataname = "25 to 29" 
	if `substrata' == 3 	local substrataname = "30 to 34" 
	if `substrata' == 4 	local substrataname = "35 to 39" 
	if `substrata' == 5 	local substrataname = "40 to 44" 
	if `substrata' == 6 	local substrataname = "45 to 49" 
	if `substrata' == 7 	local substrataname = "50 to 54" 
	if `substrata' == 8 	local substrataname = "55 to 59" 
	if `substrata' == 9 	local substrataname = "60 to 64" 
	if `substrata' == 10 	local substrataname = "65 to 69" 
	if `substrata' == 11 	local substrataname = "70 to 74" 
	if `substrata' == 12 	local substrataname = "75 to 79"
	if `substrata' == 13 	local substrataname = "80 to 84"
	if `substrata' == 14 	local substrataname = "85 to 89"
	if `substrata' == 15 	local substrataname = "90 plus"
	
	if `substrata' == 16 	local substrataname = "40 to 49" 
	if `substrata' == 17 	local substrataname = "50 to 59"
	if `substrata' == 18 	local substrataname = "60 to 69"
	if `substrata' == 19 	local substrataname = "70 to 79"
	if `substrata' == 20 	local substrataname = "80 plus"
	
	local strataname = "Age group"
	local groupname = "Demographics"
	}

if "`strata'" == "agelinear" {
	if `substrata' == 1		local substrataname = "5 year increase in age"
	local strataname = "Age"
	local groupname = "Demographics"
	}


*sex
if "`strata'" == "genderstratum" {
	if `substrata' == 1	local substrataname = "Male"
	if `substrata' == 2	local substrataname = "Female" 
	local strataname = "Sex"
	local groupname = "Demographics"
}

*urban rural
if "`strata'" == "urban_rural" {
	if `substrata' == 1 local substrataname = "Urban"
	if `substrata' == 2 local substrataname = "Rural"
	if `substrata' == 3 local substrataname = "Mixed (Northern Ireland)"
	local strataname = "Urban Rural"
	local groupname = "Demographics"
	}


*deprivation
/*note removed loop because include file doesn't run within in a programme if
the include file includes a loop*/
if "`strata'" == "deprivation" {
	if `substrata' == 1		local substrataname = "1 (least deprived)"
	if `substrata' == 2		local substrataname = "2"
	if `substrata' == 3		local substrataname = "3"
	if `substrata' == 4		local substrataname = "4"
	if `substrata' == 5 	local substrataname = "5 (most deprived)"
	local strataname = "Deprivation index* quintile"
	local groupname = "Demographics"
	}


/*
ethnicity
*/
if "`strata'" == "ethnicity" | "`strata'" == "eth_lon" | "`strata'" == "eth_nonlon" {
	if `substrata' == 0 	local substrataname = "White"
	if `substrata' == 1		local substrataname = "South Asian"
	if `substrata' == 2		local substrataname = "Black"
	if `substrata' == 3		local substrataname = "Other and mixed"
	*if `substrata' == 4		local substrataname = "Mixed"
	if `substrata' == 99	local substrataname = "Missing"
	
	if "`strata'" == "ethnicity" local strataname = "Ethnicity"
	if "`strata'" == "eth_lon" local strataname = "Ethnicity (London)"
	if "`strata'" == "eth_nonlon" local strataname = "Ethnicity (Other UK)"
	local groupname = "Demographics"
	}

/*LIFESTYLE / HEALTH INDICATORS*/
if "`strata'" == "smoking" {
	if `substrata' == 0	local substrataname = "Non-smoker"
	if `substrata' == 1	local substrataname = "Current smoker"
	if `substrata' == 2	local substrataname = "Ex-smoker"
	if `substrata' == 99 local substrataname = "Missing"
	local strataname = "Smoking status"
	local groupname = "Health Indicators"
	}
	
if "`strata'" == "bmi" {
	if `substrata' == 0	local substrataname = "<18.5 (Underweight)"
	if `substrata' == 1	local substrataname = "18.5-<25 (Normal weight)"
	if `substrata' == 2	local substrataname = "25-<30 (Overweight)"
	if `substrata' == 3	local substrataname = "30-<35 (Obesity class I)"
	if `substrata' == 4	local substrataname = ">=35 (Obesity class II plus)"
	*if `substrata' == 5	local substrataname = ">=40 (Obesity class III plus)"
	if `substrata' == 99 local substrataname = "Missing"
	local strataname = "Body Mass Index"
	local groupname = "Health Indicators"
	}


