

/*
locals needed
database = gold or aurum
linkage = primary or linked
group = e.g. binary, bmi
strata = e.g. asthma
*/

/*******************************************************************************
GENERATE WEEKLY COUNTS FOR SMR ANALYSIS
*******************************************************************************/

capture postclose weeklycounts
cap postutil clear
postfile weeklycounts year week agestratum genderstratum deaths denominator using "$datadir/cr_weeklycounts_`group'_`strata'_`database'_`linkage'", replace

qui forvalues year = 2015/2020 {
	noi di as yellow "`strata'"
	noi di as yellow "`year'"
	
	forvalues week = 1/52 {
	
	noi di "." _cont
	
	*noi di "`year' week `week'" 
	
	local startweek = d(1/1/`year') + (7*(`week'-1))
	local endweek = `startweek' + 6
	
	*di %d `startweek' ".." %d `endweek'
 	
	gen byte inweekdenom = startfup<=`startweek' & endfup>=`startweek' /*i.e. counted if any time in week*/
	gen byte inweekdeaths = startfup<=`startweek' & (endfup>=`startweek' & endfup<=`endweek' & died==1) 

	cou if inweekdenom == 1
	local denom = r(N)
	cou if inweekdeaths == 1
	local deaths = r(N)
	
	post weeklycounts (`year') (`week') (99) (99) (`deaths') (`denom')

	gen agethisweek = floor((`startweek' - mdy(7,1,yob))/365.25) if inweekdenom==1
	gen agecatthisweek = agethisweek
	recode agecatthisweek 18/24=1 25/29=2 30/34=3 35/39=4 40/44=5 45/49=6 50/54=7 55/59=8 60/64=9 65/69=10 70/74=11 75/79=12 80/84=13 85/89=14 90/200=15
		
	*Stratified counts
	forvalues agestratum = 1/15{
		forvalues genderstratum = 1/2 {
	
			*noi di "age `agestratum' gender `genderstratum'" 

			cou if inweekdenom & agecatthisweek==`agestratum' & gender==`genderstratum'
			local denom = r(N)
			cou if inweekdeaths & agecatthisweek==`agestratum' & gender==`genderstratum'
			local deaths = r(N)
			
			post weeklycounts (`year') (`week') (`agestratum') (`genderstratum') (`deaths') (`denom')
		
			}
			}
				
	
	drop inweek* age*

	} /*weeks*/
	nois _dots 0
} /*years*/

gen strata = "`strata'"
postclose weeklycounts

/*
use "$datadir/cr_weeklycounts_`group'_`strata'_`database'_`linkage'", clear
label define agecatfulllab 1 "18 to 24" 2 "25 to 29" 3 "30 to 34" 4 "35 to 39" 5 "40 to 44" 6 "45 to 49" 7 "50 to 54" 8 "55 to 59" 9 "60 to 64" 10 "65 to 69" 11 "70 to 74" 12 "75 to 79" 13 "80 to 84" 14 "85 to 89" 15 "90 plus", replace
label values agestratum agecatfulllab
save "$datadir/cr_weeklycounts_`group'_`strata'_`database'_`linkage'", replace
*/

capture log close