
/******************************************************************************
GENERATE SPLINE FOR OBSERVED DATA

/*HS 01/03/2021 - only for study population as convergance not always
	achieved. We are not showing graphs for covariates in the main paper and can calculate observed deaths from
	the true observed values. Need to remove observed curve from supp appendix
	graphs*/
******************************************************************************/

	*Fit a fully flexible curve to the data to give a smooth "observed" line
	*frencurvnk added to J:\EHR Share\ado
	*bspline installed
	*NB extend number of knots if we have more years of data
	
	

	*spline with 42 reference points
	frencurvnk, xvar(weekfrom) power(3) nk(42)  gen(_wkspl)
	macro list myrefpts

	/*create local with all 42 reference points and additional points for 2020
	to account for the curve being more spiky. Ref points must be integers*/

	local refpts = ""
	summ weekfrom if year2020 == 1
	local endweek = `r(max)'

	tokenize "$myrefpts"
		while "`1'" !="" {
			di "`1'"
			local numeric = real("`1'")
			local integer = round(`numeric')
			local refpts = "`refpts' `integer' "
			if `integer' > 261 & `integer' < `endweek' {
				local addint = `integer' + 3
				local refpts "`refpts' `addint' "
				}
			mac shift
			}
		
	di "`refpts'"
	macro drop myrefpts
		
	/*run original frencurv command with specified reference points*/
	frencurv, xvar(weekfrom) power(3) refpts(`refpts')  gen(wkspl)

	drop _wkspl*

	/*fit fully flexible splines to the data*/
	glm deaths wkspl*, family(nb ml) link(log)
	cap drop n_spline
	predict n_spline

