capture log close
log using "$logdir\an_timeseries_estimates_byagesex_`group'_`strata'_`database'_`linkage'.txt", replace text

/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/


*collapse into binary age groups and sex
drop if agestratum==99
drop if agestratum < 5
gen agebin = "old" if agestratum >=11
replace agebin = "young" if agestratum < 11 & agestratum >=5
collapse (sum) deaths denominator, by(year week agebin genderstratum)

tempfile temp
save `temp', replace

forvalues sex = 1/2 {
foreach agebin in old young {
di as yellow "sex: `sex', agebin: `agebin'"


use `temp', clear

keep if agebin == "`agebin'" & genderstratum == `sex'

include "$dodir\inc_an_glm_prepare.do"
include "$dodir\inc_an_timeseries_estimates.do"

save "$estimatedir/an_timeseries_estimates_`group'_`strata'_`agebin'_`sex'_`database'_`linkage'.dta", replace

}
}

