
replace substrata = "1" if substrata == "c" /*agelinear*/
replace group = "binary" if strata == "cancer1yr"
drop if strata == "agestratum"
drop if strata == "region"
drop if substrata == "99"

*use inc_strata_names to get labels
gen keep = 0
gen grouplabel = ""
gen stratalabel = ""
gen substratalabel = ""
local groups = "lifestyle binary demographics"
foreach g of local groups {
    noi di as yellow "`g'"
	replace keep = 1 if group == "`g'"
    levelsof strata if group == "`g'", local(strataaa)
	foreach strata of local strataaa {
	    noi di as yellow "`strata'"
	    levelsof substrata if strata == "`strata'" & group == "`g'", local(substrataaa)
		foreach substrata of local substrataaa {
		    noi di as yellow "`substrata'"
		    qui include "$dodir\inc_strata_names.do"
			replace grouplabel = "`groupname'" if  group == "`g'" & strata == "`strata'" & substrata == "`substrata'"
			replace stratalabel = "`strataname'" if  group == "`g'" & strata == "`strata'" & substrata == "`substrata'"
			replace substratalabel = "`substrataname'" if  group == "`g'" & strata == "`strata'" & substrata == "`substrata'"
		}
}
}

replace substratalabel = stratalabel if group == "binary"
replace stratalabel = grouplabel if group == "binary"
replace grouplabel = "Comorbidity" if group == "binary"

keep if keep == 1
drop keep
replace grouplabel = "DEMOGRAPHICS" if group == "demographics"
replace grouplabel = "HEALTH BEHAVIOURS / INDICATORS" if group == "lifestyle"
replace grouplabel = "MEDICAL CONDITION"  if group == "binary"

drop group strata substrata
*order and add in row gaps
order grouplabel stratalabel substratalabel strataresult`cat1' stratapstring`cat1' covarpanresult`cat1' covarpanpstring`cat1' strataresult`cat2' stratapstring`cat2' covarpanresult`cat2' covarpanpstring`cat2'
replace substratalabel = "1.<18.5 (Underweight)" if substratalabel == "<18.5 (Underweight)"
sort grouplabel stratalabel substratalabel	

by group stratalabel: ingap, gapindicator(gap)

*replace substratalabel = -1 if gap == 1
replace substratalabel = stratalabel if gap == 1
drop gap

by group: ingap, gapindicator(gap)
*replace substrata = -2 if gap == 1
replace substratalabel = grouplabel if gap == 1
drop gap

replace substratalabel = "<18.5 (Underweight)" if substratalabel == "1.<18.5 (Underweight)"
rename substratalabel stratfactor

keep stratfactor strataresult`cat1' covarpanresult`cat1' strataresult`cat2' covarpanresult`cat2' /*decided to drop p-values*/
order stratfactor strataresult`cat1' strataresult`cat2' covarpanresult`cat1' covarpanresult`cat2'
insobs 1, before(1)
replace strataresult`cat1' = "Before Wave 1" in 1
replace covarpanresult`cat1' = "During Wave 1" in 1


label variable stratfactor "Factor"