
/*******************************************************************************
GLM MODELS WITH INTERACTIONS
*******************************************************************************/


*prepare for glm model for old (>=70 and young people 18-<70

include "$dodir\inc_an_glm_prepare.do"
drop if year == 2020 & week > $wave1end
drop if denominator == 0

/*? is there a way to use interaction terms to create age group specific estimates?*/

/*ref categories for strata*/

/*HS added agelinear 18th March 2021*/
if "`strata'" == "agestratum" | "`strata'" == "agelinear"  {
	foreach age in all old young {
		local agegenderterm_`age' = "ib2.gender"
		}
	if "`strata'" == "agestratum" local x = "ib10"
	if "`strata'" == "agelinear" {
		gen agelinear = agestratum 
		local x = "c."
		}
	}			
	else {
		if "`strata'" == "genderstratum" {
			local agegenderterm_all = "ib10.agestr"
			local agegenderterm_old = "ib11.agestr"
			local agegenderterm_young = "ib5.agestr"
			local x = "ib2"
			}
			else {
				local agegenderterm_all = "ib10.agestr ib2.gender"
				local agegenderterm_old = "ib11.agestr ib2.gender"
				local agegenderterm_young = "ib5.agestr ib2.gender"
				local x = "ib1"
				if "`strata'" == "smoking" local x = "ib0"
				if "`strata'" == "ethnicity" local x = "ib0"
				if "`strata'" == "eth_lon" local x = "ib0"
				if "`strata'" == "eth_nonlon" local x = "ib0"
				if "`group'" == "binary" local x = "ib0"
				if "`group'" == "cancer" local x = "ib0"
				if "`strata'" == "region" local x = "ib9" /*London - see an_adhoc_analyses.do*/
				if "`strata'" == "london" local x = "ib0"
				}
	}
				

				
if "`strata'" == "agestratum" local x = "ib10" 

di "glm deaths year_c year_c2 sin* cos* `agegenderterm_all' `x'.`strata'##i.pandemic, family(nb ml) link(log) exposure(denominator) eform base"
glm deaths year_c year_c2 sin* cos* `agegenderterm_all' `x'.`strata'##i.pandemic, family(nb ml) link(log) exposure(denominator) eform base
estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_all_`database'_`linkage'", replace



if "`database'" == "combined" & "`linkage'" == "primary" {


	***************************
	*Model checking (residuals)
	***************************
	
	*if "`strata'" != "agestratum" & "`strata'" != "agelinear" & "`strata'" != "genderstratum" {

		*(b) Generate the deviance residuals and plot vs time
		predict dres, d
		scatter dres week, name(FigA1, replace) 
		
		*don't need to include age and gender in the panel variable
		gen stratadres = `strata'
		if "`strata'" == "agestratum" | "`strata'" == "agelinear" | "`strata'" == "genderstratum" {
			replace stratadres = 1
			}
		
		*(c) Partial autocorrelation function plot (PAF) of the deviance residuals - original model
		egen agegenderstrata = group(agestratum genderstratum stratadres), label /*need to define a panel variable where there is one time series for each value*/
		tsset agegenderstrata weekfrom
		pause
		*can only run the charts for one time series at a time - age = 65-69, sex = male, maximum strata value
		qui summ stratadres
		local value = `r(max)'
		pac dres if agestratum == 10 & genderstratum == 1 & stratadres == `value', title("(a) From original model") name(a2a, replace) 

		pause
		*(d) Include the 1-week lagged residuals in the model, and re-draw the PAF plot

		sort agegenderstrata weekfrom
		gen dresL1=dres[_n-1] if weekfrom !=10
		glm deaths year_c year_c2 sin* cos* `agegenderterm_all' `x'.`strata'##i.pandemic dresL1, family(nb ml) link(log) exposure(denominator) eform base
		estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_all_autocorrelation_`database'_`linkage'", replace
		pause
		
		predict dresV2, d
		pac dresV2 if agestratum == 10 & genderstratum == 1 & stratadres ==`value', title("(b) From model adjusted for residual autocorrelation") name(a2b, replace)
		pause
		graph combine a2a a2b, cols(1) ysize(9) name(`strata', replace) title("`strata'")
		graph save "$resultdir\an_glm_estimates_autocorrelation_`strata'.gph", replace
		
		*}

	***************************
	*By sex
	***************************
	
	if "`strata'" != "genderstratum" {
	
	di "glm deaths year_c year_c2 sin* cos* ib10.agestr `x'.`strata'##i.pandemic if gender == 1, family(nb ml) link(log) exposure(denominator) eform base"
	glm deaths year_c year_c2 sin* cos* ib10.agestr `x'.`strata'##i.pandemic if gender == 1, family(nb ml) link(log) exposure(denominator) eform base
	estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_male_`database'_`linkage'", replace
	
	di "glm deaths year_c year_c2 sin* cos* ib10.agestr `x'.`strata'##i.pandemic if gender == 2, family(nb ml) link(log) exposure(denominator) eform base"
	glm deaths year_c year_c2 sin* cos* ib10.agestr `x'.`strata'##i.pandemic if gender == 2, family(nb ml) link(log) exposure(denominator) eform base
	estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_female_`database'_`linkage'", replace
	}

	***************************
	*Age groups
	***************************
	
	if "`strata'" == "agestratum" local x = "ib11"

	di "glm deaths year_c year_c2 sin* cos* `agegenderterm_old' `x'.`strata'##i.pandemic if agestratum >= 11, family(nb ml) link(log) exposure(denominator) eform base"
	glm deaths year_c year_c2 sin* cos* `agegenderterm_old' `x'.`strata'##i.pandemic if agestratum >= 11, family(nb ml) link(log) exposure(denominator) eform base
	estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_old_`database'_`linkage'", replace 


	if "`strata'" == "agestratum" local x = "ib5" 

	di "glm deaths year_c year_c2 sin* cos* `agegenderterm_young' `x'.`strata'##i.pandemic if agestratum < 11, family(nb ml) link(log) exposure(denominator) eform base"
	glm deaths year_c year_c2 sin* cos* `agegenderterm_young' `x'.`strata'##i.pandemic if agestratum < 11, family(nb ml) link(log) exposure(denominator) eform base
	estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_young_`database'_`linkage'", replace
	

		
}


/*old model
local i = 5 
glm deaths year_c year_c2 sin* cos* ib`i'.agestr ib`i'.agestr#i.`strata' ib2.gender i.`strata'##i.pandemic ib2.gender##i.pandemic ib`i'.agestr##i.pandemic, family(nb ml) link(log) exposure(denominator) eform iterate(100) /*iterate(100) = stop gap. need a better way to decide which models to run*/
estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_all_`database'_`linkage'", replace
/*
