


	if "`strata'" == "studypop" {
		if "`database'" == "combined" {
		use "$datadir/cr_weeklycounts_region_gold_`linkage'", clear
		append using "$datadir/cr_weeklycounts_region_aurum_`linkage'"
		}
		else {
			use "$datadir/cr_weeklycounts_region_`database'_`linkage'", clear
			}
		collapse (sum) denominator, by(year week agestratum genderstratum)
		}
	
	if "`strata'" != "studypop" {

		if "`database'" == "combined" {
			use "$datadir/cr_weeklycounts_`group'_`strata'_gold_`linkage'", clear
			append using "$datadir/cr_weeklycounts_`group'_`strata'_aurum_`linkage'"
			collapse (sum) denominator, by(year week agestratum genderstratum)
			}
		else {
			use "$datadir/cr_weeklycounts_`group'_`strata'_`database'_`linkage'", clear
			}
	}
	
	pause
	
	drop if agestratum == 99
	drop if agestratum < 5
	collapse (sum) denominator, by(week year)
	
	gen year2020 = year==2020
	drop if year == 2014
	local endday = ${studyend_`linkage'} - d(01/01/2020)
	local endweek = floor(`endday'/7)
	di as yellow "end week: `endweek'"
	drop if year==2020 & week > `endweek'
	
	gen weekfromjan2015 = 1
	gsort year week
	replace weekfrom=sum(weekfrom)
	
	gen denommillions = denom/1000000
	
	include "$dodir\inc_strata_names.do"
	if "`strata'" == "chronicresp" local strataname = "Other respiratory disease"
	if "`strata'" == "neuro" local strataname = "Other neurological disease"

	foreach time in start end {
		qui summ weekfrom if year == 2020 & week == ${wave1`time'}
		local wave1`time' = `r(min)'
		}
	
	qui summ denommillions
	local ymax = `r(max)'
	local ymin = `r(min)'

	line denommillions weekfrom, ///
	xline(`wave1start', lp(dash)) /// start of wave 1
	xline(`wave1end', lp(dash)) /// end of wave 1
	xline(25.9, lp(dot) lc(black)) ///
	xline(77.9, lp(dot) lc(black)) ///
	xline(129.9, lp(dot) lc(black)) ///
	xline(181.9, lp(dot) lc(black)) ///
	xline(233.9, lp(dot) lc(black)) ///
	xlabel(none) ///
	yscale(range(`ymin' `ymax')) ///
	ylab(, labsize(small)) ///
	yline(0, lc(black)) /// replaces X axis
	ytitle("Person-weeks in millions", size(small)) ///
	legend(off) ///
	graphregion(color(white)) /// get rid of rubbish grey/blue around graph
	xscale(range(11 270) noline) ///
	xlab(52(52)270, labsize(small)) ///
	xtitle("Week (1 = 1 January 2015)", size(small)) ///
	title("`strataname'", size(small)) ///
	name(`strata', replace)


	