
capture log close
args database linkage
log using "$logdir\cr_weeklycounts_demo_urb_`database'_`linkage'.txt", replace text

/*
args:
database = gold or aurum
linkage = primary or linked
*/

/*******************************************************************************
CREATE DENOMINATOR FILES FOR GENERAL POP FOR EACH DATABASE LINKED AND UNLINKED
= PATIENT LEVEL DATABASE WITH THE FOLLOWING VARIABLES 

patid gender yob startfup endfup died for denominator where startfup and endfup
includes the diagnosis date
*******************************************************************************/




********************************************************************************
* URBAN / RURAL * 
********************************************************************************

use "$datadir\cr_studypopulation_foraggregate_`database'_`linkage'.dta", clear
count

if "`database'"=="aurum" {
	gen pracid_str=substr(patid,-5,5)
	destring pracid_str, gen(pracid)
	drop pracid_str
}

if "`database'"=="gold" {
	gen pracid = mod(patid,1000)
}

merge m:1 pracid using "$rawdatadir\\`database'_linked\\`database'_20_163R_Practice_RuralUrban_set$linkageset.dta" // always linked for this
drop if _merge==2
drop _merge

label define urban_rurallb 1 "Urban" 2 "Rural" 3 "Mixed urban and rural"

foreach urban_rural of numlist 1/3 {

	preserve 
		
		local strata urban_rural
		keep if urban_rural==`urban_rural'
	
		capture postclose weeklycounts
		cap postutil clear
		postfile weeklycounts year week agestratum genderstratum deaths denominator urban_rural using "$datadir/cr_weeklycounts_`strata'`urban_rural'_`database'_`linkage'", replace
					
				qui forvalues year = 2014/2020 {
				forvalues week = 1/52 {
				
						*Counts for all ages and both sexes
						noi di "`year' week `week' urban_rural `urban_rural'"  
						
						local startweek = d(1/1/`year') + (7*(`week'-1))
						local endweek = `startweek' + 6
						
						gen byte inweekdenom = startfup<=`startweek' & endfup>=`startweek' 
						gen byte inweekdeaths = startfup<=`startweek' & (endfup>=`startweek' & endfup<=`endweek' & died==1) 

						cou if inweekdenom == 1
						local denom = r(N)
						cou if inweekdeaths == 1
						local deaths = r(N)
						
						post weeklycounts (`year') (`week') (99) (99) (`deaths') (`denom') (`urban_rural')

						
						
						*Stratified counts by age and sex
						gen agethisweek = floor((`startweek' - mdy(7,1,yob))/365.25) if inweekdenom==1
						gen agecatthisweek = agethisweek
						recode agecatthisweek 18/24=1 25/29=2 30/34=3 35/39=4 40/44=5 45/49=6 50/54=7 55/59=8 60/64=9 65/69=10 70/74=11 75/79=12 80/84=13 85/89=14 90/200=15
										
						forvalues agestratum = 1/15 {
							forvalues genderstratum = 1/2 {
						
								noi di "age `agestratum' gender `genderstratum'  urban_rural `urban_rural'" 

								cou if inweekdenom & agecatthisweek==`agestratum' & gender==`genderstratum'
								local denom = r(N)
								cou if inweekdeaths & agecatthisweek==`agestratum' & gender==`genderstratum'
								local deaths = r(N)
								
								post weeklycounts (`year') (`week') (`agestratum') (`genderstratum') (`deaths') (`denom') (`urban_rural')
								}
								}		
			drop inweek* age*
			} /*weeks*/
			} /*years*/
				
				
		gen strata = "`strata' `urban_rural'"
		postclose weeklycounts
		
		use "$datadir/cr_weeklycounts_`strata'`urban_rural'_`database'_`linkage'", clear
		label values urban_rural urban_rurallb
		save "$datadir/cr_weeklycounts_`strata'`urban_rural'_`database'_`linkage'", replace

	restore
} /*region*/


foreach database in `database' {
	foreach linkage in `linkage' {
		use "$datadir/cr_weeklycounts_urban_rural1_`database'_`linkage'", replace
		append using "$datadir/cr_weeklycounts_urban_rural2_`database'_`linkage'"
		append using "$datadir/cr_weeklycounts_urban_rural3_`database'_`linkage'"
		label values agestratum agecatfulllab
		save "$datadir/cr_weeklycounts_urban_rural_`database'_`linkage'", replace
	}
}

log close
