capture log close
args database linkage
log using "$logdir\cr_weeklycounts_demo_region_`database'_`linkage'.txt", replace text

/*
args:
database = gold or aurum
linkage = primary or linked
*/

/*******************************************************************************
CREATE DENOMINATOR FILES FOR GENERAL POP FOR EACH DATABASE LINKED AND UNLINKED
= PATIENT LEVEL DATABASE WITH THE FOLLOWING VARIABLES 

patid gender yob startfup endfup died for denominator where startfup and endfup
includes the diagnosis date
*******************************************************************************/



********************************************************************************
* REGION * 
********************************************************************************

use "$datadir\cr_studypopulation_foraggregate_`database'_`linkage'.dta", clear
count

tab region, m
drop if region==.

label define regionlb 	///
	1   "North East" 	///
	2   "North West" 	///
	3	"Yorkshire And The Humber" ///
	4	"East Midlands" ///
	5	"West Midlands" ///
	6	"East of England" ///
	7	"South West" 	///
	8	"South Central" ///
	9	"London" 		///
	10	"South East Coast" ///
	11	"Northern Ireland" ///
	12	"Scotland" 		///
	13	"Wales"
label values region regionlb
	

foreach region of numlist 1/13 {
	
	preserve 
		
		local strata region
		keep if region==`region'
	
		capture postclose weeklycounts
		cap postutil clear
		postfile weeklycounts year week agestratum genderstratum deaths denominator region using "$datadir/cr_weeklycounts_`strata'`region'_`database'_`linkage'", replace
					
				qui forvalues year = 2014/2020 {
				forvalues week = 1/52 {
				
						*Counts for all ages and both sexes
						noi di "`year' week `week' region `region'"  
						
						local startweek = d(1/1/`year') + (7*(`week'-1))
						local endweek = `startweek' + 6
						
						gen byte inweekdenom = startfup<=`startweek' & endfup>=`startweek' 
						gen byte inweekdeaths = startfup<=`startweek' & (endfup>=`startweek' & endfup<=`endweek' & died==1) 

						cou if inweekdenom == 1
						local denom = r(N)
						cou if inweekdeaths == 1
						local deaths = r(N)
						
						post weeklycounts (`year') (`week') (99) (99) (`deaths') (`denom') (`region')

						
						
						*Stratified counts by age and sex
						gen agethisweek = floor((`startweek' - mdy(7,1,yob))/365.25) if inweekdenom==1
						gen agecatthisweek = agethisweek
						recode agecatthisweek 18/24=1 25/29=2 30/34=3 35/39=4 40/44=5 45/49=6 50/54=7 55/59=8 60/64=9 65/69=10 70/74=11 75/79=12 80/84=13 85/89=14 90/200=15
										
						forvalues agestratum = 1/15 {
							forvalues genderstratum = 1/2 {
						
								noi di "age `agestratum' gender `genderstratum'  region `region'" 

								cou if inweekdenom & agecatthisweek==`agestratum' & gender==`genderstratum'
								local denom = r(N)
								cou if inweekdeaths & agecatthisweek==`agestratum' & gender==`genderstratum'
								local deaths = r(N)
								
								post weeklycounts (`year') (`week') (`agestratum') (`genderstratum') (`deaths') (`denom') (`region')
								}
								}		
			drop inweek* age*
			} /*weeks*/
			} /*years*/
			
			
				
				
		gen strata = "`strata' `region'"
		postclose weeklycounts
		
		use "$datadir/cr_weeklycounts_`strata'`region'_`database'_`linkage'", clear
		label values region regionlb
		save "$datadir/cr_weeklycounts_`strata'`region'_`database'_`linkage'", replace

	restore
} /*region*/


*foreach database in `database' {
	*foreach linkage in primary {
		use "$datadir/cr_weeklycounts_region1_`database'_`linkage'", replace
		foreach region of numlist 2/13 {
		append using "$datadir/cr_weeklycounts_region`region'_`database'_`linkage'"
		}
		/*HS added agecatlabel 10/12/2020*/
		label define agecatfulllab 1 "18 to 24" 2 "25 to 29" 3 "30 to 34" 4 "35 to 39" 5 "40 to 44" 6 "45 to 49" 7 "50 to 54" 8 "55 to 59" 9 "60 to 64" 10 "65 to 69" 11 "70 to 74" 12 "75 to 79" 13 "80 to 84" 14 "85 to 89" 15 "90 plus"
		label values agestratum agecatfulllab
		save "$datadir/cr_weeklycounts_region_`database'_`linkage'", replace
	*}
*}

log close




