capture log close
args database linkage
log using "$logdir\cr_weeklycounts_demo_eth_london_`database'_`linkage'.txt", replace text

/*
args:
database = gold or aurum
linkage = primary or linked
*/

/*******************************************************************************
CREATE DENOMINATOR FILES FOR GENERAL POP FOR EACH DATABASE LINKED AND UNLINKED
= PATIENT LEVEL DATABASE WITH THE FOLLOWING VARIABLES 

patid gender yob startfup endfup died for denominator where startfup and endfup
includes the diagnosis date
*******************************************************************************/




**********************************************************************************
* ETHNICITY
**********************************************************************************

use "$datadir\cr_studypopulation_foraggregate_`database'_`linkage'.dta", clear
count

merge 1:1 patid using "$datadir//cr_strata_denoms_ethnicity_`database'_`linkage'.dta"
drop if _merge==2
drop _merge

recode eth5 .=99

gen london = 0
replace london = 1 if region == 9

forvalues lon = 0/1 {
foreach eth5 in 0 1 2 3 4 99 {

	preserve 
		
		if `lon' == 1 local strata = "eth_lon"
		if `lon' == 0 local strata = "eth_nonlon"
		keep if eth5==`eth5' & london == `lon'
		
		di "london: `lon'"
		di "eth5: `eth5'"
		di "strata: `strata'"
	
		capture postclose weeklycounts
		cap postutil clear
		postfile weeklycounts year week agestratum genderstratum deaths denominator ethnicity using "$datadir/cr_weeklycounts_`strata'`eth5'_`database'_`linkage'", replace
					
				qui forvalues year = 2015/2020 {
				forvalues week = 1/52 {
				
						*Counts for all ages and both sexes
						noi di "`year' week `week' ethnicity `eth5'"  
						
						local startweek = d(1/1/`year') + (7*(`week'-1))
						local endweek = `startweek' + 6
						
						gen byte inweekdenom = startfup<=`startweek' & endfup>=`startweek' 
						gen byte inweekdeaths = startfup<=`startweek' & (endfup>=`startweek' & endfup<=`endweek' & died==1) 

						cou if inweekdenom == 1
						local denom = r(N)
						cou if inweekdeaths == 1
						local deaths = r(N)
						
						post weeklycounts (`year') (`week') (99) (99) (`deaths') (`denom') (`eth5')

						
						
						*Stratified counts by age and sex
						gen agethisweek = floor((`startweek' - mdy(7,1,yob))/365.25) if inweekdenom==1
						gen agecatthisweek = agethisweek
						recode agecatthisweek 18/24=1 25/29=2 30/34=3 35/39=4 40/44=5 45/49=6 50/54=7 55/59=8 60/64=9 65/69=10 70/74=11 75/79=12 80/84=13 85/89=14 90/200=15
										
						forvalues agestratum = 1/15 {
							forvalues genderstratum = 1/2 {
						
								noi di "age `agestratum' gender `genderstratum'  ethnicity `eth5'" 

								cou if inweekdenom & agecatthisweek==`agestratum' & gender==`genderstratum'
								local denom = r(N)
								cou if inweekdeaths & agecatthisweek==`agestratum' & gender==`genderstratum'
								local deaths = r(N)
								
								post weeklycounts (`year') (`week') (`agestratum') (`genderstratum') (`deaths') (`denom') (`eth5')
								}
								}		
			drop inweek* age*
			} /*weeks*/
			} /*years*/
				
				
		*gen strata = "`strata' `eth5'"
		postclose weeklycounts
		
		use "$datadir/cr_weeklycounts_`strata'`eth5'_`database'_`linkage'", clear
		save "$datadir/cr_weeklycounts_`strata'`eth5'_`database'_`linkage'", replace

	restore
} /*ethnicity*/
} /*london*/

foreach strata in eth_lon eth_nonlon {
foreach database in `database' {
	foreach linkage in `linkage' {
		use "$datadir/cr_weeklycounts_`strata'0_`database'_`linkage'", clear
		append using "$datadir/cr_weeklycounts_`strata'1_`database'_`linkage'"
		append using "$datadir/cr_weeklycounts_`strata'2_`database'_`linkage'"
		append using "$datadir/cr_weeklycounts_`strata'3_`database'_`linkage'"
		append using "$datadir/cr_weeklycounts_`strata'4_`database'_`linkage'"
		append using "$datadir/cr_weeklycounts_`strata'99_`database'_`linkage'"			
		label values agestratum agecatfulllab
		save "$datadir/cr_weeklycounts_`strata'_`database'_`linkage'", replace
	}
}
}


capture log close