
capture log close
args database linkage
log using "$logdir\cr_weeklycounts_demo_dep_`database'_`linkage'.txt", replace text

/*
args:
database = gold or aurum
linkage = primary or linked
*/

/*******************************************************************************
CREATE DENOMINATOR FILES FOR GENERAL POP FOR EACH DATABASE LINKED AND UNLINKED
= PATIENT LEVEL DATABASE WITH THE FOLLOWING VARIABLES 

patid gender yob startfup endfup died for denominator where startfup and endfup
includes the diagnosis date
*******************************************************************************/

********************************************************************************
* CARSTAIRS DEPRIVATION * 
********************************************************************************

use "$datadir\cr_studypopulation_foraggregate_`database'_`linkage'.dta", clear
count

if "`database'"=="aurum" {
	gen pracid_str=substr(patid,-5,5)
	destring pracid_str, gen(pracid)
	drop pracid_str
}

if "`database'"=="gold" {
gen pracid = mod(patid,1000)
}

merge m:1 pracid using "$rawdatadir\\`database'_linked\\`database'_20_163R_Practice_Carstairs_set$linkageset.dta" // always linked for this
drop if _merge==2
drop _merge


foreach quintile of numlist 1/5 {

	preserve 
		
		local strata deprivation
		keep if carstairs2011_5==`quintile'
	
		capture postclose weeklycounts
		cap postutil clear
		postfile weeklycounts year week agestratum genderstratum deaths denominator deprivation using "$datadir/cr_weeklycounts_`strata'`quintile'_`database'_`linkage'", replace
					
				qui forvalues year = 2014/2020 {
				forvalues week = 1/52 {
				
						*Counts for all ages and both sexes
						noi di "`year' week `week' deprivation `quintile'"  
						
						local startweek = d(1/1/`year') + (7*(`week'-1))
						local endweek = `startweek' + 6
						
						gen byte inweekdenom = startfup<=`startweek' & endfup>=`startweek' 
						gen byte inweekdeaths = startfup<=`startweek' & (endfup>=`startweek' & endfup<=`endweek' & died==1) 

						cou if inweekdenom == 1
						local denom = r(N)
						cou if inweekdeaths == 1
						local deaths = r(N)
						
						post weeklycounts (`year') (`week') (99) (99) (`deaths') (`denom') (`quintile')

						
						
						*Stratified counts by age and sex
						gen agethisweek = floor((`startweek' - mdy(7,1,yob))/365.25) if inweekdenom==1
						gen agecatthisweek = agethisweek
						recode agecatthisweek 18/24=1 25/29=2 30/34=3 35/39=4 40/44=5 45/49=6 50/54=7 55/59=8 60/64=9 65/69=10 70/74=11 75/79=12 80/84=13 85/89=14 90/200=15
										
						forvalues agestratum = 1/15 {
							forvalues genderstratum = 1/2 {
						
								noi di "age `agestratum' gender `genderstratum'  deprivation `quintile'" 

								cou if inweekdenom & agecatthisweek==`agestratum' & gender==`genderstratum'
								local denom = r(N)
								cou if inweekdeaths & agecatthisweek==`agestratum' & gender==`genderstratum'
								local deaths = r(N)
								
								post weeklycounts (`year') (`week') (`agestratum') (`genderstratum') (`deaths') (`denom') (`quintile')
								}
								}		
			drop inweek* age*
			} /*weeks*/
			} /*years*/
				
				
		gen strata = "`strata' `quintile'"
		postclose weeklycounts
		
		use "$datadir/cr_weeklycounts_`strata'`quintile'_`database'_`linkage'", clear
		save "$datadir/cr_weeklycounts_`strata'`quintile'_`database'_`linkage'", replace

	restore
} /*dep*/


foreach database in `database' {
	foreach linkage in `linkage' {
		use "$datadir/cr_weeklycounts_deprivation1_`database'_`linkage'", replace
		append using "$datadir/cr_weeklycounts_deprivation2_`database'_`linkage'"
		append using "$datadir/cr_weeklycounts_deprivation3_`database'_`linkage'"
		append using "$datadir/cr_weeklycounts_deprivation4_`database'_`linkage'"
		append using "$datadir/cr_weeklycounts_deprivation5_`database'_`linkage'"		
		label values agestratum agecatfulllab
		save "$datadir/cr_weeklycounts_deprivation_`database'_`linkage'", replace
	}
}

