capture log close
set more off
args database linkage
log using "$logdir\cr_weeklycounts_cancer_`database'_`linkage'.txt", replace text


/*
args:
database = gold or aurum
linkage = primary or linked
*/

/*******************************************************************************
GENERATE WEEKLY COUNTS FOR SMR ANALYSIS - ALL CANCER STRATA

PRIMARY ANALYSIS = DIAGNOSED WITH CANCER IN THE LAST YEAR (ALL CANCERS)

SECONDARY ANALYSIS = HAEM/NON-HAEM, DIAGNOSED IN LAST 5 YEARS, DIAGNOSED EVER

CAN ALSO LOOK AT INDIVIDUAL CANCER SITES
*******************************************************************************/


*MAIN ANALYSIS
use "$datadir\cr_strata_denoms_cancer_`database'_`linkage'.dta", clear
rename endfupever endfup
replace died = 0 if endfup > (evdate + 365.25) /*hs added 18March2021*/
replace endfup = min(endfup, (evdate + 365.25))
drop if endfup <= startfup /*hs added 18March2021*/
format endfup startfup evdate %td

local group = "cancer"
local strata = "cancer1yr"
keep patid gender yob startfup endfup died
distinct patid
include "$dodir\inc_cr_weeklycounts.do"


*SECONDARY ANALYSES

*<3 months
use "$datadir\cr_strata_denoms_cancer_`database'_`linkage'.dta", clear
rename endfupever endfup
replace died = 0 if endfup > (evdate + 90) /*hs added 18March2021*/
replace endfup = min(endfup, (evdate + 90))
drop if endfup <= startfup /*hs added 18March2021*/
format endfup startfup evdate %td

local group = "cancer"
local strata = "cancer3mo"
keep patid gender yob startfup endfup died
distinct patid
include "$dodir\inc_cr_weeklycounts.do"

*3 months to 1 year
use "$datadir\cr_strata_denoms_cancer_`database'_`linkage'.dta", clear
replace startfup = max(startfup, (evdate + 90))
rename endfupever endfup
replace died = 0 if endfup > (evdate + 365.25) /*hs added 18March2021*/
replace endfup = min(endfup, (evdate + 365.25))
drop if endfup <= startfup /*hs added 18March2021*/
format endfup startfup evdate %td

local group = "cancer"
local strata = "cancer3mo1yr"
keep patid gender yob startfup endfup died
distinct patid
include "$dodir\inc_cr_weeklycounts.do"


*< 1 year
use "$datadir\cr_strata_denoms_cancer_`database'_`linkage'.dta", clear
rename endfupever endfup
replace died = 0 if endfup > (evdate + 365.25) /*hs added 18March2021*/
replace endfup = min(endfup, (evdate + 365.25))
keep if haem == 1
drop if endfup <= startfup /*hs added 18March2021*/
format endfup startfup evdate %td

local group = "cancer"
local strata = "haem1yr"
keep patid gender yob startfup endfup died
distinct patid
include "$dodir\inc_cr_weeklycounts.do"

use "$datadir\cr_strata_denoms_cancer_`database'_`linkage'.dta", clear
rename endfupever endfup
replace died = 0 if endfup > (evdate + 365.25) /*hs added 18March2021*/
replace endfup = min(endfup, (evdate + 365.25))
keep if haem == 0

drop if endfup <= startfup /*hs added 18March2021*/
format endfup startfup evdate %td
local group = "cancer"
local strata = "nonhaem1yr"
keep patid gender yob startfup endfup died
distinct patid
include "$dodir\inc_cr_weeklycounts.do"

*1 to <5 years
use "$datadir\cr_strata_denoms_cancer_`database'_`linkage'.dta", clear
rename endfupever endfup
replace died = 0 if endfup > (evdate + (5*365.25)) /*hs added 18March2021*/
replace endfup = min(endfup, (evdate + (5*365.25)))
replace startfup = max(startfup, (evdate + 365))
keep if haem == 1
drop if endfup <= startfup /*hs added 18March2021*/
format endfup startfup evdate %td

local group = "cancer"
local strata = "haem5yr"
keep patid gender yob startfup endfup died
distinct patid
include "$dodir\inc_cr_weeklycounts.do"

use "$datadir\cr_strata_denoms_cancer_`database'_`linkage'.dta", clear
rename endfupever endfup
replace died = 0 if endfup > (evdate + (5*365.25)) /*hs added 8April2021*/
replace endfup = min(endfup, (evdate + (5*365.25)))
replace startfup = max(startfup, (evdate + 365))
keep if haem == 0
drop if endfup <= startfup /*hs added 18March2021*/
format endfup startfup evdate %td

local group = "cancer"
local strata = "nonhaem5yr"
keep patid gender yob startfup endfup died
distinct patid
include "$dodir\inc_cr_weeklycounts.do"

*>=5 years
use "$datadir\cr_strata_denoms_cancer_`database'_`linkage'.dta", clear
rename endfupever endfup
replace startfup = max(startfup, (evdate + (5*365.25)))
keep if haem == 1
drop if endfup <= startfup /*hs added 18March2021*/
format endfup startfup evdate %td

local group = "cancer"
local strata = "haemever"
keep patid gender yob startfup endfup died
distinct patid
include "$dodir\inc_cr_weeklycounts.do"


use "$datadir\cr_strata_denoms_cancer_`database'_`linkage'.dta", clear
rename endfupever endfup
replace startfup = max(startfup, (evdate + (5*365.25)))
keep if haem == 0
drop if endfup <= startfup /*hs added 18March2021*/
format endfup startfup evdate %td

local group = "cancer"
local strata = "nonhaemever"
keep patid gender yob startfup endfup died
distinct patid
include "$dodir\inc_cr_weeklycounts.do"




capture log close