capture log close
set more off
args database linkage
log using "$logdir\cr_weeklycounts_`database'_`linkage'.txt", replace text


/*
args:
database = gold or aurum
linkage = primary or linked
group = e.g. bin
strata = e.g. asthma
*/

/*******************************************************************************
GENERATE WEEKLY COUNTS FOR SMR ANALYSIS FOR BINARY VARIABLES
*******************************************************************************/

foreach strata in ht immuno chronic_cardiac cerebrovascular vte chronicresp ra lupus psoriasis neuro dementia ckd liver diab_perm learning multimorbidity asthma   {
	di as yellow "`strata'"
	di as yellow "`database `linkage''"
	use "$datadir\cr_strata_denoms_`strata'_`database'_`linkage'.dta", clear
	local group = "binary"
	include "$dodir\inc_cr_weeklycounts.do"
	}

capture log close
