capture log close
args database linkage 
log using "$logdir\cr_strata_denoms_smoking_`database'_`linkage'.txt", replace text

/*
args:
database = gold or aurum
linkage = primary or linked
*/

/*******************************************************************************
CREATE DENOMINATOR FILES FOR BMI CATEGORY FOR EACH DATABASE LINKED AND
UNLINKED
= PATIENT LEVEL DATABASE WITH THE FOLLOWING VARIABLES 
patid gender yob startfup endfup died for denominator where startfup and endfup
includes the diagnosis date
*******************************************************************************/

foreach n in 0 1 2 99 {
	use "$datadir\\cr_smoking_long_`database'_`linkage'", clear
	
	keep if smokstatus == `n'
	
	merge m:1 patid using "$datadir\cr_studypopulation_foraggregate_`database'_`linkage'.dta", keep(match) nogen
		
	foreach v in startfup endfup end start dob {
		format `v' %td
		}
		
	* all records of patients who died are flagged after merging; rever to only the last record (as it is when follow up ends)
	replace died=0 if died==1 & end!=endfup
	
	* patient fupt starts at fupt data for the first record
	replace start=startfup if startfup>start

keep patid gender yob died smokstatus start end
rename start startfup
rename end endfup
save "$datadir\\cr_strata_denoms_smoking`n'_`database'_`linkage'.dta", replace
}		

				
* join all smoking categories	
use "$datadir\\cr_strata_denoms_smoking0_`database'_`linkage'.dta", clear
foreach n in 1 2 99 {
	append using "$datadir\\cr_strata_denoms_smoking`n'_`database'_`linkage'.dta"
	}
save "$datadir\\cr_strata_denoms_smoking_`database'_`linkage'.dta", replace


* erase intermediate files
foreach n in 0 1 2 99 {
	erase "$datadir\\cr_strata_denoms_smoking`n'_`database'_`linkage'.dta"
	}


capture log close