

capture log close
args database linkage 
log using "$logdir\cr_strata_denoms_immuno_`database'_`linkage'.txt", replace text
**********************************************************************************

cap erase "$datadir\cr_strata_denoms_immuno_`database'_`linkage'.dta"

	use "$datadir\cr_getallimmuno_`database'.dta", clear
	count
			
	if "`linkage'" == "linked" {
		append using "$rawdatadir\\`database'_linked\\hes_diagnosis_epi_20_163R.dta"
		drop immuno 
		
		gen immuno=0
		replace immuno=1 if organ_tx==1
		replace immuno=1 if HIV==1
		replace immuno=1 if cmi_perm==1
		replace immuno=1 if stem_cell==1	
		
		keep if immuno == 1
		keep patid evdate immuno

		*drop if any records without event date
		bysort patid (evdate): egen maxevdate = max(evdate)
		format maxevdate %dD/N/CY
		drop if maxevdate == .
		drop maxevdate

		bysort patid (evdate): keep if _n == 1
		}		
		
		
	merge 1:1 patid using "$datadir\cr_studypopulation_foraggregate_`database'_`linkage'.dta"
	keep if _merge == 3
	
	replace startfup = max(evdate, startfup)
	drop if startfup >= endfup
	format startfup %td
	format endfup %td
	keep patid gender yob startfup endfup died immuno

	distinct patid
		
save "$datadir\cr_strata_denoms_immuno_`database'_`linkage'.dta", replace

********************************************************************************
capture log close