capture log close
args database linkage 
log using "$logdir\cr_strata_denoms_bmi_`database'_`linkage'.txt", replace text

/*
args:
database = gold or aurum
linkage = primary or linked
*/

/*******************************************************************************
CREATE DENOMINATOR FILES FOR BMI CATEGORY FOR EACH DATABASE LINKED AND
UNLINKED
= PATIENT LEVEL DATABASE WITH THE FOLLOWING VARIABLES 
patid gender yob startfup endfup died for denominator where startfup and endfup
includes the diagnosis date
*******************************************************************************/

foreach n in 99 0 1 2 3 4 5 {
	use "$datadir\\cr_bmi_long_`database'", clear
	keep if bmicat == `n'
					
	merge m:1 patid using "$datadir\cr_studypopulation_foraggregate_`database'_`linkage'.dta", keep(match) keepusing(died yob startfup endfup gender) nogen
		
	foreach v in startfup endfup end start {
		format `v' %td
		}
		
	* all records of patients who died are flagged after merging; revert to only the last record (as it is when follow up ends)
	replace end = min(end, endfup) /*HS added 19th March 2021*/
	replace died=0 if died==1 & end!=endfup
	
	* drop records prior to follow up 
	replace start=max(start,startfup)
	drop if end < start

*save 
keep patid gender yob died bmicat start end
rename start startfup
rename end endfup
save "$datadir\\cr_strata_denoms_bmi`n'_`database'_`linkage'.dta", replace
}		


				
*	Join all BMI cats	
use "$datadir\\cr_strata_denoms_bmi99_`database'_`linkage'.dta", clear
	foreach n of numlist 0/5 {
	append using "$datadir\\cr_strata_denoms_bmi`n'_`database'_`linkage'.dta"
	}
save "$datadir\\cr_strata_denoms_bmi_`database'_`linkage'.dta", replace



* erase intermediate files
foreach n of numlist 0/5 {
	erase "$datadir\\cr_strata_denoms_bmi`n'_`database'_`linkage'.dta"
	}
erase "$datadir\\cr_strata_denoms_bmi99_`database'_`linkage'.dta"

capture log close