capture log close
args strata database linkage 
log using "$logdir\cr_strata_denoms_`strata'_`database'_`linkage'.txt", replace text

/*
args:
strata = e.g. asthma
database = gold or aurum
linkage = primary or linked
*/

/*******************************************************************************
CREATE DENOMINATOR FILES FOR CHRONIC COMORBIDITIES FOR EACH DATABASE LINKED AND
UNLINKED
= PATIENT LEVEL DATABASE WITH THE FOLLOWING VARIABLES 
patid gender yob startfup endfup died for denominator where startfup and endfup
includes the diagnosis date
*******************************************************************************/

if "`database'" == "gold" {
	use "$datadir\cr_importmedicalcodes_`database'_medcodes.dta", clear
		
	if "`linkage'" == "linked" {
		append using "$rawdatadir\\gold_linked\\hes_diagnosis_epi_20_163R.dta"
		}
	
	keep if `strata' == 1
	keep patid evdate `strata'

	*drop if any records without event date
	bysort patid (evdate): egen maxevdate = max(evdate)
	format maxevdate %dD/N/CY
	drop if maxevdate == .
	drop maxevdate

	bysort patid (evdate): keep if _n == 1

	merge 1:1 patid using "$datadir\cr_studypopulation_foraggregate_`database'_`linkage'.dta"
	keep if _merge == 3

	replace startfup = max(evdate, startfup)
	drop if startfup >= endfup 
	format startfup endfup %td

	keep patid gender yob startfup endfup died evdate
	distinct patid

	save "$datadir\cr_strata_denoms_`strata'_`database'_`linkage'.dta", replace
}


if "`database'" == "aurum" {
	foreach n of numlist 1/10 {
		
		noi di `n'
		use "$datadir\cr_importmedicalcodes_`database'_medcodes_`n'.dta", clear		
			
		keep if `strata' == 1
		keep patid evdate `strata'
	
		count
		if r(N)==0 {
			continue
			}	
		
		*drop if any records without event date
		bysort patid (evdate): egen maxevdate = max(evdate)
		format maxevdate %dD/N/CY
		drop if maxevdate == .
		drop maxevdate
		
		* keep earliest event date
		bysort patid (evdate): keep if _n == 1
		keep patid evdate /*HS added*/
	
	save "$datadir\cr_strata_denoms_`strata'_`database'_`linkage'_`n'.dta", replace
}

/* add records from the 10 files together and keep 1 per patient */
cap erase "$datadir\cr_strata_denoms_`strata'_`database'_`linkage'.dta"

	if "`linkage'" == "linked" {
		use "$rawdatadir\\`database'_linked\\hes_diagnosis_epi_20_163R", clear
		keep if `strata' == 1
		keep patid evdate

		*drop if any records without event date
		bysort patid (evdate): egen maxevdate = max(evdate)
		format maxevdate %dD/N/CY
		drop if maxevdate == .
		drop maxevdate
		
		* keep earliest event date
		bysort patid (evdate): keep if _n == 1
		keep patid evdate /*HS added*/
		tempfile temp
		save `temp'
		}
	
	local i = 0
	forvalues n = 1/10 {
		capture confirm file "$datadir\cr_strata_denoms_`strata'_`database'_`linkage'_`n'.dta"
		if _rc ==0 local i = `i' + 1
		if `i' == 1 use "$datadir\cr_strata_denoms_`strata'_`database'_`linkage'_`n'.dta", clear
		if `i' > 1 append using "$datadir\cr_strata_denoms_`strata'_`database'_`linkage'_`n'.dta"
		di `i'
		}
	
	if "`linkage'" == "linked" append using `temp'

	bysort patid (evdate): keep if _n == 1
	
	merge 1:1 patid using "$datadir\cr_studypopulation_foraggregate_`database'_`linkage'.dta" /*HS changed m:1 to 1:1*/
	keep if _merge == 3
	
	keep patid gender yob startfup endfup died evdate /*HS moved from before bysort*/
	count

	replace startfup = max(evdate, startfup)
	drop if startfup >= endfup 
	
save "$datadir\cr_strata_denoms_`strata'_`database'_`linkage'.dta", replace

* HS added
forvalues n = 1/10 {
	capture erase "$datadir\cr_strata_denoms_`strata'_`database'_`linkage'_`n'.dta"
}
}
			

capture log close