

capture log close
args database linkage

/*******************************************************************************
EXPORT DATA NEEDED FOR EXCESS MORTALITY ESTIMATES FROM TIME SERIES DATA
*******************************************************************************/

capture program drop hsprocessout

program hsprocessout
	args group strata substrata database linkage
	di "group: `group'"
	di "strata: `strata'"
	di "substrata: `substrata'"
	
	use "$estimatedir/an_timeseries_estimates_`group'_`strata'_`database'_`linkage'.dta", clear /*week level dataset*/
	keep if substrata == `substrata'
	
	gen wave1 = 1 if year == 2020 & week >= $wave1start & week <= $wave1end
	keep if wave1 == 1
	
	capture confirm var n_usingPREdata
	if _rc != 0 {
		foreach var in n_usingPREdata n_usingPREdata_se se_predict xb xb_se sdtimesdf_n sdtimesdf_xb {
			gen `var' = .
			}
		}
		else {
			*** pooled standard error
				/*https://stats.libretexts.org/Bookshelves/Applied_Statistics/Book%3A_An_Introduction_to_Psychological_Statistics_(Foster_et_al.)/10%3A__Independent_Samples/10.05%3A_Standard_Error_and_Pooled_Variance*/
				
			gen sdtimesdf_n = (denommillions - 1) * (n_usingPREdata_se)^2
			gen sdtimesdf_xb = (denommillions - 1) * (xb_se)^2
			
			}
	
	collapse (sum) n_usingPREdata deaths denommillions xb sdtimesdf_n sdtimesdf_xb (count) week
	
	gen pooledse_n = .
	gen pooledse_xb = .
	capture replace pooledse_n = sqrt(sdtimesdf_n/(denommillions - week))
	capture replace pooledse_xb = sqrt(sdtimesdf_xb/(denommillions - week))
	
	foreach var in  n_usingPREdata deaths denommillions xb pooledse_n pooledse_xb {
		qui summ `var'
		if `r(N)' > 0 {
			local `var' = `r(max)'
			}
			else {
				local `var' = .
			}
		
		}
	
	qui include "$dodir\inc_strata_names.do"
	
	post results ("`group'") ("`strata'") (`substrata') ("`groupname'") ("`strataname'") ("`substrataname'") (`denommillions') (`deaths') (`n_usingPREdata') (`xb') (`pooledse_n') (`pooledse_xb')


end

cap postutil clear
tempfile results  
postfile results str20(group strata) int(substrata) str60(groupname strataname substrataname) double(denommillions deaths n_usingPREdata xb pooledse_n pooledse_xb) using `results' /*removed totalexcess p5excess p95excess*/


**demographics
hsprocessout "demographics" "studypop" 1 "`database'" "`linkage'"


hsprocessout "demographics" "genderstratum" 1 "`database'" "`linkage'"
hsprocessout "demographics" "genderstratum" 2 "`database'" "`linkage'"

forvalues i = 16/20 {
	hsprocessout "demographics" "agestratum" `i' "`database'" "`linkage'"
	}
	
forvalues i = 1/13 {
	if `i' == 6 continue /*East of England which has been combined with East Midlands*/
	hsprocessout "demographics" "region" `i' "`database'" "`linkage'"
	}
	
forvalues i = 1/2 {
	hsprocessout "demographics" "urban_rural" `i' "`database'" "`linkage'"
	}
	
	
forvalues i = 1/5 {
	hsprocessout "demographics" "deprivation" `i' "`database'" "`linkage'"
	}

forvalues i = 0/3 { /*was 4 but combined other and mixed*/
	hsprocessout "demographics" "ethnicity" `i' "`database'" "`linkage'"
	}
hsprocessout "demographics" "ethnicity" 99 "`database'" "`linkage'"

if "`database'" == "combined" & "`linkage'" == "primary" {
	forvalues i = 0/3 { /*was 4 but combined other and mixed*/
		hsprocessout "demographics" "eth_lon" `i' "`database'" "`linkage'"
		}
	hsprocessout "demographics" "eth_lon" 99 "`database'" "`linkage'"

	forvalues i = 0/3 { /*was 4 but combined other and mixed*/
		hsprocessout "demographics" "eth_nonlon" `i' "`database'" "`linkage'"
		}
	hsprocessout "demographics" "eth_nonlon" 99 "`database'" "`linkage'"
	}
	
**binary
foreach strata in neuro ra psoriasis asthma ht ckd multimorbidity learning diab_perm dementia chronicresp chronic_cardiac cerebrovascular vte { /*removed liver and immuno*/
	hsprocessout "binary" "`strata'" 1 "`database'" "`linkage'"
	}

foreach strata in cancer1yr {
	hsprocessout "cancer" "cancer1yr" 1 "`database'" "`linkage'"
	}


**lifestyle
forvalues i = 0/2 {
	hsprocessout "lifestyle" "smoking" `i' "`database'" "`linkage'"
	}
hsprocessout "lifestyle" "smoking" 99 "`database'" "`linkage'"


forvalues i = 0/4 {
	hsprocessout "lifestyle" "bmi" `i' "`database'" "`linkage'"
	}
hsprocessout "lifestyle" "bmi" 99 "`database'" "`linkage'"


postclose results

use `results', clear

save "$estimatedir\an_timeseries_processout_`database'_`linkage'.dta", replace



