capture log close
log using "$logdir\an_timeseries_modelfit.txt", text replace

*pause on

local database = "combined"
local linkage = "primary"

cap postutil clear
tempfile results  
postfile results str20(group strata) int(substrata) str60(groupname strataname substrataname) double(deathsmean deathssd skewdeviance kurtosisdeviance meanabsdeviance sdabsdeviance  meandevianceprop  sddevianceprop) using `results'

foreach strata in studypop neuro ra psoriasis asthma ht ckd multimorbidity learning diab_perm dementia chronicresp chronic_cardiac cerebrovascular vte cancer1yr {
	local group = "binary"
	local substrata = 1
	if "`strata'" == "cancer1yr" local group = "cancer"
	if "`strata'" == "studypop" local group = "demographics"

	use "$estimatedir/an_timeseries_estimates_`group'_`strata'_`database'_`linkage'.dta", clear
	drop if year == 2020

	keep year week n_usingPREdata deaths
	gen deviance = deaths - n_usingPREdata
	di "`strata'"
	histogram deviance
	pause
	summ deviance, d
	gsort -deviance
	list year week deviance in 1/5
	
	local skew = r(skewness)
	local kurt = r(kurtosis)

	gen absdeviance = abs(deviance)
	summ absdeviance, d
	local mean = r(mean)
	local sd = r(sd)

	summ deaths, d
	local deathsmean = r(mean)
	local deathssd = r(sd)
	
	gen devianceprop = absdeviance/deaths
	summ devianceprop
	local meanprop = r(mean)
	local sdprop = r(sd)
	
	qui include "$dodir\inc_strata_names.do"

	post results ("`group'") ("`strata'") (`substrata') ("`groupname'") ("`strataname'") ("`substrataname'") (`deathsmean') (`deathssd') (`skew') (`kurt') (`mean') (`sd') (`meanprop') (`sdprop')
}
postclose results
use `results', clear

replace strataname = "Study population" if strata == "studypop"
replace strataname = "Other respiratory" if strata == "chronicresp"
replace strataname = "Other neurological" if strata == "neuro"
gen deathsstr = string(deathsmean, "%9.1fc") + " (" + string(deathssd, "%9.1fc") + ")"
gen deviancestr = string(meanabsdeviance, "%9.1fc") + " (" + string(sdabsdeviance, "%9.1fc") + ")"
gen deviancepropstr = string(meandevianceprop, "%9.2fc") + " (" + string(sddevianceprop, "%9.2fc") + ")"
gen skewdeviancestr = string(skewdeviance, "%9.1fc")
gen kurtosisdeviancestr = string(kurtosisdeviance, "%9.1fc")
gsort -deathsmean

keep strataname deathsstr deviancestr deviancepropstr skewdeviancestr kurtosisdeviancestr
order strataname deathsstr deviancestr deviancepropstr skewdeviancestr kurtosisdeviancestr

label variable strataname "Factor"
label variable deathsstr "Mean weekly deaths (sd)"
label variable deviancestr "Mean weekly absolute deviance (sd)"
label variable deviancepropstr "Mean weekly absolute deviance as a proportion of weekly deaths"
label variable skewdeviancestr "Deviance skewness"
label variable kurtosisdeviancestr "Deviance kurtosis"

export excel using "$resultdir\an_timeseries_modelfit.xlsx", replace firstrow(varlabels)

*note histograms show near normal distribution with some outliers which are evident on the graphs

pause off

capture log close

