
args database linkage

capture log close
log using "$logdir\an_timeseries_graphs_supplementary_`database'_`linkage'.txt", replace text

/*******************************************************************************
GRAPHS TO SHOW MODEL FIT FOR TIME SERIES ANALYSES
******************************************************************************/

capture program drop hssensgraphs

program define hssensgraphs
	args group strata database linkage substrata
	noi di as yellow "group: `group'"
	noi di as yellow "strata: `strata'"
	noi di as yellow "database: `database'"
	noi di as yellow "linkage: `linkage'"
	*noi di as yellow "special: `special'"
	noi di as yellow "substrata: `substrata'"
	
	use "$estimatedir/an_timeseries_estimates_`group'_`strata'_`database'_`linkage'.dta", clear
	
	if "`group'" == "lifestyle" | "`strata'" == "ethnicity" keep if substrata == `substrata'
	
	capture confirm variable n_usingPREdata
	if _rc > 0 gen n_usingPREdata = 0
	
	*gen n_splinepermill = n_spline/denommillions
	gen n_usingPREdatapermill = n_usingPREdata/denommillions
	gen deathspermill = deaths/denommillions
	
	foreach time in start end {
		qui summ weekfrom if year == 2020 & week == ${wave1`time'}
		local wave1`time' = `r(min)'
		}
	
	qui include "$dodir\inc_strata_names.do"

	if "`strata'" == "studypop" local strataname = "Study population" 
	if "`strata'" == "chronicresp" local strataname = "Other respiratory" 
	if "`strata'" == "neuro" local strataname = "Other neurological" 
	*if `special' == 1 local strataname = "`strata'"

	noi di "strataname: `strataname'"
	noi di "substrataname: `substrataname'"
	if "`group'" == "lifestyle" | "`strata'" == "ethnicity" {
		local strata = "`strata'`substrata'"
		di "`strata'"
		local strataname = "`substrataname'"
		di "`strataname'"
		}
	
	*y axis range
	qui summ deathspermill /*n_splinepermill*/
	
	local ymax = ceil(r(max)/1000) * 1000
	if `ymax' <= 1000 local yint = 200
	if `ymax' > 1000 & `ymax' < 3000 local yint = 500
	if `ymax' >= 3000 & `ymax' < 5000 local yint = 1000
	if `ymax' >= 5000 & `ymax' < 10000 local yint = 2000
	if `ymax' >=10000 & `ymax' < 30000 local yint = 5000
	if `ymax' >=30000 local yint = 10000

	
	*x axis range
	local endday = ${studyend_`linkage'} - d(01/01/2020)
	local endweek = floor(`endday'/7)
	noi di as yellow "end week: `endweek'"
	qui summ weekfrom if year == 2020 & week == `endweek'
	local endweek = `r(min)'
	noi di as yellow "end week: `endweek'"
	keep if week <= `endweek'
	
	/*line n_splinepermill weekfrom, lc(red) || /// */
	
	line n_usingPREdatapermill weekfrom, lc(gs7) || ///
	scatter deathspermill weekfrom, msize(tiny) mcolor(green) || ///
	, xline(`wave1start', lp(dot) lwidth(medium) lcolor(gs1)) /// start of wave 1
	xline(`wave1end', lp(dot) lwidth(medium) lcolor(gs1)) /// end of wave 1
	title("`strataname'", size(medium)) /// strataname
	xtitle("") ///
	xscale(range($wave1start `endweek') noline) ///
	xlabel(none) ///
	yline(0, lc(black)) /// replaces X axis
	ytitle("Deaths per million person-weeks") ///
	yscale(range(-10 `ymax')) ///
	ylab(0 (`yint')`ymax', labsize(small)) ///
	legend(off) ///
	graphregion(color(white))	/// get rid of rubbish grey/blue around graph
	text(-5 $wave1start "2015", place(s) size(small)) ///
	text(-5 53 "2016", place(s) size(small)) ///
	text(-5 105 "2017", place(s) size(small)) ///
	text(-5 157 "2018", place(s) size(small)) ///
	text(-5 209 "2019", place(s) size(small)) ///
	text(-5 261 "2020", place(s) size(small)) ///
	name("`strata'", replace) /// strata
	
end

	*legend(label(1 "observed (spline smoothed)") label(2 "expected from year/season model") label(3 "observed deaths") ) ///


hssensgraphs demographics studypop "`database'" "`linkage'" .

foreach strata in cancer1yr diab_perm ckd ht chronic_cardiac cerebrovascular vte asthma chronicresp ra psoriasis learning neuro dementia multimorbidity { /*removed immuno and liver*/
	if "`strata'" == "cancer1yr" {
		local group = "cancer"
		}
		else {
			local group = "binary"
		}
			
		
	hssensgraphs "`group'" "`strata'" "`database'" "`linkage'" .
	
}

graph combine studypop cancer1yr diab_perm ckd ht chronic_cardiac cerebrovascular vte asthma chronicresp ra psoriasis learning neuro dementia, cols(3) xsize(7.9) ysize(11.4) imargins(tiny) /*08/09/2021 - added studypop, removed multimorbidity*/
graph export "$resultdir\an_timeseries_graphs_supplementary_binary_`database'_`linkage'.emf", replace




foreach strata in cancer1yr cancer3mo cancer3mo1yr haemever nonhaemever haem1yr nonhaem1yr haem5yr nonhaem5yr  {
	
	local group = "cancer"

	hssensgraphs "`group'" "`strata'" "`database'" "`linkage'" .
}

graph combine cancer1yr cancer3mo cancer3mo1yr haemever nonhaemever haem1yr nonhaem1yr haem5yr nonhaem5yr, xsize(7.9) ysize(11.4) imargins(tiny) cols(3)
graph export "$resultdir\an_timeseries_graphs_supplementary_cancer_`database'_`linkage'.emf", replace

*/

/*
foreach strata in cardiac1yr cardiac5yr cardiacever  {
	
	local group = "chronic_cardiac"
	local special = 1

	hssensgraphs "`group'" "`strata'" "`database'" "`linkage'" "1"
}

graph combine cardiac1yr cardiac5yr cardiacever, xsize(11.0) ysize(6.2) imargins(tiny)
graph export "$resultdir\an_timeseries_graphs_supplementary_chronic_cardiac_`database'_`linkage'.emf", replace
x

local database = "gold"
local linkage = "primary"

local group = "lifestyle"

forvalues substrata = 0/5 { 
	hssensgraphs "`group'" "bmi" "`database'" "`linkage'" `substrata'
	}
hssensgraphs "`group'" "bmi" "`database'" "`linkage'" 99
graph combine bmi0 bmi1 bmi2 bmi3 bmi4 bmi5 bmi99, xsize(11.0) ysize(6.2) imargins(tiny)

**

local database = "aurum"
local linkage = "primary"

local group = "demographics"

forvalues substrata = 0/4 { 
	hssensgraphs "`group'" "ethnicity" "`database'" "`linkage'" `substrata'
	}
hssensgraphs "`group'" "ethnicity" "`database'" "`linkage'" 99
graph combine ethnicity0 ethnicity1 ethnicity2 ethnicity3 ethnicity4 ethnicity99, xsize(11.0) ysize(6.2) imargins(tiny)

foreach database in aurum {
foreach linkage in primary linked {
	hssensgraphs "binary" "cerebrovascular" "`database'" "`linkage'" .
	}
	}
	
hssensgraphs "binary" "cerebrovascularlinkpop" "aurum" "primary" .
	
graph combine aurumprimary aurumlinked cerebrovascularlinkpop
graph combine primary linked cerebrovascularlinkpop
*/


capture log close