capture log close
* running for CPRD GOLD, `strata', primary care only as practice
log using "$logdir\an_timeseries_graphs.txt", replace text

/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/

/*foreach strata in chronicresp diab_perm chronic_cardiac cerebrovascular vte learning neuro dementia liver ra psoriasis asthma  /*lupus cancer1yr*/ {
local group = "binary"
if "`strata'" == "cancerlyr" local group = "cancer"
*/

local group = "demographics"
local strata = "studypop"

forvalues sex = 1/2 {
foreach agebin in old young {
di as yellow "sex: `sex', agebin: `agebin'"

if "`agebin'" == "young" local agelabel = "Young (40 to 69)" 
if "`agebin'" == "old" local agelabel = "Old (70 plus)" 
if `sex' == 1 local sexlabel = "Male" 
if `sex' == 2 local sexlabel = "Female" 
local strata = "`strata'"
do "$dodir\inc_strata_names"


use "$estimatedir/an_timeseries_estimates_`group'_`strata'_`agebin'_`sex'_combined_primary.dta", clear


*Display observed (smooth spline) vs expected (year & season model)
line n_spline weekfrom, lc(red) || line n_usingPREdata weekfrom, lc(gs7) || scatter deaths weekfrom, msize(vsmall) ,  xline(269, lp(dash)) name(observedexpected, replace) legend(label(1 "observed (spline smoothed)") label(2 "expected from year/season model") )
*week 269 = Feb 26th 2020
*graph export "$resultdir/an_timeseries_graphs_postpre_temp.emf", replace

gen n_splinepermill = n_spline/denommillions
gen n_usingPREdatapermill = n_usingPREdata/denommillions
gen deathspermill = deaths/denommillions



*numbers for total excess mortality box
gen excess = n_splinepermill - n_usingPREdatapermill if weekfrom >= 269 /*Feb 26th 2020*/
egen totalexcess = total(excess) if weekfrom >= 269
egen totalexpected = total(n_usingPREdatapermill) if weekfrom >= 269
egen totalobserved = total(n_splinepermill) if weekfrom >= 269

qui summ totalexcess
local totalexcess = `r(max)'
qui summ totalexpected
local totalexpected = `r(max)'
qui summ totalobserved
local totalobserved = `r(max)'
local percentexcess = (`totalexcess'/`totalobserved')*100
local totalexcessstr = string(`totalexcess', "%9.0f")
local percentexcessstr = string(`percentexcess', "%9.1f")

*x axis range
local endday = $studyend_primary - d(01/01/2020)
local endweek = floor(`endday'/7)
di as yellow "end week: `endweek'"
keep if week <= `endweek'

*y axis range
qui summ n_splinepermill
local ymax = ceil(r(max)/1000) * 1000
if `ymax' <= 1000 local yint = 200
if `ymax' > 1000 & `ymax' < 3000 local yint = 500
if `ymax' >= 3000 & `ymax' < 10000 local yint = 1000
if `ymax' >=10000 local yint = 5000


line n_splinepermill week if year == 2015, lc(gs10)  || /// Observed in recent years (spline smoothed)
line n_splinepermill week if year == 2016, lc(gs10)  || ///
line n_splinepermill week if year == 2017, lc(gs10)  || ///
line n_splinepermill week if year == 2018, lc(gs10)  || ///
line n_splinepermill week if year == 2019, lc(gs10)  || ///
line n_splinepermill week if year == 2020, lc(red)   || /// Observed in 2020 (spline smoothed)
line n_usingPREdatapermill week if year == 2020, lc(gs1) || /// Expected in 2020 (year season model)
rarea n_usingPREdatapermill n_splinepermill week if year == 2020, color(red%50) lwidth(none) || /// Total excess deaths until end of study period
scatter deathspermill week if year == 2020, msize(vsmall) mcol(gs10) || /// Observed in 2020 (scatter)
, xline(10, lp(dash)) /// start of pandemic
title("`agelabel'_`sexlabel'", size(small)) ///
xtitle("") ///
xscale(range(1 `endweek') noline) ///
xlabel(none) ///
yline(0, lc(black)) /// replaces X axis
ytitle("deaths per million") ///
yscale(range(-10 `ymax')) ///
ylab(0(`yint')`ymax', labsize(small)) ///
graphregion(color(white))	/// get rid of rubbish grey/blue around graph
legend(off) ///
text(-5 1 "Jan", place(s)) ///
text(-5 11 "March", place(s)) ///
text(-5 19 "May", place(s)) ///
text(-5 27 "July", place(s)) ///
text(-5 48 "Dec", place(s)) ///
text(1000 25 "`totalexcessstr' excess deaths" "per million (`percentexcessstr'%)") ///
name("`agebin'_`sex'", replace)
/*alternatively could label end of data collection period*/

}
}

graph combine old_1 old_2 young_1 young_2, title("`name'")

graph export "$resultdir\an_timeseries_graphs_`strata'_combined_primary.emf", replace

}

/*

*/